/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.tokens;

import com.tencent.tendon.convert.json.JsonPoolable;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonToken;
import com.tencent.tendon.convert.json.JsonXListener;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonFloatArrayToken
extends JsonToken<float[]> {
    public static final JsonFloatArrayToken instance = new JsonFloatArrayToken();
    private static final JsonXListener listener = JsonXListener.getInstance();

    @Override
    public float[] convertFrom(JsonReader jsonReader) {
        JsonFloatArrayList jsonFloatArrayList = JsonFloatArrayList.poll();
        jsonReader.checkArray();
        while (jsonReader.hasNext()) {
            jsonFloatArrayList.add(listener.convertFloatFrom(jsonReader));
        }
        float[] fArray = jsonFloatArrayList.toArray();
        JsonFloatArrayList.offer(jsonFloatArrayList);
        return fArray;
    }

    @Override
    public Class<float[]> getType() {
        return float[].class;
    }

    public Class getComponentType() {
        return Float.TYPE;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static final class JsonFloatArrayList
    implements JsonPoolable {
        private static final Queue<JsonFloatArrayList> queue = new ArrayBlockingQueue<JsonFloatArrayList>(Math.max(Runtime.getRuntime().availableProcessors(), 2) * 2);
        private float[] data;
        private int size;

        public static JsonFloatArrayList poll() {
            JsonFloatArrayList jsonFloatArrayList = queue.poll();
            if (jsonFloatArrayList == null) {
                jsonFloatArrayList = new JsonFloatArrayList();
            } else {
                jsonFloatArrayList.prepare();
            }
            return jsonFloatArrayList;
        }

        public static void offer(JsonFloatArrayList jsonFloatArrayList) {
            if (jsonFloatArrayList != null) {
                jsonFloatArrayList.release();
                queue.offer(jsonFloatArrayList);
            }
        }

        public JsonFloatArrayList() {
            this(8);
        }

        public JsonFloatArrayList(int n) {
            this.data = new float[n];
        }

        private void grow() {
            float[] fArray = new float[this.data.length + 8];
            System.arraycopy(this.data, 0, fArray, 0, this.size);
            this.data = fArray;
        }

        public void add(float f) {
            if (this.size == this.data.length) {
                this.grow();
            }
            this.data[this.size++] = f;
        }

        public float[] toArray() {
            if (this.size == this.data.length) {
                return this.data;
            }
            float[] fArray = new float[this.size];
            System.arraycopy(this.data, 0, fArray, 0, this.size);
            return fArray;
        }

        public void prepare() {
        }

        public void release() {
            this.size = 0;
            this.data = new float[8];
        }

        public void clear() {
            this.release();
        }
    }
}

