/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.tokens;

import com.tencent.tendon.convert.json.JsonPoolable;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonToken;
import com.tencent.tendon.convert.json.JsonXListener;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonLongArrayToken
extends JsonToken<long[]> {
    public static final JsonLongArrayToken instance = new JsonLongArrayToken();
    private static final JsonXListener listener = JsonXListener.getInstance();

    @Override
    public long[] convertFrom(JsonReader jsonReader) {
        JsonLongArrayList jsonLongArrayList = JsonLongArrayList.poll();
        jsonReader.checkArray();
        while (jsonReader.hasNext()) {
            jsonLongArrayList.add(listener.convertLongFrom(jsonReader));
        }
        long[] lArray = jsonLongArrayList.toArray();
        JsonLongArrayList.offer(jsonLongArrayList);
        return lArray;
    }

    @Override
    public Class<long[]> getType() {
        return long[].class;
    }

    public Class getComponentType() {
        return Long.TYPE;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static final class JsonLongArrayList
    implements JsonPoolable {
        private static final Queue<JsonLongArrayList> queue = new ArrayBlockingQueue<JsonLongArrayList>(Math.max(Runtime.getRuntime().availableProcessors(), 2) * 2);
        private long[] data;
        private int size;

        public static JsonLongArrayList poll() {
            JsonLongArrayList jsonLongArrayList = queue.poll();
            if (jsonLongArrayList == null) {
                jsonLongArrayList = new JsonLongArrayList();
            } else {
                jsonLongArrayList.prepare();
            }
            return jsonLongArrayList;
        }

        public static void offer(JsonLongArrayList jsonLongArrayList) {
            if (jsonLongArrayList != null) {
                jsonLongArrayList.release();
                queue.offer(jsonLongArrayList);
            }
        }

        public JsonLongArrayList() {
            this(8);
        }

        public JsonLongArrayList(int n) {
            this.data = new long[n];
        }

        private void grow() {
            long[] lArray = new long[this.data.length + 8];
            System.arraycopy(this.data, 0, lArray, 0, this.size);
            this.data = lArray;
        }

        public void add(long l) {
            if (this.size == this.data.length) {
                this.grow();
            }
            this.data[this.size++] = l;
        }

        public long[] toArray() {
            if (this.size == this.data.length) {
                return this.data;
            }
            long[] lArray = new long[this.size];
            System.arraycopy(this.data, 0, lArray, 0, this.size);
            return lArray;
        }

        public void prepare() {
        }

        public void release() {
            this.size = 0;
            this.data = new long[8];
        }

        public void clear() {
            this.release();
        }
    }
}

