/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.tokens;

import com.tencent.tendon.convert.json.JsonPoolable;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonToken;
import com.tencent.tendon.convert.json.JsonXListener;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonShortArrayToken
extends JsonToken<short[]> {
    public static final JsonShortArrayToken instance = new JsonShortArrayToken();
    private static final JsonXListener listener = JsonXListener.getInstance();

    @Override
    public short[] convertFrom(JsonReader jsonReader) {
        JsonShortArrayList jsonShortArrayList = JsonShortArrayList.poll();
        jsonReader.checkArray();
        while (jsonReader.hasNext()) {
            jsonShortArrayList.add(listener.convertShortFrom(jsonReader));
        }
        short[] sArray = jsonShortArrayList.toArray();
        JsonShortArrayList.offer(jsonShortArrayList);
        return sArray;
    }

    @Override
    public Class<short[]> getType() {
        return short[].class;
    }

    public Class getComponentType() {
        return Short.TYPE;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static final class JsonShortArrayList
    implements JsonPoolable {
        private static final Queue<JsonShortArrayList> queue = new ArrayBlockingQueue<JsonShortArrayList>(Math.max(Runtime.getRuntime().availableProcessors(), 2) * 2);
        private short[] data;
        private int size;

        public static JsonShortArrayList poll() {
            JsonShortArrayList jsonShortArrayList = queue.poll();
            if (jsonShortArrayList == null) {
                jsonShortArrayList = new JsonShortArrayList();
            } else {
                jsonShortArrayList.prepare();
            }
            return jsonShortArrayList;
        }

        public static void offer(JsonShortArrayList jsonShortArrayList) {
            if (jsonShortArrayList != null) {
                jsonShortArrayList.release();
                queue.offer(jsonShortArrayList);
            }
        }

        public JsonShortArrayList() {
            this(8);
        }

        public JsonShortArrayList(int n) {
            this.data = new short[n];
        }

        private void grow() {
            short[] sArray = new short[this.data.length + 8];
            System.arraycopy(this.data, 0, sArray, 0, this.size);
            this.data = sArray;
        }

        public void add(short s) {
            if (this.size == this.data.length) {
                this.grow();
            }
            this.data[this.size++] = s;
        }

        public short[] toArray() {
            if (this.size == this.data.length) {
                return this.data;
            }
            short[] sArray = new short[this.size];
            System.arraycopy(this.data, 0, sArray, 0, this.size);
            return sArray;
        }

        public void prepare() {
        }

        public void release() {
            this.size = 0;
            this.data = new short[8];
        }

        public void clear() {
            this.release();
        }
    }
}

