/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.tokens;

import com.tencent.tendon.convert.json.JsonPoolable;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonToken;
import com.tencent.tendon.convert.json.JsonXListener;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonStringArrayToken
extends JsonToken<String[]> {
    public static final JsonStringArrayToken instance = new JsonStringArrayToken();
    private static final JsonXListener listener = JsonXListener.getInstance();

    @Override
    public String[] convertFrom(JsonReader jsonReader) {
        JsonStringArrayList jsonStringArrayList = JsonStringArrayList.poll();
        jsonReader.checkArray();
        while (jsonReader.hasNext()) {
            jsonStringArrayList.add(listener.convertStringFrom(jsonReader));
        }
        String[] stringArray = jsonStringArrayList.toArray();
        JsonStringArrayList.offer(jsonStringArrayList);
        return stringArray;
    }

    @Override
    public Class<String[]> getType() {
        return String[].class;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static final class JsonStringArrayList
    implements JsonPoolable {
        private static final Queue<JsonStringArrayList> queue = new ArrayBlockingQueue<JsonStringArrayList>(Math.max(Runtime.getRuntime().availableProcessors(), 2) * 2);
        private String[] data;
        private int size;

        public static JsonStringArrayList poll() {
            JsonStringArrayList jsonStringArrayList = queue.poll();
            if (jsonStringArrayList == null) {
                jsonStringArrayList = new JsonStringArrayList();
            } else {
                jsonStringArrayList.prepare();
            }
            return jsonStringArrayList;
        }

        public static void offer(JsonStringArrayList jsonStringArrayList) {
            if (jsonStringArrayList != null) {
                jsonStringArrayList.release();
                queue.offer(jsonStringArrayList);
            }
        }

        public JsonStringArrayList() {
            this(8);
        }

        public JsonStringArrayList(int n) {
            this.data = new String[n];
        }

        private void grow() {
            String[] stringArray = new String[this.data.length + 8];
            System.arraycopy(this.data, 0, stringArray, 0, this.size);
            this.data = stringArray;
        }

        public void add(String string) {
            if (this.size == this.data.length) {
                this.grow();
            }
            this.data[this.size++] = string;
        }

        public String[] toArray() {
            if (this.size == this.data.length) {
                return this.data;
            }
            String[] stringArray = new String[this.size];
            System.arraycopy(this.data, 0, stringArray, 0, this.size);
            return stringArray;
        }

        public void prepare() {
        }

        public void release() {
            this.size = 0;
            this.data = new String[8];
        }

        public void clear() {
            this.release();
        }
    }
}

