/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateConverter
extends AbstractConverter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = data.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        try {
            long millis = 0L;
            if (value.length() > 0) {
                millis = Long.parseLong(value);
            }
            Date date = new Date(millis);
            if (paramType == Date.class) {
                return date;
            }
            if (paramType == java.sql.Date.class) {
                return new java.sql.Date(date.getTime());
            }
            if (paramType == Time.class) {
                return new Time(date.getTime());
            }
            if (paramType == Timestamp.class) {
                return new Timestamp(date.getTime());
            }
            if (paramType == Calendar.class) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                return cal;
            }
            throw new ConversionException(paramType);
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        long millis;
        if (data instanceof Calendar) {
            Calendar cal = (Calendar)data;
            millis = cal.getTime().getTime();
        } else if (data instanceof Date) {
            Date date = (Date)data;
            millis = date.getTime();
        } else {
            throw new ConversionException(data.getClass());
        }
        return new NonNestedOutboundVariable("new Date(" + millis + ")");
    }
}

