/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.Property;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedProperty
implements Property {
    private final Property parent;
    private final Object object;
    private final int parameterNumber;
    private final Type parameterType;
    private final int newParameterNumber;

    public NestedProperty(Property parent, Object method, Type parentParameterType, int parameterNumber, int newParameterNumber) {
        this.parent = parent;
        if (parentParameterType instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)parentParameterType;
            Type[] actualTypeArguments = ptype.getActualTypeArguments();
            if (newParameterNumber >= actualTypeArguments.length) {
                throw new IllegalArgumentException("newParameterNumber=" + newParameterNumber + " is too big when parameterType=" + parentParameterType + " give actualTypeArguments.length=" + actualTypeArguments.length);
            }
            this.parameterType = actualTypeArguments[newParameterNumber];
        } else {
            this.parameterType = null;
        }
        this.object = method;
        this.parameterNumber = parameterNumber;
        this.newParameterNumber = newParameterNumber;
    }

    @Override
    public String getName() {
        return "NestedProperty";
    }

    @Override
    public Class<?> getPropertyType() {
        return LocalUtil.toClass(this.parameterType, this.toString());
    }

    @Override
    public Object getValue(Object bean) throws ConversionException {
        throw new UnsupportedOperationException("Can't get value from nested property");
    }

    @Override
    public void setValue(Object bean, Object value) throws ConversionException {
        throw new UnsupportedOperationException("Can't set value to nested property");
    }

    @Override
    public Property createChild(int aNewParameterNumber) {
        return new NestedProperty(this, this.object, this.parameterType, this.parameterNumber, aNewParameterNumber);
    }

    public Type getParameterType() {
        return this.parameterType;
    }

    public int hashCode() {
        return this.object.hashCode() + this.parameterNumber;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NestedProperty that = (NestedProperty)obj;
        if (!this.object.equals(that.object)) {
            return false;
        }
        if (!this.parent.equals(that.parent)) {
            return false;
        }
        if (this.newParameterNumber != that.newParameterNumber) {
            return false;
        }
        return this.parameterNumber == that.parameterNumber;
    }

    public String toString() {
        if (this.object instanceof Method) {
            Method method = (Method)this.object;
            return "(method=" + method.toGenericString() + ", parameter: " + this.parameterNumber + ")";
        }
        if (this.object instanceof Constructor) {
            Constructor ctor = (Constructor)this.object;
            return "(method=" + ctor.toGenericString() + ", parameter: " + this.parameterNumber + ")";
        }
        return "(method=" + this.object.toString() + ", parameter: " + this.parameterNumber + ")";
    }
}

