/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.io.IOException;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptConduit
implements Comparable<ScriptConduit> {
    public static final int RANK_PROCEDURAL = 10;
    public static final int RANK_FAST = 5;
    public static final int RANK_SLOW = 1;
    private boolean holdingConnectionToBrowser;
    private int rank;
    private final long id = ScriptConduit.getNextId();
    private static long nextId = 0L;

    public ScriptConduit(int rank, boolean holdingConnectionToBrowser) {
        this.rank = rank;
        this.holdingConnectionToBrowser = holdingConnectionToBrowser;
    }

    public int getRank() {
        return this.rank;
    }

    public abstract boolean addScript(ScriptBuffer var1) throws IOException, ConversionException;

    public boolean isHoldingConnectionToBrowser() {
        return this.holdingConnectionToBrowser;
    }

    @Override
    public int compareTo(ScriptConduit that) {
        int rankdiff = that.getRank() - this.getRank();
        if (rankdiff != 0) {
            return rankdiff;
        }
        return (int)(this.id - that.id);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScriptConduit that = (ScriptConduit)obj;
        return this.id == that.id;
    }

    public int hashCode() {
        return 17 + (int)this.id;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + "]";
    }

    private static synchronized long getNextId() {
        return ++nextId;
    }
}

