/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.ServerContext;
import org.directwebremoting.ServerContextFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.guice.AbstractDwrModule;
import org.directwebremoting.guice.ApplicationScoped;
import org.directwebremoting.guice.Dwr;
import org.directwebremoting.guice.DwrGuiceUtil;
import org.directwebremoting.guice.DwrScopes;
import org.directwebremoting.guice.GlobalApplicationScoped;
import org.directwebremoting.guice.RequestParameters;
import org.directwebremoting.guice.RequestScoped;
import org.directwebremoting.guice.ScriptSessionScoped;
import org.directwebremoting.guice.SessionScoped;

class DwrGuiceServletModule
extends AbstractDwrModule {
    private final Provider<HttpServletRequest> requestProvider = new Provider<HttpServletRequest>(){

        public HttpServletRequest get() {
            WebContext webcx = WebContextFactory.get();
            return webcx.getHttpServletRequest();
        }

        public String toString() {
            return "RequestProvider";
        }
    };
    private final Provider<HttpServletResponse> responseProvider = new Provider<HttpServletResponse>(){

        public HttpServletResponse get() {
            WebContext webcx = WebContextFactory.get();
            return webcx.getHttpServletResponse();
        }

        public String toString() {
            return "ResponseProvider";
        }
    };
    private final Provider<HttpSession> sessionProvider = new Provider<HttpSession>(){

        public HttpSession get() {
            WebContext webcx = WebContextFactory.get();
            return webcx.getSession();
        }

        public String toString() {
            return "SessionProvider";
        }
    };
    private final Provider<Map<String, String[]>> requestParametersProvider = new Provider<Map<String, String[]>>(){

        public Map<String, String[]> get() {
            WebContext webcx = WebContextFactory.get();
            return webcx.getHttpServletRequest().getParameterMap();
        }

        public String toString() {
            return "RequestParametersProvider";
        }
    };
    private final Provider<ScriptSession> scriptSessionProvider = new Provider<ScriptSession>(){

        public ScriptSession get() {
            WebContext webcx = WebContextFactory.get();
            return webcx.getScriptSession();
        }

        public String toString() {
            return "ScriptSessionProvider";
        }
    };
    private final Provider<ServletContext> servletContextProvider = new Provider<ServletContext>(){

        public ServletContext get() {
            return DwrGuiceUtil.getServletContext();
        }

        public String toString() {
            return "ServletContextProvider";
        }
    };
    private final Provider<WebContext> webContextProvider = new Provider<WebContext>(){

        public WebContext get() {
            return WebContextFactory.get();
        }

        public String toString() {
            return "WebContextProvider";
        }
    };
    private final Provider<ServerContext> serverContextProvider = new Provider<ServerContext>(){

        public ServerContext get() {
            return ServerContextFactory.get();
        }

        public String toString() {
            return "ServerContextProvider";
        }
    };

    DwrGuiceServletModule(boolean bindPotentiallyConflictingTypes) {
        this.bindPotentiallyConflictingTypes = bindPotentiallyConflictingTypes;
    }

    protected void configure() {
        this.bindScope(RequestScoped.class, DwrScopes.REQUEST);
        this.bindScope(SessionScoped.class, DwrScopes.SESSION);
        this.bindScope(ScriptSessionScoped.class, DwrScopes.SCRIPT);
        this.bindScope(ApplicationScoped.class, DwrScopes.APPLICATION);
        this.bindScope(GlobalApplicationScoped.class, DwrScopes.GLOBAL);
        if (this.bindPotentiallyConflictingTypes.booleanValue()) {
            this.bind(ServletRequest.class).toProvider(this.requestProvider);
            this.bind(HttpServletRequest.class).toProvider(this.requestProvider);
            this.bind(ServletResponse.class).toProvider(this.responseProvider);
            this.bind(HttpServletResponse.class).toProvider(this.responseProvider);
            this.bind(HttpSession.class).toProvider(this.sessionProvider);
            this.bind(ServletContext.class).toProvider(this.servletContextProvider);
        }
        this.bind(ServletRequest.class).annotatedWith(Dwr.class).toProvider(this.requestProvider);
        this.bind(HttpServletRequest.class).annotatedWith(Dwr.class).toProvider(this.requestProvider);
        this.bind(ServletResponse.class).annotatedWith(Dwr.class).toProvider(this.responseProvider);
        this.bind(HttpServletResponse.class).annotatedWith(Dwr.class).toProvider(this.responseProvider);
        this.bind(HttpSession.class).annotatedWith(Dwr.class).toProvider(this.sessionProvider);
        this.bind(ServletContext.class).annotatedWith(Dwr.class).toProvider(this.servletContextProvider);
        this.bind((TypeLiteral)new TypeLiteral<Map<String, String[]>>(){}).annotatedWith(RequestParameters.class).toProvider(this.requestParametersProvider);
        this.bind(ScriptSession.class).toProvider(this.scriptSessionProvider);
        this.bind(WebContext.class).toProvider(this.webContextProvider);
        this.bind(ServerContext.class).toProvider(this.serverContextProvider);
    }
}

