/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.ServerContext;
import org.directwebremoting.ServerContextFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.impl.DefaultServerContext;
import org.directwebremoting.impl.StartupUtil;

public class DefaultServerContextBuilder
implements ServerContextFactory.ServerContextBuilder {
    private static final Log log = LogFactory.getLog(DefaultServerContextBuilder.class);

    public ServerContext get() {
        ServerContext serverContext = WebContextFactory.get();
        if (serverContext == null && (serverContext = StartupUtil.getSingletonServerContext()) == null) {
            log.fatal((Object)"Error initializing ServerContext because this is not a DWR thread and there is more than one DWR servlet in the current classloader.");
            log.fatal((Object)"This probably means that either DWR has not been properly initialized (in which case you should delay the current action until it has)");
            log.fatal((Object)"or that there is more than 1 DWR servlet is configured in this classloader, in which case you should provide a ServletContext to the get() yourself.");
            throw new IllegalStateException("No singleton ServerContext see logs for possible causes and solutions.");
        }
        return serverContext;
    }

    public ServerContext get(ServerContext context) {
        return context;
    }

    public ServerContext attach(Container container) {
        try {
            return container.newInstance(DefaultServerContext.class);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

