/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.WaitController;
import org.directwebremoting.impl.AbstractServerLoadMonitor;
import org.directwebremoting.util.HitMonitor;

public class ThrottlingServerLoadMonitor
extends AbstractServerLoadMonitor
implements Runnable {
    protected static final int usageHighDisconnectedTime = 1000;
    protected static final int usageHighInitialConnectedTime = 49000;
    protected static final int usageHighFinalConnectedTime = 1000;
    protected static final int usageDiggConnectedTime = 0;
    protected static final int usageDiggMinDisconnectedTime = 2000;
    protected static final int hitOutRoundTripTime = 2000;
    protected static final int threadOutRoundTripTime = 50000;
    protected static final int roundTripAtThreadOutSeconds = 50;
    protected int maxWaitingThreads = 100;
    protected int maxHitsPerSecond = 100;
    protected int maxConnectedTime = 60000;
    protected static final int USAGE_LOW = 0;
    protected static final int USAGE_HIGH = 1;
    protected static final int USAGE_DIGG = 2;
    protected static final String[] USAGE_NAMES = new String[]{"Low", "High", "Digg"};
    protected int mode = 0;
    protected int connectedTime = 60000;
    protected int disconnectedTime = 1000;
    protected static final int SECONDS_MONITORED = 10;
    protected HitMonitor hitMonitor = new HitMonitor(10);
    protected int waitingThreads = 0;
    private static final Object WAITING_THREADS_LOCK = new Object();
    protected static final Object SERVER_MONITOR_LOCK = new Object();
    protected static final Object SERVER_SLEEP_LOCK = new Object();
    private static boolean running = false;
    private static Thread t;
    private static final Log log;

    public boolean supportsStreaming() {
        return true;
    }

    public long getConnectedTime() {
        return this.connectedTime;
    }

    public int getDisconnectedTime() {
        return this.disconnectedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadWaitStarting(WaitController controller) {
        super.threadWaitStarting(controller);
        this.hitMonitor.recordHit();
        Object object = WAITING_THREADS_LOCK;
        synchronized (object) {
            ++this.waitingThreads;
        }
        this.notifyLoadMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadWaitEnding(WaitController controller) {
        super.threadWaitEnding(controller);
        Object object = WAITING_THREADS_LOCK;
        synchronized (object) {
            --this.waitingThreads;
        }
        this.notifyLoadMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThrottlingServerLoadMonitor() {
        Object object = SERVER_MONITOR_LOCK;
        synchronized (object) {
            if (t == null) {
                t = new Thread(this);
                t.setDaemon(true);
                t.setName("ThrottlingServerLoadMonitor");
                t.start();
                do {
                    Thread thread = t;
                    synchronized (thread) {
                        try {
                            t.wait(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (!running);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        running = true;
        Thread thread = t;
        synchronized (thread) {
            t.notify();
        }
        int ONE_HOUR = 3600000;
        do {
            try {
                Object object = SERVER_MONITOR_LOCK;
                synchronized (object) {
                    this.debug("Waiting for client requests for up to an hour.");
                    SERVER_MONITOR_LOCK.wait(3600000L);
                    if (!running) {
                        break;
                    }
                    this.debug("Adjusting for server load.");
                    this.loadAdjust();
                }
                object = SERVER_SLEEP_LOCK;
                synchronized (object) {
                    this.debug("Sleeping to avoid client request overflow.");
                    SERVER_SLEEP_LOCK.wait(5000L);
                }
            }
            catch (InterruptedException ex) {
                log.error((Object)"Thread was interrupted.");
            }
        } while (running);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLoadMonitor() {
        Object object = SERVER_MONITOR_LOCK;
        synchronized (object) {
            SERVER_MONITOR_LOCK.notify();
        }
    }

    private void debug(Object o) {
        if (log.isDebugEnabled()) {
            log.debug(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed() {
        try {
            Object object = SERVER_MONITOR_LOCK;
            synchronized (object) {
                running = false;
                this.notifyLoadMonitor();
            }
            object = SERVER_SLEEP_LOCK;
            synchronized (object) {
                SERVER_SLEEP_LOCK.notify();
            }
            t.join(10L);
        }
        catch (InterruptedException ex) {
            log.error((Object)"Thread shutdown was interrupted.");
        }
        finally {
            super.contextDestroyed();
        }
    }

    private void loadAdjust() {
        if (this.waitingThreads < this.maxWaitingThreads) {
            this.changeMode(0, this.maxConnectedTime, this.disconnectedTime);
            return;
        }
        float hitsPerSecond = (float)this.hitMonitor.getHitsInLastPeriod() / 10.0f;
        int hitsPerSecondAtThreadOut = this.maxWaitingThreads / 50;
        int hitsPerSecondAtHitOut = this.maxHitsPerSecond;
        this.debug("Hits per second: " + hitsPerSecond);
        this.debug("Hits per second at ThreadOut: " + hitsPerSecondAtThreadOut);
        this.debug("Hits per second at HitOut: " + hitsPerSecondAtHitOut);
        if (hitsPerSecond < (float)hitsPerSecondAtThreadOut) {
            this.changeMode(1, this.connectedTime, this.disconnectedTime);
            return;
        }
        float load = hitsPerSecond / (float)this.maxHitsPerSecond;
        int loadBasedDisconnectedTime = (int)((float)this.disconnectedTime * load);
        if (this.mode == 2) {
            this.changeMode(2, 0, loadBasedDisconnectedTime);
            if (this.disconnectedTime > 2000) {
                return;
            }
        }
        if (hitsPerSecond < (float)hitsPerSecondAtHitOut) {
            float factor = (float)this.waitingThreads / (float)this.maxWaitingThreads;
            int tmpConnectedTime = (int)((float)this.connectedTime / factor);
            if (tmpConnectedTime > 49000) {
                tmpConnectedTime = 49000;
            } else if (tmpConnectedTime < 1000) {
                tmpConnectedTime = 1000;
            }
            this.changeMode(1, tmpConnectedTime, 1000);
            return;
        }
        if (loadBasedDisconnectedTime < 2000) {
            this.changeMode(2, 0, 2000);
        } else {
            this.changeMode(2, 0, loadBasedDisconnectedTime);
        }
    }

    private void changeMode(int usageMode, int _connectedTime, int _disconnectedTime) {
        this.connectedTime = _connectedTime;
        this.disconnectedTime = _disconnectedTime;
        this.setMode(usageMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMode(int mode) {
        if (log.isDebugEnabled() && mode != this.mode) {
            log.debug((Object)("Changing modes, from " + USAGE_NAMES[this.mode] + " to " + USAGE_NAMES[mode]));
        }
        Object object = SERVER_MONITOR_LOCK;
        synchronized (object) {
            this.mode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMode() {
        Object object = SERVER_MONITOR_LOCK;
        synchronized (object) {
            return this.mode;
        }
    }

    public void setMaxWaitingThreads(int maxWaitingThreads) {
        this.maxWaitingThreads = maxWaitingThreads;
    }

    public void setMaxHitsPerSecond(int maxHitsPerSecond) {
        this.maxHitsPerSecond = maxHitsPerSecond;
    }

    void setMaxConnectedTime(int maxConnectedTime) {
        this.maxConnectedTime = maxConnectedTime;
    }

    static {
        log = LogFactory.getLog(ThrottlingServerLoadMonitor.class);
    }
}

