/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.annotations.DataTransferObject;
import org.directwebremoting.annotations.GlobalFilter;
import org.directwebremoting.annotations.Param;
import org.directwebremoting.annotations.RemoteProperty;
import org.directwebremoting.annotations.RemoteProxy;
import org.directwebremoting.spring.ConverterConfig;
import org.directwebremoting.spring.namespace.ConfigurationParser;
import org.directwebremoting.spring.namespace.ConverterParserHelper;
import org.directwebremoting.spring.namespace.CreatorParserHelper;
import org.directwebremoting.util.LocalUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwrClassPathBeanDefinitionScanner
extends ClassPathBeanDefinitionScanner {
    private static final Log log = LogFactory.getLog(DwrClassPathBeanDefinitionScanner.class);

    public DwrClassPathBeanDefinitionScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
        this.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(Component.class));
        this.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(Service.class));
        this.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(Repository.class));
        this.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(Controller.class));
        this.setScopedProxyMode(ScopedProxyMode.INTERFACES);
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definitionHolder, BeanDefinitionRegistry registry) {
        block16: {
            try {
                Class beanDefinitionClass = ClassUtils.forName((String)definitionHolder.getBeanDefinition().getBeanClassName());
                RemoteProxy proxy = beanDefinitionClass.getAnnotation(RemoteProxy.class);
                DataTransferObject converter = beanDefinitionClass.getAnnotation(DataTransferObject.class);
                GlobalFilter globalFilter = beanDefinitionClass.getAnnotation(GlobalFilter.class);
                if (proxy != null) {
                    super.registerBeanDefinition(definitionHolder, registry);
                    String javascript = proxy.name();
                    if (!StringUtils.hasText((String)javascript)) {
                        javascript = beanDefinitionClass.getSimpleName();
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Dwr classpath scanning detected candidate bean [" + definitionHolder.getBeanName() + "]. Remoting using " + javascript));
                    }
                    CreatorParserHelper.registerCreator(definitionHolder, registry, beanDefinitionClass, javascript);
                } else if (converter != null) {
                    Param[] params;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Dwr classpath scanning detected candidate DTO [" + beanDefinitionClass.getName() + "] processed by converter type [" + converter.type() + "]"));
                    }
                    ConverterConfig converterConfig = new ConverterConfig();
                    converterConfig.setType(converter.type());
                    this.setIncludes(beanDefinitionClass, converterConfig);
                    String javascript = converter.javascript();
                    if (StringUtils.hasText((String)javascript)) {
                        converterConfig.setJavascriptClassName(javascript);
                    }
                    if ((params = converter.params()) != null && params.length > 0) {
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        for (Param param : params) {
                            parameters.put(param.name(), param.value());
                        }
                        converterConfig.setParams(parameters);
                    }
                    ConverterParserHelper.lookupConverters(registry).put(beanDefinitionClass.getName(), converterConfig);
                } else if (globalFilter != null) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Dwr classpath scanning detected candidate global filter [" + beanDefinitionClass + "]"));
                    }
                    BeanDefinition springConfigurator = ConfigurationParser.registerConfigurationIfNecessary(registry);
                    ManagedList filters = (ManagedList)springConfigurator.getPropertyValues().getPropertyValue("filters").getValue();
                    Param[] params = globalFilter.params();
                    if (params != null) {
                        for (Param param : params) {
                            definitionHolder.getBeanDefinition().getPropertyValues().addPropertyValue(param.name(), (Object)param.value());
                        }
                    }
                    super.registerBeanDefinition(definitionHolder, registry);
                    filters.add((Object)new RuntimeBeanReference(definitionHolder.getBeanName()));
                }
            }
            catch (Exception ex) {
                if (!log.isWarnEnabled()) break block16;
                log.warn((Object)("Dwr classpath scanning detected candidate bean [" + definitionHolder.getBeanName() + "] but could not create needed proxies"), (Throwable)ex);
            }
        }
    }

    protected void setIncludes(Class<?> beanDefinitionClass, ConverterConfig converterConfig) {
        Field[] fields;
        PropertyDescriptor[] properties = BeanUtils.getPropertyDescriptors(beanDefinitionClass);
        if (properties != null) {
            for (PropertyDescriptor p : properties) {
                Method getter = p.getReadMethod();
                if (getter == null || getter.getAnnotation(RemoteProperty.class) == null) continue;
                converterConfig.addInclude(p.getName());
            }
        }
        if ((fields = LocalUtil.getAllFields(beanDefinitionClass)) != null) {
            for (Field field : fields) {
                if (field.getAnnotation(RemoteProperty.class) == null) continue;
                converterConfig.addInclude(field.getName());
            }
        }
    }
}

