/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring.namespace;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.annotations.Filter;
import org.directwebremoting.annotations.Filters;
import org.directwebremoting.annotations.RemoteMethod;
import org.directwebremoting.spring.BeanCreator;
import org.directwebremoting.spring.ConverterConfig;
import org.directwebremoting.spring.CreatorConfig;
import org.directwebremoting.spring.namespace.ConfigurationParser;
import org.directwebremoting.spring.namespace.ConverterParserHelper;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CreatorParserHelper
extends ConverterParserHelper {
    private static final Log log = LogFactory.getLog(CreatorParserHelper.class);
    private static final String AUTH = "dwr:auth";
    private static final String FILTER = "dwr:filter";
    private static final String LATENCY_FILTER = "dwr:latencyfilter";

    protected static Map<String, RuntimeBeanReference> lookupCreators(BeanDefinitionRegistry registry) {
        BeanDefinition config = ConfigurationParser.registerConfigurationIfNecessary(registry);
        return (Map)config.getPropertyValues().getPropertyValue("creators").getValue();
    }

    protected void configureCreator(BeanDefinitionRegistry registry, String javascript, BeanDefinitionBuilder creatorConfig, NodeList children) {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, List<String>> auth = new HashMap<String, List<String>>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (LATENCY_FILTER.equals(node.getNodeName())) {
                this.processLatencyFilter(registry, creatorConfig, child, javascript);
                continue;
            }
            if ("dwr:include".equals(node.getNodeName())) {
                includes.add(child.getAttribute("method"));
                continue;
            }
            if ("dwr:exclude".equals(node.getNodeName())) {
                excludes.add(child.getAttribute("method"));
                continue;
            }
            if (AUTH.equals(node.getNodeName())) {
                this.processAuth(child, auth);
                continue;
            }
            if ("dwr:convert".equals(node.getNodeName())) {
                this.processConvert(registry, child);
                continue;
            }
            if (FILTER.equals(node.getNodeName())) {
                this.processFilter(registry, child, javascript);
                creatorConfig.addPropertyValue("filters", (Object)this.createManagedFilterList(child, javascript));
                continue;
            }
            if (!"dwr:param".equals(node.getNodeName())) continue;
            params.put(child.getAttribute("name"), child.getAttribute("value"));
        }
        creatorConfig.addPropertyValue("auth", auth);
        creatorConfig.addPropertyValue("params", params);
        creatorConfig.addPropertyValue("includes", includes);
        creatorConfig.addPropertyValue("excludes", excludes);
    }

    public static void registerCreator(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry beanDefinitionRegistry, Class<?> beanDefinitionClass, String javascript) {
        String creatorConfigName = "__" + javascript;
        if (beanDefinitionRegistry.containsBeanDefinition(creatorConfigName)) {
            log.info((Object)("[" + javascript + "] remote bean definition already detected. Invalid mixed use of <dwr:annotation-config /> and <dwr:annotation-scan />? Re-scanned package?"));
        } else {
            BeanDefinitionBuilder beanCreator = BeanDefinitionBuilder.rootBeanDefinition(BeanCreator.class);
            try {
                Filters filtersAnn;
                beanCreator.addPropertyValue("beanClass", beanDefinitionClass);
                String name = beanDefinitionHolder.getBeanName();
                if (name.startsWith("scopedTarget.")) {
                    name = name.substring(name.indexOf(".") + 1);
                }
                beanCreator.addPropertyValue("beanId", (Object)name);
                beanCreator.addDependsOn(name);
                beanCreator.addPropertyValue("javascript", (Object)javascript);
                BeanDefinitionBuilder creatorConfig = BeanDefinitionBuilder.rootBeanDefinition(CreatorConfig.class);
                creatorConfig.addPropertyValue("creator", (Object)beanCreator.getBeanDefinition());
                ArrayList<String> includes = new ArrayList<String>();
                for (Method method : beanDefinitionClass.getMethods()) {
                    if (method.getAnnotation(RemoteMethod.class) == null) continue;
                    includes.add(method.getName());
                }
                ManagedList filters = new ManagedList();
                Filter filter = beanDefinitionClass.getAnnotation(Filter.class);
                if (null != filter) {
                    CreatorParserHelper.processFilter(beanDefinitionRegistry, filter, javascript, filters);
                }
                if ((filtersAnn = beanDefinitionClass.getAnnotation(Filters.class)) != null) {
                    Filter[] fs;
                    for (Filter filterFromFilters : fs = filtersAnn.value()) {
                        CreatorParserHelper.processFilter(beanDefinitionRegistry, filterFromFilters, javascript, filters);
                    }
                }
                if (filters.size() > 0) {
                    creatorConfig.addPropertyValue("filters", (Object)filters);
                }
                creatorConfig.addPropertyValue("includes", includes);
                BeanDefinitionHolder aux = new BeanDefinitionHolder((BeanDefinition)creatorConfig.getBeanDefinition(), creatorConfigName);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)aux, (BeanDefinitionRegistry)beanDefinitionRegistry);
                CreatorParserHelper.lookupCreators(beanDefinitionRegistry).put(javascript, new RuntimeBeanReference(creatorConfigName));
            }
            catch (Exception ex) {
                throw new FatalBeanException("Unable to create DWR bean creator for '" + beanDefinitionHolder.getBeanName() + "'. ", (Throwable)ex);
            }
        }
    }

    protected void registerCreator(BeanDefinitionRegistry registry, BeanDefinitionBuilder creatorConfig, String javascript) {
        String creatorConfigName = "__" + javascript;
        BeanDefinitionHolder holder3 = new BeanDefinitionHolder((BeanDefinition)creatorConfig.getBeanDefinition(), creatorConfigName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder3, (BeanDefinitionRegistry)registry);
        CreatorParserHelper.lookupCreators(registry).put(javascript, new RuntimeBeanReference(creatorConfigName));
    }

    private void processAuth(Element child, Map<String, List<String>> auth) {
        String method = child.getAttribute("method");
        if (auth.get(method) == null) {
            auth.put(method, new ArrayList());
        }
        auth.get(method).add(child.getAttribute("role"));
    }

    private void processConvert(BeanDefinitionRegistry registry, Element element) {
        ConverterConfig converterConfig = new ConverterConfig();
        converterConfig.setType(element.getAttribute("type"));
        this.parseConverterSettings(converterConfig, element);
        CreatorParserHelper.lookupConverters(registry).put(element.getAttribute("class"), converterConfig);
    }
}

