/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.util.LocalUtil;

public class Continuation {
    private final Object proxy;
    private static final Log log = LogFactory.getLog(Continuation.class);
    protected static final Class<?> continuationClass;
    protected static final Method suspendMethod;
    protected static final Method resumeMethod;
    protected static final Method isSuspendedMethod;
    protected static boolean isJetty;
    protected static boolean isGrizzly;

    public Continuation(HttpServletRequest request) {
        Object tempContinuation = null;
        try {
            if (Continuation.isJetty()) {
                Class<?> jContinuation = LocalUtil.classForName("org.eclipse.jetty.continuation.ContinuationSupport");
                Method jMethod = jContinuation.getMethod("getContinuation", ServletRequest.class);
                tempContinuation = jMethod.invoke(null, request);
            } else if (Continuation.isGrizzly()) {
                Class<?> gContinuation = LocalUtil.classForName("com.sun.grizzly.Continuation");
                Method gMethod = gContinuation.getMethod("getContinuation", new Class[0]);
                tempContinuation = gMethod.invoke(null, (Object[])null);
            }
        }
        catch (Throwable ignored) {
            log.debug((Object)"Throwable caught when trying to get server Continuation", ignored);
        }
        this.proxy = tempContinuation;
    }

    public boolean isAvailable() {
        return this.proxy != null;
    }

    public void suspend() throws Exception {
        try {
            if (Continuation.isJetty()) {
                suspendMethod.invoke(this.proxy, new Object[0]);
            } else if (Continuation.isGrizzly()) {
                suspendMethod.invoke(this.proxy, 60000);
            }
        }
        catch (InvocationTargetException ex) {
            Continuation.rethrowWithoutWrapper(ex);
        }
    }

    public void resume() throws Exception {
        try {
            if (((Boolean)isSuspendedMethod.invoke(this.proxy, new Object[0])).booleanValue()) {
                resumeMethod.invoke(this.proxy, new Object[0]);
            }
        }
        catch (InvocationTargetException ex) {
            Continuation.rethrowWithoutWrapper(ex);
        }
    }

    public static void rethrowIfContinuation(Throwable th) {
        Throwable ex = th;
        if (ex instanceof InvocationTargetException) {
            ex = ((InvocationTargetException)ex).getTargetException();
        }
        if ("org.eclipse.jetty.RetryRequest".equals(ex.getClass().getName())) {
            throw (RuntimeException)ex;
        }
    }

    private static Object rethrowWithoutWrapper(InvocationTargetException ex) throws Exception {
        Throwable target = ex.getTargetException();
        if (target instanceof Exception) {
            throw (Exception)target;
        }
        if (target instanceof Error) {
            throw (Error)target;
        }
        throw ex;
    }

    public static boolean isJetty() {
        return isJetty;
    }

    public static boolean isGrizzly() {
        return isGrizzly;
    }

    static {
        isJetty = false;
        isGrizzly = false;
        Class<?> tempContinuationClass = null;
        try {
            try {
                tempContinuationClass = LocalUtil.classForName("org.eclipse.jetty.continuation.Continuation");
                isJetty = true;
            }
            catch (Exception ex) {
                Class<?> gContinuation = LocalUtil.classForName("com.sun.grizzly.Continuation");
                Method gMethod = gContinuation.getMethod("getContinuation", new Class[0]);
                tempContinuationClass = gMethod.invoke((Object)gMethod, new Object[0]).getClass();
                isGrizzly = true;
            }
        }
        catch (Exception ex) {
            isJetty = false;
            log.debug((Object)"No Jetty or Grizzly Continuation class, using standard Servlet API");
        }
        continuationClass = tempContinuationClass;
        if (Continuation.isJetty()) {
            suspendMethod = LocalUtil.getMethod(continuationClass, "suspend", new Class[0]);
            isSuspendedMethod = LocalUtil.getMethod(continuationClass, "isSuspended", new Class[0]);
        } else if (isGrizzly) {
            suspendMethod = LocalUtil.getMethod(continuationClass, "suspend", Long.TYPE);
            isSuspendedMethod = null;
        } else {
            suspendMethod = null;
            isSuspendedMethod = null;
        }
        resumeMethod = LocalUtil.getMethod(continuationClass, "resume", new Class[0]);
    }
}

