/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.DwrConstants;
import org.directwebremoting.io.OutputStreamLoader;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.Loggers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalUtil {
    private static final List<?> TYPES_COMPATIBLE_WITH_JS_NUMBER = Arrays.asList(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, BigInteger.class);
    private static String packageNamePrefixAndDot;
    private static String resourcePathPrefix;
    private static final long CLASSLOAD_TIME;
    private static Map<Class<?>, Class<?>> primitiveWrapperMap;
    private static final Log log;

    private LocalUtil() {
        throw new InstantiationError("Cannot instantiate LocalUtil");
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        StringBuilder buffer = new StringBuilder();
        boolean isFirst = true;
        for (Object object : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(separator);
            }
            if (object == null) continue;
            buffer.append(object);
        }
        return buffer.toString();
    }

    public static boolean hasText(CharSequence str) {
        if (!LocalUtil.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean isJavaIdentifier(String test) {
        if (test == null || test.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(test.charAt(0)) && test.charAt(0) != '_') {
            return false;
        }
        for (int i = 1; i < test.length(); ++i) {
            if (Character.isJavaIdentifierPart(test.charAt(i)) || test.charAt(i) == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaIdentifierWithPackage(String test) {
        String[] segments = test.split("\\.");
        for (int i = 0; i < segments.length; ++i) {
            if (LocalUtil.isJavaIdentifier(segments[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetterOrDigitOrUnderline(String test) {
        if (test == null || test.length() == 0) {
            return false;
        }
        for (int i = 0; i < test.length(); ++i) {
            if (Character.isLetterOrDigit(test.charAt(i)) || test.charAt(i) == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidScriptName(String test) {
        return LocalUtil.isSafeHierarchicalIdentifierInBrowser(test);
    }

    public static boolean isValidMappedClassName(String test) {
        return LocalUtil.isSafeHierarchicalIdentifierInBrowser(test);
    }

    public static boolean isSafeHierarchicalIdentifierInBrowser(String test) {
        String[] segments;
        if (test.endsWith("/")) {
            return false;
        }
        for (String segment : segments = test.split("\\.")) {
            if (segment.equals("")) {
                return false;
            }
            for (int i = 0; i < segment.length(); ++i) {
                if (LocalUtil.isSafeIdentifierInBrowser(test)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSafeIdentifierInBrowser(String test) {
        for (int i = 0; i < test.length(); ++i) {
            char ch = test.charAt(i);
            if ("<>&'\"".indexOf(ch) >= 0) {
                return false;
            }
            if (";?#%".indexOf(ch) >= 0) {
                return false;
            }
            if (ch >= ' ' && '~' >= ch || Character.isLetterOrDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static String inferWildcardReplacements(String base, String wildcarded) {
        String result = wildcarded;
        if (wildcarded != null) {
            if ("*".equals(wildcarded)) {
                result = base.substring(base.lastIndexOf(46) + 1);
            } else if ("**".equals(wildcarded)) {
                result = base;
            } else if (wildcarded.indexOf("*") > 0) {
                result = wildcarded.replace("*", base.substring(base.lastIndexOf(46) + 1));
            }
            if (!result.equals(wildcarded) && log.isDebugEnabled()) {
                Loggers.STARTUP.debug((Object)("- expanded wildcarded string [" + wildcarded + "] to [" + result + "] for " + base));
            }
        }
        return result;
    }

    public static boolean isEquivalent(Class<?> c1, Class<?> c2) {
        if (c1 == Boolean.class || c1 == Boolean.TYPE) {
            return c2 == Boolean.class || c2 == Boolean.TYPE;
        }
        if (c1 == Byte.class || c1 == Byte.TYPE) {
            return c2 == Byte.class || c2 == Byte.TYPE;
        }
        if (c1 == Character.class || c1 == Character.TYPE) {
            return c2 == Character.class || c2 == Character.TYPE;
        }
        if (c1 == Short.class || c1 == Short.TYPE) {
            return c2 == Short.class || c2 == Short.TYPE;
        }
        if (c1 == Integer.class || c1 == Integer.TYPE) {
            return c2 == Integer.class || c2 == Integer.TYPE;
        }
        if (c1 == Long.class || c1 == Long.TYPE) {
            return c2 == Long.class || c2 == Long.TYPE;
        }
        if (c1 == Float.class || c1 == Float.TYPE) {
            return c2 == Float.class || c2 == Float.TYPE;
        }
        if (c1 == Double.class || c1 == Double.TYPE) {
            return c2 == Double.class || c2 == Double.TYPE;
        }
        if (c1 == Void.class || c1 == Void.TYPE) {
            return c2 == Void.class || c2 == Void.TYPE;
        }
        return false;
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == null) {
            return object2 == null;
        }
        return object1.equals(object2);
    }

    public static int shrink(long diff) {
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return 0;
    }

    public static Class<?> getNonPrimitiveType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Void.TYPE) {
            return Void.class;
        }
        return null;
    }

    public static void addNoCacheHeaders(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.addHeader("Cache-Control", "post-check=0, pre-check=0");
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
    }

    public static boolean isServletClass(Class<?> paramType) {
        return paramType == HttpServletRequest.class || paramType == HttpServletResponse.class || paramType == ServletConfig.class || paramType == ServletContext.class || paramType == HttpSession.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Iterators could be improved
     * Loose catch block
     */
    public static void debugRequest(HttpServletRequest request) {
        StringWriter buffer;
        block17: {
            String line;
            String queryString = request.getQueryString() != null ? "?" + request.getQueryString() : "";
            String requestLine = request.getMethod() + " " + request.getRequestURL() + queryString + " " + request.getProtocol();
            log.debug((Object)"Reconstituted HttpServletRequest:");
            log.debug((Object)(" " + requestLine));
            Enumeration headerNames = request.getHeaderNames();
            for (String headerName : LocalUtil.iterableizer(headerNames)) {
                log.debug((Object)("  " + headerName + ": " + request.getHeader(headerName)));
            }
            buffer = new StringWriter();
            ServletInputStream in = null;
            BufferedReader reader = null;
            in = request.getInputStream();
            reader = new BufferedReader(new InputStreamReader((InputStream)in));
            for (int length = 0; length < 256 && (line = reader.readLine()) != null; length += line.length()) {
                buffer.append("\n");
                buffer.append(line);
            }
            Object var10_11 = null;
            try {
                if (null != in) {
                    in.close();
                }
                if (null != reader) {
                    reader.close();
                }
                break block17;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
            break block17;
            {
                catch (IOException ex) {
                    buffer.append("[Unable to read body: " + ex + "]\n");
                    var10_11 = null;
                    try {
                        if (null != in) {
                            in.close();
                        }
                        if (null != reader) {
                            reader.close();
                        }
                        break block17;
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (null != in) {
                        in.close();
                    }
                    if (null != reader) {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage());
                }
                throw throwable;
            }
        }
        log.debug((Object)(" " + buffer));
        log.debug((Object)"Attributes attached to the Request:");
        Enumeration attributeNames = request.getAttributeNames();
        for (String attributeName : LocalUtil.iterableizer(attributeNames)) {
            log.debug((Object)("  " + attributeName + ": " + request.getAttribute(attributeName)));
        }
        log.debug((Object)"Security properties:");
        log.debug((Object)("  AuthType: " + request.getAuthType()));
        log.debug((Object)("  RemoteUser: " + request.getRemoteUser()));
        log.debug((Object)("  UserPrincipal: " + request.getUserPrincipal()));
    }

    public static <T> Iterable<T> iterableizer(final Enumeration<T> en) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return en.hasMoreElements();
                    }

                    @Override
                    public T next() {
                        return en.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> iterableizer(Enumeration<?> en, Class<T> type) {
        return LocalUtil.iterableizer(en);
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"UTF-8 is not a valid char sequence?", (Throwable)ex);
            return value;
        }
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"UTF-8 is not a valid char sequence?", (Throwable)ex);
            return value;
        }
    }

    public static void setParams(Object object, Map<String, ?> params, List<String> ignore) {
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            try {
                LocalUtil.setProperty(object, key, value);
            }
            catch (NoSuchMethodException ex) {
                if (ignore == null || ignore.contains(key)) continue;
                log.warn((Object)("No property '" + key + "' on " + object.getClass().getName()));
            }
            catch (InvocationTargetException ex) {
                log.warn((Object)("Error setting " + key + "=" + value + " on " + object.getClass().getName()), ex.getTargetException());
            }
            catch (Exception ex) {
                log.warn((Object)("Error setting " + key + "=" + value + " on " + object.getClass().getName()), (Throwable)ex);
            }
        }
    }

    public static void setProperty(Object object, String key, Object value) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> real = object.getClass();
        String setterName = "set" + key.substring(0, 1).toUpperCase(Locale.ENGLISH) + key.substring(1);
        try {
            Method method = real.getMethod(setterName, value.getClass());
            method.invoke(object, value);
            return;
        }
        catch (NoSuchMethodException ex) {
            if (!(value instanceof String) && !LocalUtil.isWrapper(value)) {
                throw ex;
            }
            for (Method setter : real.getMethods()) {
                if (!setter.getName().equals(setterName) || setter.getParameterTypes().length != 1) continue;
                Class<?> propertyType = setter.getParameterTypes()[0];
                try {
                    Object param = value;
                    if (value instanceof String) {
                        param = LocalUtil.simpleConvert((String)value, propertyType);
                    }
                    setter.invoke(object, param);
                    return;
                }
                catch (IllegalArgumentException ex2) {
                    // empty catch block
                }
            }
            throw new NoSuchMethodException("Failed to find a property called: " + key + " on " + object.getClass().getName());
        }
    }

    public static final boolean isWrapper(Object object) {
        boolean wrapper = false;
        if (object != null) {
            wrapper = primitiveWrapperMap.containsValue(object.getClass());
        }
        return wrapper;
    }

    public static Class<?> getPropertyType(Class<?> real, String key) {
        String getterName = "get" + key.substring(0, 1).toUpperCase(Locale.ENGLISH) + key.substring(1);
        try {
            Method method = real.getMethod(getterName, new Class[0]);
            return method.getReturnType();
        }
        catch (NoSuchMethodException ex) {
            Field[] fields;
            String setterName = "set" + key.substring(0, 1).toUpperCase(Locale.ENGLISH) + key.substring(1);
            ArrayList available = new ArrayList();
            for (Method setter : real.getMethods()) {
                if (!setter.getName().equals(setterName) || setter.getParameterTypes().length != 1) continue;
                available.add(setter.getParameterTypes()[0]);
            }
            if (available.isEmpty()) {
                log.debug((Object)("Failed to find a setter called: " + setterName + " on " + real.getName()));
                return null;
            }
            if (available.size() == 1) {
                return (Class)available.get(0);
            }
            for (Field field : fields = LocalUtil.getAllFields(real)) {
                if (!field.getName().equals(key)) continue;
                return field.getType();
            }
            return (Class)available.get(0);
        }
    }

    public static boolean isTypeSimplyConvertable(Class<?> paramType) {
        return paramType == String.class || paramType == Integer.class || paramType == Integer.TYPE || paramType == Short.class || paramType == Short.TYPE || paramType == Byte.class || paramType == Byte.TYPE || paramType == Long.class || paramType == Long.TYPE || paramType == Float.class || paramType == Float.TYPE || paramType == Double.class || paramType == Double.TYPE || paramType == Character.class || paramType == Character.TYPE || paramType == Boolean.class || paramType == Boolean.TYPE;
    }

    public static <T> T simpleConvert(String value, Class<T> paramType) {
        if (paramType == String.class) {
            return (T)value;
        }
        if (paramType == Character.class || paramType == Character.TYPE) {
            if ((value = LocalUtil.urlDecode(value)).length() == 1) {
                return (T)Character.valueOf(value.charAt(0));
            }
            throw new IllegalArgumentException("Can't more than one character in string - can't convert to char: '" + value + "'");
        }
        String trimValue = value.trim();
        if (paramType == Boolean.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Boolean.valueOf(trimValue);
        }
        if (paramType == Boolean.TYPE) {
            return (T)Boolean.valueOf(trimValue);
        }
        if (paramType == Integer.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Integer.valueOf(trimValue);
        }
        if (paramType == Integer.TYPE) {
            if (trimValue.length() == 0) {
                return (T)Integer.valueOf(0);
            }
            return (T)Integer.valueOf(trimValue);
        }
        if (paramType == Short.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Short.valueOf(trimValue);
        }
        if (paramType == Short.TYPE) {
            if (trimValue.length() == 0) {
                return (T)Short.valueOf((short)0);
            }
            return (T)Short.valueOf(trimValue);
        }
        if (paramType == Byte.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Byte.valueOf(trimValue);
        }
        if (paramType == Byte.TYPE) {
            if (trimValue.length() == 0) {
                return (T)Byte.valueOf((byte)0);
            }
            return (T)Byte.valueOf(trimValue);
        }
        if (paramType == Long.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Long.valueOf(trimValue);
        }
        if (paramType == Long.TYPE) {
            if (trimValue.length() == 0) {
                return (T)Long.valueOf(0L);
            }
            return (T)Long.valueOf(trimValue);
        }
        if (paramType == Float.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Float.valueOf(trimValue);
        }
        if (paramType == Float.TYPE) {
            if (trimValue.length() == 0) {
                return (T)Float.valueOf(0.0f);
            }
            return (T)Float.valueOf(trimValue);
        }
        if (paramType == Double.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Double.valueOf(trimValue);
        }
        if (paramType == Double.TYPE) {
            if (trimValue.length() == 0) {
                return (T)Double.valueOf(0.0);
            }
            return (T)Double.valueOf(trimValue);
        }
        throw new IllegalArgumentException("Unsupported conversion type: " + paramType.getName());
    }

    public static boolean isSimpleName(String name) {
        if (name.length() == 0) {
            return false;
        }
        if (JavascriptUtil.isReservedWord(name)) {
            return false;
        }
        boolean isSimple = Character.isLetter(name.charAt(0));
        for (int i = 1; isSimple && i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i))) continue;
            isSimple = false;
        }
        return isSimple;
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        if (!className.contains(".")) {
            if (className.equals(Boolean.TYPE.getName())) {
                return Boolean.TYPE;
            }
            if (className.equals(Byte.TYPE.getName())) {
                return Byte.TYPE;
            }
            if (className.equals(Character.TYPE.getName())) {
                return Character.TYPE;
            }
            if (className.equals(Short.TYPE.getName())) {
                return Short.TYPE;
            }
            if (className.equals(Integer.TYPE.getName())) {
                return Integer.TYPE;
            }
            if (className.equals(Long.TYPE.getName())) {
                return Long.TYPE;
            }
            if (className.equals(Float.TYPE.getName())) {
                return Float.TYPE;
            }
            if (className.equals(Double.TYPE.getName())) {
                return Double.TYPE;
            }
            if (className.equals(Void.TYPE.getName())) {
                return Void.TYPE;
            }
        }
        return Thread.currentThread().getContextClassLoader().loadClass(LocalUtil.remappedDwrClassName(className));
    }

    public static String originalDwrClassName(String className) {
        if (LocalUtil.isClassNameInDwrRemappedPackage(className)) {
            return className.substring(packageNamePrefixAndDot.length());
        }
        return className;
    }

    public static String remappedDwrClassName(String className) {
        if (LocalUtil.isClassNameInDwrOriginalPackage(className)) {
            return packageNamePrefixAndDot + className;
        }
        return className;
    }

    public static boolean isClassNameInDwrOriginalPackage(String className) {
        if (!className.startsWith(DwrConstants.PACKAGE_NAME)) {
            return false;
        }
        return className.indexOf(DwrConstants.PACKAGE_NAME, 1) < 0;
    }

    public static boolean isClassNameInDwrRemappedPackage(String className) {
        if (packageNamePrefixAndDot.length() == 0) {
            return false;
        }
        return className.startsWith(packageNamePrefixAndDot + DwrConstants.PACKAGE_NAME);
    }

    public static <T> Class<? extends T> classForName(String debugContext, String className, Class<T> impl) {
        Class<?> clazz;
        try {
            clazz = LocalUtil.classForName(className);
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)("Skipping '" + debugContext + "' due to ClassNotFoundException on " + className + ". Cause: " + ex.getMessage()));
            return null;
        }
        catch (NoClassDefFoundError ex) {
            log.debug((Object)("Skipping '" + debugContext + "' due to NoClassDefFoundError on " + className + ". Cause: " + ex.getMessage()));
            return null;
        }
        catch (TransformerFactoryConfigurationError ex) {
            log.debug((Object)("Skipping '" + debugContext + "' due to TransformerFactoryConfigurationError on " + className + ". Cause: " + ex.getMessage()));
            log.debug((Object)"Maybe you need to add xalan.jar to your webserver?");
            return null;
        }
        if (!impl.isAssignableFrom(clazz)) {
            log.error((Object)("Class '" + clazz.getName() + "' does not implement '" + impl.getName() + "'."));
            return null;
        }
        try {
            clazz.newInstance();
        }
        catch (InstantiationException ex) {
            log.error((Object)("InstantiationException for '" + debugContext + "' failed:"), (Throwable)ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            log.error((Object)("IllegalAccessException for '" + debugContext + "' failed:"), (Throwable)ex);
            return null;
        }
        catch (NoClassDefFoundError ex) {
            log.debug((Object)("Skipping '" + debugContext + "' due to NoClassDefFoundError on " + className + ". Cause: " + ex.getMessage()));
            return null;
        }
        catch (TransformerFactoryConfigurationError ex) {
            log.debug((Object)("Skipping '" + debugContext + "' due to TransformerFactoryConfigurationError on " + className + ". Cause: " + ex.getMessage()));
            log.debug((Object)"Maybe you need to add xalan.jar to your webserver?");
            return null;
        }
        catch (Exception ex) {
            if (ex instanceof ClassNotFoundException) {
                log.debug((Object)("Skipping '" + debugContext + "' due to ClassNotFoundException on " + className + ". Cause: " + ex.getMessage()));
                return null;
            }
            log.error((Object)("Failed to load '" + debugContext + "' (" + className + ")"), (Throwable)ex);
            return null;
        }
        return clazz;
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... args) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getMethod(name, args);
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static <T> T classNewInstance(String name, String className, Class<T> impl) {
        Class<?> clazz;
        try {
            clazz = LocalUtil.classForName(className);
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)("Skipping '" + name + "' due to ClassNotFoundException on " + className + ". Cause: " + ex.getMessage()));
            return null;
        }
        catch (NoClassDefFoundError ex) {
            log.debug((Object)("Skipping '" + name + "' due to NoClassDefFoundError on " + className + ". Cause: " + ex.getMessage()));
            return null;
        }
        catch (TransformerFactoryConfigurationError ex) {
            log.debug((Object)("Skipping '" + name + "' due to TransformerFactoryConfigurationError on " + className + ". Cause: " + ex.getMessage()));
            return null;
        }
        if (!impl.isAssignableFrom(clazz)) {
            log.error((Object)("Class '" + clazz.getName() + "' does not implement '" + impl.getName() + "'."));
            return null;
        }
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException ex) {
            log.error((Object)("InstantiationException for '" + name + "' failed:"), (Throwable)ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            log.error((Object)("IllegalAccessException for '" + name + "' failed:"), (Throwable)ex);
            return null;
        }
        catch (TransformerFactoryConfigurationError ex) {
            log.error((Object)("TransformerFactoryConfigurationError for '" + name + "' failed:"), (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            log.error((Object)("Failed to load creator '" + name + "', classname=" + className + ": "), (Throwable)ex);
            return null;
        }
    }

    public static Object invoke(Object object, Method method, Object[] params) throws IllegalStateException {
        Object reply = null;
        if (method != null) {
            try {
                reply = method.invoke(object, params);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalStateException("InvocationTargetException calling " + method.getName() + ": " + ex.getTargetException().toString());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Reflection error calling " + method.getName() + ": " + ex.toString());
            }
        }
        return reply;
    }

    public static String remappedResourcePath(String path) {
        if (resourcePathPrefix.length() > 0) {
            return resourcePathPrefix + (path.startsWith("/") ? "" : "/") + path;
        }
        return path;
    }

    public static InputStream getInternalResourceAsStream(String path) {
        return LocalUtil.class.getResourceAsStream(LocalUtil.remappedResourcePath(path));
    }

    public static void close(Closeable in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static void close(OutputStreamLoader loader) {
        if (loader == null) {
            return;
        }
        try {
            loader.close();
        }
        catch (IOException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    public static List<Class<?>> getAllSuperclasses(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        return classes;
    }

    public static Field[] getAllFields(Class<?> clazz) {
        List<Class<?>> classes = LocalUtil.getAllSuperclasses(clazz);
        classes.add(clazz);
        return LocalUtil.getAllFields(classes);
    }

    private static Field[] getAllFields(List<Class<?>> classes) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> clazz : classes) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static <T> T getProperty(Object pojo, String propertyName, Class<T> type) {
        Class<?> real = pojo.getClass();
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        try {
            Method method = real.getMethod(getterName, new Class[0]);
            if (!type.isAssignableFrom(LocalUtil.primitiveToWrapper(method.getReturnType()))) {
                log.debug((Object)("Expected that the type of " + real.getName() + "." + propertyName + " was " + type.getName() + " but found " + method.getReturnType().getName() + "."));
                return null;
            }
            return (T)method.invoke(pojo, new Object[0]);
        }
        catch (Exception ex) {
            log.debug((Object)("Failed to get property called " + propertyName + " from a " + real.getName() + ": " + ex));
            return null;
        }
    }

    public static Class<?> toClass(Type parameterType, String debugContext) {
        if (parameterType instanceof Class) {
            return (Class)parameterType;
        }
        if (parameterType instanceof ParameterizedType) {
            return LocalUtil.toClass(((ParameterizedType)parameterType).getRawType(), debugContext);
        }
        if (parameterType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)parameterType).getGenericComponentType();
            Class<?> componentClass = LocalUtil.toClass(componentType, debugContext);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            log.warn((Object)"The inbound Arrays component class is null.");
        }
        log.warn((Object)("Missing type info for " + debugContext + ". Assuming this is a map with String keys. Please add to <signatures> in dwr.xml"));
        return String.class;
    }

    public static Locale parseLocaleString(String localeString) {
        if (LocalUtil.hasText(localeString)) {
            String[] parts = localeString.trim().split("[_]+");
            String language = parts[0];
            String country = parts.length > 1 ? parts[1] : "";
            String variant = parts.length > 2 ? parts[2] : "";
            return new Locale(language, country, variant);
        }
        return null;
    }

    public static Class<?> primitiveToWrapper(Class<?> clazz) {
        Class<?> convertedClass = clazz;
        if (clazz != null && clazz.isPrimitive()) {
            convertedClass = primitiveWrapperMap.get(clazz);
        }
        return convertedClass;
    }

    public static String capitalize(String input) {
        String capitalized = input;
        if (LocalUtil.hasText(input)) {
            StringBuffer buf = new StringBuffer(input.length());
            buf.append(Character.toUpperCase(input.charAt(0)));
            buf.append(input.substring(1));
            return buf.toString();
        }
        return capitalized;
    }

    public static Method getWriteMethod(Class<?> clazz, PropertyDescriptor property) {
        Method setter;
        block5: {
            setter = null;
            if (property != null) {
                Method getter = property.getReadMethod();
                setter = property.getWriteMethod();
                if (getter != null && setter == null && clazz != null) {
                    Class<?> type = getter.getReturnType();
                    String setterName = "set" + LocalUtil.capitalize(property.getName());
                    try {
                        setter = clazz.getMethod(setterName, type);
                    }
                    catch (Exception ex) {
                        setter = LocalUtil.find(setterName, type, clazz.getMethods());
                        if (setter != null) break block5;
                        setter = LocalUtil.find(setterName, type, clazz.getDeclaredMethods());
                    }
                }
            }
        }
        if (setter != null && !Modifier.isPublic(setter.getModifiers())) {
            setter.setAccessible(true);
        }
        return setter;
    }

    private static Method find(String name, Class<?> type, Method[] methods) {
        if (methods != null) {
            for (int index = 0; index < methods.length; ++index) {
                Method method = methods[index];
                Class<?>[] params = method.getParameterTypes();
                if (!name.equals(method.getName()) || params == null || params.length != 1 || !type.isAssignableFrom(params[0])) continue;
                return method;
            }
        }
        return null;
    }

    public static boolean isJavaScriptTypeAssignableTo(String javaScriptType, Class<?> clazz) {
        if ("array".equals(javaScriptType)) {
            return LocalUtil.isJavaScriptArrayConvertableTo(clazz);
        }
        if ("boolean".equals(javaScriptType)) {
            return LocalUtil.isJavaScriptBooleanConvertableTo(clazz);
        }
        if ("number".equals(javaScriptType)) {
            return LocalUtil.isJavaScriptNumberConvertableTo(clazz);
        }
        if ("string".equals(javaScriptType)) {
            return LocalUtil.isJavaScriptStringConvertableTo(clazz);
        }
        if ("date".equals(javaScriptType)) {
            return LocalUtil.isJavaScriptDateConvertableTo(clazz);
        }
        if ("Object_Object".equals(javaScriptType)) {
            return LocalUtil.isJavaScriptObjectConvertableTo(clazz);
        }
        return true;
    }

    private static boolean isJavaScriptArrayConvertableTo(Class<?> type) {
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    private static boolean isJavaScriptObjectConvertableTo(Class<?> type) {
        return !LocalUtil.isTypeSimplyConvertable(type) && !LocalUtil.isJavaScriptArrayConvertableTo(type);
    }

    private static boolean isJavaScriptBooleanConvertableTo(Class<?> type) {
        return Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type);
    }

    private static boolean isJavaScriptNumberConvertableTo(Class<?> type) {
        return TYPES_COMPATIBLE_WITH_JS_NUMBER.contains(type);
    }

    private static boolean isJavaScriptStringConvertableTo(Class<?> type) {
        return String.class.isAssignableFrom(type) || Character.TYPE.equals(type) || Locale.class.equals(type) || Currency.class.equals(type);
    }

    private static boolean isJavaScriptDateConvertableTo(Class<?> type) {
        return Date.class.isAssignableFrom(type);
    }

    public static long getSystemClassloadTime() {
        return CLASSLOAD_TIME;
    }

    static {
        primitiveWrapperMap = new HashMap();
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        log = LogFactory.getLog(LocalUtil.class);
        long now = System.currentTimeMillis();
        CLASSLOAD_TIME = now - now % 1000L;
        String expectedPackage = DwrConstants.PACKAGE_NAME + ".util";
        String actualPackage = LocalUtil.class.getPackage().getName();
        if (!actualPackage.endsWith(expectedPackage)) {
            log.error((Object)"Disallowed remapping of DWR classes - only change of prefix is allowed and the org.directwebremoting package tree must be kept intact.");
            throw new Error("Disallowed remapping of DWR classes.");
        }
        packageNamePrefixAndDot = actualPackage.substring(0, actualPackage.indexOf(expectedPackage));
        if (packageNamePrefixAndDot.length() > 0) {
            resourcePathPrefix = "/" + packageNamePrefixAndDot.replace('.', '/').substring(0, packageNamePrefixAndDot.length() - 1);
            log.info((Object)("Detected repackaging of DWR - using packageNamePrefix=" + packageNamePrefixAndDot + ", resourcePathPrefix=" + resourcePathPrefix));
        } else {
            resourcePathPrefix = "";
        }
    }
}

