/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.forms;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.naming.InitialContext;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFormDispatcher {
    public static final String PROCESSFORMS_CSS = "process_forms.css";
    protected static final String WEB_CONTEXT = "/gwt-console-server/rs";
    protected ProcessEngine processEngine;
    protected String webServiceHost = null;
    protected String webServicePort = null;
    protected static final String FORM_DIRECTIVE_KEY = "form";
    protected static final String OUTCOME_DIRECTIVE_NAME = "outcome";

    public AbstractFormDispatcher() {
        this.initializeProcessEngine();
    }

    protected void initializeProcessEngine() {
        try {
            InitialContext ctx = new InitialContext();
            this.processEngine = (ProcessEngine)ctx.lookup("java:/ProcessEngine");
        }
        catch (Exception e) {
            this.processEngine = org.jbpm.api.Configuration.getProcessEngine();
        }
        this.webServiceHost = (String)this.processEngine.get("jbpm.console.server.host");
        this.webServicePort = (String)this.processEngine.get("jbpm.console.server.port");
        if (this.webServiceHost == null || this.webServicePort == null) {
            throw new JbpmException("make sure that strings 'jbpm.console.server.host' and 'jbpm.console.server.port' are properly configured in the process-engine-context of jbpm.cfg.xml");
        }
    }

    protected StringBuilder getBaseUrl() {
        StringBuilder spec = new StringBuilder();
        spec.append("http://");
        spec.append(this.webServiceHost);
        spec.append(":");
        spec.append(this.webServicePort);
        spec.append(WEB_CONTEXT);
        return spec;
    }

    protected DataHandler processTemplate(final String name, InputStream src, Map<String, Object> renderContext) {
        DataHandler merged = null;
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(name, (Reader)new InputStreamReader(src), cfg);
            final ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(bout);
            temp.process(renderContext, (Writer)out);
            ((Writer)out).flush();
            merged = new DataHandler(new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(bout.toByteArray());
                }

                public OutputStream getOutputStream() throws IOException {
                    return bout;
                }

                public String getContentType() {
                    return "application/octet-stream";
                }

                public String getName() {
                    return name + "_DataSource";
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process task template", e);
        }
        return merged;
    }

    protected String streamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read process_forms.css", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to close stream process_forms.css", e);
            }
        }
        return sb.toString();
    }
}

