/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.ISQLServerResultSet;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSetMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.ScrollWindow;
import com.microsoft.sqlserver.jdbc.StreamColInfo;
import com.microsoft.sqlserver.jdbc.StreamColumns;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamRetStatus;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.StreamTabName;
import com.microsoft.sqlserver.jdbc.StreamType;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.UninterruptableTDSCommand;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import microsoft.sql.DateTimeOffset;

public final class SQLServerResultSet
implements ISQLServerResultSet {
    private static int lastResultSetID = 0;
    private final String traceID;
    static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerResultSet");
    private static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.ResultSet");
    private final String loggingClassName;
    private final SQLServerStatement stmt;
    private final int maxRows;
    private ResultSetMetaData metaData;
    private boolean isClosed = false;
    private final int serverCursorId;
    private int fetchDirection;
    private int fetchSize;
    private boolean isOnInsertRow = false;
    private boolean lastValueWasNull = false;
    private int lastColumnIndex;
    private Closeable activeStream;
    private final ScrollWindow scrollWindow;
    private static final int BEFORE_FIRST_ROW = 0;
    private static final int AFTER_LAST_ROW = -1;
    private static final int UNKNOWN_ROW = -2;
    private int currentRow = 0;
    private boolean updatedCurrentRow = false;
    private boolean deletedCurrentRow = false;
    static final int UNKNOWN_ROW_COUNT = -3;
    private int rowCount;
    private final Column[] columns;
    private TDSReader tdsReader;
    private final FetchBuffer fetchBuffer;
    private SQLServerException rowErrorException = null;
    private int numFetchedRows;

    private static synchronized int nextResultSetID() {
        return ++lastResultSetID;
    }

    public String toString() {
        return this.traceID;
    }

    String logCursorState() {
        return " currentRow:" + this.currentRow + " numFetchedRows:" + this.numFetchedRows + " rowCount:" + this.rowCount;
    }

    String getClassNameLogging() {
        return this.loggingClassName;
    }

    final boolean getUpdatedCurrentRow() {
        return this.updatedCurrentRow;
    }

    final void setUpdatedCurrentRow(boolean bl) {
        this.updatedCurrentRow = bl;
    }

    final boolean getDeletedCurrentRow() {
        return this.deletedCurrentRow;
    }

    final void setDeletedCurrentRow(boolean bl) {
        this.deletedCurrentRow = bl;
    }

    final void setColumnName(int n, String string) {
        this.columns[n - 1].setColumnName(string);
    }

    private final void skipColumns(int n, boolean bl) throws SQLServerException {
        assert (this.lastColumnIndex >= 1);
        assert (0 <= n && n <= this.columns.length);
        for (int i = 0; i < n; ++i) {
            Column column = this.getColumn(this.lastColumnIndex++);
            column.skipValue(this.tdsReader, bl && this.isForwardOnly());
            if (!bl) continue;
            column.clear();
        }
    }

    SQLServerResultSet(SQLServerStatement sQLServerStatement) throws SQLServerException {
        int n = SQLServerResultSet.nextResultSetID();
        this.loggingClassName = "com.microsoft.sqlserver.jdbc.SQLServerResultSet:" + n;
        this.traceID = "SQLServerResultSet:" + n;
        this.stmt = sQLServerStatement;
        this.maxRows = sQLServerStatement.maxRows;
        this.fetchSize = sQLServerStatement.nFetchSize;
        this.fetchDirection = sQLServerStatement.nFetchDirection;
        abstract class CursorInitializer
        extends TDSTokenHandler {
            private StreamColumns columnMetaData;
            private StreamColInfo colInfo;
            private StreamTabName tabName;

            abstract int getRowCount();

            abstract int getServerCursorId();

            final Column[] buildColumns() throws SQLServerException {
                return this.columnMetaData.buildColumns(this.colInfo, this.tabName);
            }

            CursorInitializer(String string) {
                super(string);
                this.columnMetaData = null;
                this.colInfo = null;
                this.tabName = null;
            }

            @Override
            boolean onColInfo(TDSReader tDSReader) throws SQLServerException {
                this.colInfo = new StreamColInfo();
                this.colInfo.setFromTDS(tDSReader);
                return true;
            }

            @Override
            boolean onTabName(TDSReader tDSReader) throws SQLServerException {
                this.tabName = new StreamTabName();
                this.tabName.setFromTDS(tDSReader);
                return true;
            }

            @Override
            boolean onColMetaData(TDSReader tDSReader) throws SQLServerException {
                this.columnMetaData = new StreamColumns();
                this.columnMetaData.setFromTDS(tDSReader);
                return true;
            }
        }
        final class ClientCursorInitializer
        extends CursorInitializer {
            private int rowCount;

            @Override
            final int getRowCount() {
                return this.rowCount;
            }

            @Override
            final int getServerCursorId() {
                return 0;
            }

            ClientCursorInitializer() {
                super("ClientCursorInitializer");
                this.rowCount = -3;
            }

            @Override
            boolean onRow(TDSReader tDSReader) throws SQLServerException {
                return false;
            }

            @Override
            boolean onError(TDSReader tDSReader) throws SQLServerException {
                this.rowCount = 0;
                return false;
            }

            @Override
            boolean onDone(TDSReader tDSReader) throws SQLServerException {
                this.rowCount = 0;
                return false;
            }

            @Override
            boolean onRetValue(TDSReader tDSReader) throws SQLServerException {
                this.rowCount = 0;
                SQLServerResultSet.this.checkShilohCancel(tDSReader);
                tDSReader.throwInvalidTDS();
                return false;
            }
        }
        final class ServerCursorInitializer
        extends CursorInitializer {
            private final SQLServerStatement stmt;

            @Override
            final int getRowCount() {
                return this.stmt.getServerCursorRowCount();
            }

            @Override
            final int getServerCursorId() {
                return this.stmt.getServerCursorId();
            }

            ServerCursorInitializer(SQLServerStatement sQLServerStatement) {
                super("ServerCursorInitializer");
                this.stmt = sQLServerStatement;
            }

            @Override
            boolean onRetStatus(TDSReader tDSReader) throws SQLServerException {
                this.stmt.consumeExecOutParam(tDSReader);
                return true;
            }

            @Override
            boolean onRetValue(TDSReader tDSReader) throws SQLServerException {
                return false;
            }
        }
        CursorInitializer cursorInitializer = sQLServerStatement.executedSqlDirectly ? new ClientCursorInitializer() : new ServerCursorInitializer(sQLServerStatement);
        TDSParser.parse(sQLServerStatement.resultsReader(), cursorInitializer);
        this.columns = cursorInitializer.buildColumns();
        this.rowCount = cursorInitializer.getRowCount();
        this.serverCursorId = cursorInitializer.getServerCursorId();
        this.tdsReader = 0 == this.serverCursorId ? sQLServerStatement.resultsReader() : null;
        this.fetchBuffer = new FetchBuffer();
        this.scrollWindow = this.isForwardOnly() ? null : new ScrollWindow(this.fetchSize);
        this.numFetchedRows = 0;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (" + sQLServerStatement.toString() + ")");
        }
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "isWrapperFor");
        DriverJDBCVersion.checkSupportsJDBC4();
        boolean bl = clazz.isInstance(this);
        loggerExternal.exiting(this.getClassNameLogging(), "isWrapperFor", bl);
        return bl;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t;
        loggerExternal.entering(this.getClassNameLogging(), "unwrap");
        DriverJDBCVersion.checkSupportsJDBC4();
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new SQLException(classCastException.getMessage());
        }
        loggerExternal.exiting(this.getClassNameLogging(), "unwrap", t);
        return t;
    }

    void checkClosed() throws SQLServerException {
        if (this.isClosed) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_resultsetClosed"), null, false);
        }
        this.stmt.checkClosed();
        if (null != this.rowErrorException) {
            throw this.rowErrorException;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "isClosed");
        boolean bl = this.isClosed || this.stmt.isClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "isClosed", bl);
        return bl;
    }

    private final void throwNotScrollable() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this, SQLServerException.getErrString("R_requestedOpNotSupportedOnForward"), null, true);
    }

    private final boolean isForwardOnly() {
        return 2003 == this.stmt.getSQLResultSetType() || 2004 == this.stmt.getSQLResultSetType();
    }

    private final boolean isDynamic() {
        return 0 != this.serverCursorId && 2 == this.stmt.getCursorType();
    }

    private final void verifyResultSetIsScrollable() throws SQLServerException {
        if (this.isForwardOnly()) {
            this.throwNotScrollable();
        }
    }

    private final void throwNotUpdatable() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this, SQLServerException.getErrString("R_resultsetNotUpdatable"), null, true);
    }

    private final void verifyResultSetIsUpdatable() throws SQLServerException {
        if (1007 == this.stmt.resultSetConcurrency || 0 == this.serverCursorId) {
            this.throwNotUpdatable();
        }
    }

    private boolean hasCurrentRow() {
        return 0 != this.currentRow && -1 != this.currentRow;
    }

    private void verifyResultSetHasCurrentRow() throws SQLServerException {
        if (!this.hasCurrentRow()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_resultsetNoCurrentRow"), null, true);
        }
    }

    private void verifyCurrentRowIsNotDeleted(String string) throws SQLServerException {
        if (this.currentRowDeleted()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString(string), null, true);
        }
    }

    private void verifyValidColumnIndex(int n) throws SQLServerException {
        int n2 = this.columns.length;
        if (0 != this.serverCursorId) {
            --n2;
        }
        if (n < 1 || n > n2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, messageFormat.format(objectArray), "07009", false);
        }
    }

    private void verifyResultSetIsNotOnInsertRow() throws SQLServerException {
        if (this.isOnInsertRow) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_mustNotBeOnInsertRow"), null, true);
        }
    }

    private final void throwUnsupportedCursorOp() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this, SQLServerException.getErrString("R_unsupportedCursorOperation"), null, true);
    }

    private void closeInternal() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.discardFetchBuffer();
        this.closeServerCursor();
        this.metaData = null;
    }

    @Override
    public void close() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "close");
        this.closeInternal();
        loggerExternal.exiting(this.getClassNameLogging(), "close");
    }

    @Override
    public int findColumn(String string) throws SQLServerException {
        int n;
        loggerExternal.entering(this.getClassNameLogging(), "findColumn", string);
        this.checkClosed();
        for (n = 0; n < this.columns.length; ++n) {
            if (!this.columns[n].getColumnName().equals(string)) continue;
            loggerExternal.exiting(this.getClassNameLogging(), "findColumn", n + 1);
            return n + 1;
        }
        for (n = 0; n < this.columns.length; ++n) {
            if (!this.columns[n].getColumnName().equalsIgnoreCase(string)) continue;
            loggerExternal.exiting(this.getClassNameLogging(), "findColumn", n + 1);
            return n + 1;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumnName"));
        Object[] objectArray = new Object[]{string};
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, messageFormat.format(objectArray), "07009", false);
        return 0;
    }

    final int getColumnCount() {
        int n = this.columns.length;
        if (0 != this.serverCursorId) {
            --n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Column getColumn(int n) throws SQLServerException {
        if (null != this.activeStream) {
            try {
                this.activeStream.close();
            }
            catch (IOException iOException) {
                SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
            }
            finally {
                this.activeStream = null;
            }
        }
        return this.columns[n - 1];
    }

    private final Column loadColumn(int n) throws SQLServerException {
        assert (1 <= n && n <= this.columns.length);
        if (n > this.lastColumnIndex) {
            this.skipColumns(n - this.lastColumnIndex, false);
        }
        return this.getColumn(n);
    }

    private void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    @Override
    public void clearWarnings() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "clearWarnings");
        loggerExternal.exiting(this.getClassNameLogging(), "clearWarnings");
    }

    private void moverInit() throws SQLServerException {
        this.cancelInsert();
        this.cancelUpdates();
    }

    @Override
    public boolean relative(int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "relative", n);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + " rows:" + n + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.verifyResultSetHasCurrentRow();
        this.moverInit();
        this.moveRelative(n);
        boolean bl = this.hasCurrentRow();
        loggerExternal.exiting(this.getClassNameLogging(), "relative", bl);
        return bl;
    }

    private final void moveRelative(int n) throws SQLServerException {
        assert (this.hasCurrentRow());
        if (0 == n) {
            return;
        }
        if (n > 0) {
            this.moveForward(n);
        } else {
            this.moveBackward(n);
        }
    }

    private final void moveForward(int n) throws SQLServerException {
        assert (this.hasCurrentRow());
        assert (n > 0);
        if (this.scrollWindow.getRow() + n <= this.scrollWindow.getMaxRows()) {
            int n2 = 0;
            while (n > 0 && this.scrollWindow.next(this)) {
                ++n2;
                --n;
            }
            this.updateCurrentRow(n2);
            if (0 == n) {
                return;
            }
        }
        assert (n > 0);
        if (0 == this.serverCursorId) {
            assert (-2 != this.currentRow);
            this.currentRow = this.clientMoveAbsolute(this.currentRow + n);
            return;
        }
        if (1 == n) {
            this.doServerFetch(2, 0, this.fetchSize);
        } else {
            this.doServerFetch(32, n + this.scrollWindow.getRow() - 1, this.fetchSize);
        }
        if (!this.scrollWindow.next(this)) {
            this.currentRow = -1;
            return;
        }
        this.updateCurrentRow(n);
    }

    private final void moveBackward(int n) throws SQLServerException {
        assert (this.hasCurrentRow());
        assert (n < 0);
        if (this.scrollWindow.getRow() + n >= 1) {
            for (int i = 0; i > n; --i) {
                this.scrollWindow.previous(this);
            }
            this.updateCurrentRow(n);
            return;
        }
        if (0 == this.serverCursorId) {
            assert (-2 != this.currentRow);
            if (this.currentRow + n < 1) {
                this.moveBeforeFirst();
            } else {
                this.currentRow = this.clientMoveAbsolute(this.currentRow + n);
            }
            return;
        }
        if (-1 == n) {
            this.doServerFetch(512, 0, this.fetchSize);
            if (!this.scrollWindow.next(this)) {
                this.currentRow = 0;
                return;
            }
            while (this.scrollWindow.next(this)) {
            }
            this.scrollWindow.previous(this);
        } else {
            this.doServerFetch(32, n + this.scrollWindow.getRow() - 1, this.fetchSize);
            if (!this.scrollWindow.next(this)) {
                this.currentRow = 0;
                return;
            }
        }
        this.updateCurrentRow(n);
    }

    private final void updateCurrentRow(int n) {
        if (-2 != this.currentRow) {
            assert (this.currentRow >= 1);
            this.currentRow += n;
            assert (this.currentRow >= 1);
        }
    }

    @Override
    public boolean next() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "next");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.moverInit();
        if (-1 == this.currentRow) {
            loggerExternal.exiting(this.getClassNameLogging(), "next", false);
            return false;
        }
        if (!this.isForwardOnly()) {
            if (0 == this.currentRow) {
                this.moveFirst();
            } else {
                this.moveForward(1);
            }
            boolean bl = this.hasCurrentRow();
            loggerExternal.exiting(this.getClassNameLogging(), "next", bl);
            return bl;
        }
        if (0 != this.serverCursorId && this.maxRows > 0 && this.currentRow == this.maxRows) {
            this.currentRow = -1;
            loggerExternal.exiting(this.getClassNameLogging(), "next", false);
            return false;
        }
        if (this.fetchBufferNext()) {
            if (0 == this.currentRow) {
                this.currentRow = 1;
            } else {
                this.updateCurrentRow(1);
            }
            assert (0 == this.maxRows || this.currentRow <= this.maxRows);
            loggerExternal.exiting(this.getClassNameLogging(), "next", true);
            return true;
        }
        if (0 != this.serverCursorId) {
            this.doServerFetch(2, 0, this.fetchSize);
            if (this.fetchBufferNext()) {
                if (0 == this.currentRow) {
                    this.currentRow = 1;
                } else {
                    this.updateCurrentRow(1);
                }
                assert (0 == this.maxRows || this.currentRow <= this.maxRows);
                loggerExternal.exiting(this.getClassNameLogging(), "next", true);
                return true;
            }
        }
        if (-3 == this.rowCount) {
            this.rowCount = this.currentRow;
        }
        this.currentRow = -1;
        loggerExternal.exiting(this.getClassNameLogging(), "next", false);
        return false;
    }

    @Override
    public boolean wasNull() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "wasNull");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "wasNull", this.lastValueWasNull);
        return this.lastValueWasNull;
    }

    @Override
    public boolean isBeforeFirst() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "isBeforeFirst");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        if (0 != this.serverCursorId) {
            switch (this.stmt.getCursorType()) {
                case 4: {
                    this.throwNotScrollable();
                    break;
                }
                case 2: {
                    this.throwUnsupportedCursorOp();
                    break;
                }
                case 16: {
                    this.throwNotScrollable();
                }
            }
        }
        if (this.isOnInsertRow) {
            return false;
        }
        if (0 != this.currentRow) {
            return false;
        }
        if (0 == this.serverCursorId) {
            return this.fetchBufferHasRows();
        }
        assert (this.rowCount >= 0);
        boolean bl = this.rowCount > 0;
        loggerExternal.exiting(this.getClassNameLogging(), "isBeforeFirst", bl);
        return bl;
    }

    @Override
    public boolean isAfterLast() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "isAfterLast");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        if (0 != this.serverCursorId) {
            this.verifyResultSetIsScrollable();
            if (2 == this.stmt.getCursorType() && !this.isForwardOnly()) {
                this.throwUnsupportedCursorOp();
            }
        }
        if (this.isOnInsertRow) {
            return false;
        }
        assert (-1 != this.currentRow || -3 != this.rowCount);
        boolean bl = -1 == this.currentRow && this.rowCount > 0;
        loggerExternal.exiting(this.getClassNameLogging(), "isAfterLast", bl);
        return bl;
    }

    @Override
    public boolean isFirst() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "isFirst");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        if (this.isDynamic()) {
            this.throwUnsupportedCursorOp();
        }
        if (this.isOnInsertRow) {
            return false;
        }
        assert (-2 != this.currentRow);
        boolean bl = 1 == this.currentRow;
        loggerExternal.exiting(this.getClassNameLogging(), "isFirst", bl);
        return bl;
    }

    @Override
    public boolean isLast() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "isLast");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        if (this.isDynamic()) {
            this.throwUnsupportedCursorOp();
        }
        if (this.isOnInsertRow) {
            return false;
        }
        if (!this.hasCurrentRow()) {
            return false;
        }
        assert (this.currentRow >= 1);
        if (-3 != this.rowCount) {
            assert (this.currentRow <= this.rowCount);
            return this.currentRow == this.rowCount;
        }
        assert (0 == this.serverCursorId);
        boolean bl = !this.next();
        this.previous();
        loggerExternal.exiting(this.getClassNameLogging(), "isLast", bl);
        return bl;
    }

    @Override
    public void beforeFirst() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "beforeFirst");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        this.moveBeforeFirst();
        loggerExternal.exiting(this.getClassNameLogging(), "beforeFirst");
    }

    private final void moveBeforeFirst() throws SQLServerException {
        if (0 == this.serverCursorId) {
            this.fetchBufferBeforeFirst();
            this.scrollWindow.clear();
        } else {
            this.doServerFetch(1, 0, 0);
        }
        this.currentRow = 0;
    }

    @Override
    public void afterLast() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "afterLast");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        this.moveAfterLast();
        loggerExternal.exiting(this.getClassNameLogging(), "afterLast");
    }

    private void moveAfterLast() throws SQLServerException {
        assert (!this.isForwardOnly());
        if (0 == this.serverCursorId) {
            this.clientMoveAfterLast();
        } else {
            this.doServerFetch(8, 0, 0);
        }
        this.currentRow = -1;
    }

    @Override
    public boolean first() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "first");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        this.moveFirst();
        boolean bl = this.hasCurrentRow();
        loggerExternal.exiting(this.getClassNameLogging(), "first", bl);
        return bl;
    }

    private final void moveFirst() throws SQLServerException {
        if (0 == this.serverCursorId) {
            this.moveBeforeFirst();
        } else {
            this.doServerFetch(1, 0, this.fetchSize);
        }
        if (!this.scrollWindow.next(this)) {
            this.currentRow = -1;
            return;
        }
        this.currentRow = this.isDynamic() ? -2 : 1;
    }

    @Override
    public boolean last() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "last");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        this.moveLast();
        boolean bl = this.hasCurrentRow();
        loggerExternal.exiting(this.getClassNameLogging(), "last", bl);
        return bl;
    }

    private final void moveLast() throws SQLServerException {
        if (0 == this.serverCursorId) {
            this.currentRow = this.clientMoveAbsolute(-1);
            return;
        }
        this.doServerFetch(8, 0, this.fetchSize);
        if (!this.scrollWindow.next(this)) {
            this.currentRow = -1;
            return;
        }
        while (this.scrollWindow.next(this)) {
        }
        this.scrollWindow.previous(this);
        this.currentRow = this.isDynamic() ? -2 : this.rowCount;
    }

    @Override
    public int getRow() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getRow");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        if (this.isDynamic() && !this.isForwardOnly()) {
            this.throwUnsupportedCursorOp();
        }
        if (!this.hasCurrentRow() || this.isOnInsertRow) {
            return 0;
        }
        assert (this.currentRow >= 1);
        loggerExternal.exiting(this.getClassNameLogging(), "getRow", this.currentRow);
        return this.currentRow;
    }

    @Override
    public boolean absolute(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "absolute");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + " row:" + n + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        if (this.isDynamic()) {
            this.throwUnsupportedCursorOp();
        }
        this.moverInit();
        this.moveAbsolute(n);
        boolean bl = this.hasCurrentRow();
        loggerExternal.exiting(this.getClassNameLogging(), "absolute", bl);
        return bl;
    }

    private void moveAbsolute(int n) throws SQLServerException {
        assert (-2 != this.currentRow);
        assert (!this.isDynamic());
        switch (n) {
            case 0: {
                this.moveBeforeFirst();
                return;
            }
            case 1: {
                this.moveFirst();
                return;
            }
            case -1: {
                this.moveLast();
                return;
            }
        }
        if (this.hasCurrentRow()) {
            assert (this.currentRow >= 1);
            if (n > 0) {
                this.moveRelative(n - this.currentRow);
                return;
            }
            if (-3 != this.rowCount) {
                assert (n < 0);
                this.moveRelative(this.rowCount + n + 1 - this.currentRow);
                return;
            }
        }
        if (0 == this.serverCursorId) {
            this.currentRow = this.clientMoveAbsolute(n);
            return;
        }
        this.doServerFetch(16, n, this.fetchSize);
        if (!this.scrollWindow.next(this)) {
            this.currentRow = n < 0 ? 0 : -1;
            return;
        }
        if (n > 0) {
            this.currentRow = n;
        } else {
            assert (n < 0);
            assert (this.rowCount + n + 1 >= 1);
            this.currentRow = this.rowCount + n + 1;
        }
    }

    private final boolean fetchBufferHasRows() throws SQLServerException {
        assert (0 == this.serverCursorId);
        assert (null != this.tdsReader);
        assert (this.lastColumnIndex >= 0);
        if (this.lastColumnIndex >= 1) {
            return true;
        }
        int n = this.tdsReader.peekTokenType();
        return 209 == n || 171 == n || 170 == n;
    }

    final void discardCurrentRow() throws SQLServerException {
        assert (this.lastColumnIndex >= 0);
        this.updatedCurrentRow = false;
        this.deletedCurrentRow = false;
        if (this.lastColumnIndex >= 1) {
            for (int i = 1; i < this.lastColumnIndex; ++i) {
                this.getColumn(i).clear();
            }
            this.skipColumns(this.columns.length + 1 - this.lastColumnIndex, true);
        }
    }

    final int fetchBufferGetRow() {
        if (this.isForwardOnly()) {
            return this.numFetchedRows;
        }
        return this.scrollWindow.getRow();
    }

    final void fetchBufferBeforeFirst() throws SQLServerException {
        assert (0 == this.serverCursorId);
        assert (null != this.tdsReader);
        this.discardCurrentRow();
        this.fetchBuffer.reset();
        this.lastColumnIndex = 0;
    }

    final TDSReaderMark fetchBufferMark() {
        assert (null != this.tdsReader);
        return this.tdsReader.mark();
    }

    final void fetchBufferReset(TDSReaderMark tDSReaderMark) throws SQLServerException {
        assert (null != this.tdsReader);
        assert (null != tDSReaderMark);
        this.discardCurrentRow();
        this.tdsReader.reset(tDSReaderMark);
        this.lastColumnIndex = 1;
    }

    final boolean fetchBufferNext() throws SQLServerException {
        if (null == this.tdsReader) {
            return false;
        }
        this.discardCurrentRow();
        try {
            if (!this.fetchBuffer.nextRow()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLServerException sQLServerException) {
            this.currentRow = -1;
            this.rowErrorException = sQLServerException;
            throw sQLServerException;
        }
        finally {
            this.lastColumnIndex = 0;
        }
        ++this.numFetchedRows;
        this.lastColumnIndex = 1;
        return true;
    }

    private final void clientMoveAfterLast() throws SQLServerException {
        assert (-2 != this.currentRow);
        int n = 0;
        while (this.fetchBufferNext()) {
            ++n;
        }
        if (-3 == this.rowCount) {
            assert (-1 != this.currentRow);
            this.rowCount = (0 == this.currentRow ? 0 : this.currentRow) + n;
        }
    }

    private final int clientMoveAbsolute(int n) throws SQLServerException {
        assert (0 == this.serverCursorId);
        this.scrollWindow.clear();
        if (n < 0) {
            if (-3 == this.rowCount) {
                this.clientMoveAfterLast();
                this.currentRow = -1;
            }
            assert (this.rowCount >= 0);
            if (this.rowCount + n < 0) {
                this.moveBeforeFirst();
                return 0;
            }
            n = this.rowCount + n + 1;
        }
        assert (n > 0);
        if (-1 == this.currentRow || n <= this.currentRow) {
            this.moveBeforeFirst();
        }
        assert (0 == this.currentRow || this.currentRow < n);
        while (this.currentRow != n) {
            if (!this.fetchBufferNext()) {
                if (-3 == this.rowCount) {
                    this.rowCount = this.currentRow;
                }
                return -1;
            }
            if (0 == this.currentRow) {
                this.currentRow = 1;
                continue;
            }
            this.updateCurrentRow(1);
        }
        return n;
    }

    @Override
    public boolean previous() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "previous");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        if (0 == this.currentRow) {
            return false;
        }
        if (-1 == this.currentRow) {
            this.moveLast();
        } else {
            this.moveBackward(-1);
        }
        boolean bl = this.hasCurrentRow();
        loggerExternal.exiting(this.getClassNameLogging(), "previous", bl);
        return bl;
    }

    private final void cancelInsert() {
        if (this.isOnInsertRow) {
            this.isOnInsertRow = false;
            this.clearColumnsValues();
        }
    }

    final void clearColumnsValues() {
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            this.columns[i].cancelUpdates();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getWarnings");
        loggerExternal.exiting(this.getClassNameLogging(), "getWarnings", null);
        return null;
    }

    @Override
    public void setFetchDirection(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setFetchDirection", n);
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        if (1000 != n && 1001 != n && 1002 != n || 1000 != n && (2003 == this.stmt.resultSetType || 2004 == this.stmt.resultSetType)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidFetchDirection"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, messageFormat.format(objectArray), null, false);
        }
        this.fetchDirection = n;
        loggerExternal.exiting(this.getClassNameLogging(), "setFetchDirection");
    }

    @Override
    public int getFetchDirection() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getFetchDirection");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getFetchDirection", this.fetchDirection);
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setFetchSize", n);
        this.checkClosed();
        if (n < 0) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_invalidFetchSize"), null, false);
        }
        this.fetchSize = 0 == n ? this.stmt.defaultFetchSize : n;
        loggerExternal.exiting(this.getClassNameLogging(), "setFetchSize");
    }

    @Override
    public int getFetchSize() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getFetchSize");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getFloat", this.fetchSize);
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getType");
        this.checkClosed();
        int n = this.stmt.getResultSetType();
        loggerExternal.exiting(this.getClassNameLogging(), "getType", n);
        return n;
    }

    @Override
    public int getConcurrency() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getConcurrency");
        this.checkClosed();
        int n = this.stmt.getResultSetConcurrency();
        loggerExternal.exiting(this.getClassNameLogging(), "getConcurrency", n);
        return n;
    }

    private Column getterGetColumn(int n) throws SQLServerException {
        this.verifyResultSetHasCurrentRow();
        this.verifyCurrentRowIsNotDeleted("R_cantGetColumnValueFromDeletedRow");
        this.verifyValidColumnIndex(n);
        if (this.updatedCurrentRow) {
            this.doRefreshRow();
            this.verifyResultSetHasCurrentRow();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + " Getting Column:" + n);
        }
        return this.loadColumn(n);
    }

    private final Object getValue(int n, JDBCType jDBCType) throws SQLServerException {
        return this.getValue(n, jDBCType, null, null);
    }

    private final Object getValue(int n, JDBCType jDBCType, Calendar calendar) throws SQLServerException {
        return this.getValue(n, jDBCType, null, calendar);
    }

    private final Object getValue(int n, JDBCType jDBCType, InputStreamGetterArgs inputStreamGetterArgs) throws SQLServerException {
        return this.getValue(n, jDBCType, inputStreamGetterArgs, null);
    }

    private final Object getValue(int n, JDBCType jDBCType, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar) throws SQLServerException {
        Object object = this.getterGetColumn(n).getValue(jDBCType, inputStreamGetterArgs, calendar, this.tdsReader);
        this.lastValueWasNull = null == object;
        return object;
    }

    private Object getStream(int n, StreamType streamType) throws SQLServerException {
        Object object = this.getValue(n, streamType.getJDBCType(), new InputStreamGetterArgs(streamType, this.stmt.getExecProps().isResponseBufferingAdaptive(), this.isForwardOnly(), this.toString()));
        this.activeStream = (Closeable)object;
        return object;
    }

    private SQLXML getSQLXMLInternal(int n) throws SQLServerException {
        SQLServerSQLXML sQLServerSQLXML = (SQLServerSQLXML)this.getValue(n, JDBCType.SQLXML, new InputStreamGetterArgs(StreamType.SQLXML, this.stmt.getExecProps().isResponseBufferingAdaptive(), this.isForwardOnly(), this.toString()));
        if (null != sQLServerSQLXML) {
            this.activeStream = sQLServerSQLXML.getStream();
        }
        return sQLServerSQLXML;
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getAsciiStream", n);
        this.checkClosed();
        InputStream inputStream = (InputStream)this.getStream(n, StreamType.ASCII);
        loggerExternal.exiting(this.getClassNameLogging(), "getAsciiStream", inputStream);
        return inputStream;
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getAsciiStream", string);
        this.checkClosed();
        InputStream inputStream = (InputStream)this.getStream(this.findColumn(string), StreamType.ASCII);
        loggerExternal.exiting(this.getClassNameLogging(), "getAsciiStream", inputStream);
        return inputStream;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getBigDecimal", new Object[]{n, n2});
        }
        this.checkClosed();
        BigDecimal bigDecimal = (BigDecimal)this.getValue(n, JDBCType.DECIMAL);
        if (null != bigDecimal) {
            bigDecimal = bigDecimal.setScale(n2, 1);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getBigDecimal", bigDecimal);
        return bigDecimal;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "columnName", new Object[]{string, n});
        }
        this.checkClosed();
        BigDecimal bigDecimal = (BigDecimal)this.getValue(this.findColumn(string), JDBCType.DECIMAL);
        if (null != bigDecimal) {
            bigDecimal = bigDecimal.setScale(n, 1);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getBigDecimal", bigDecimal);
        return bigDecimal;
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBinaryStream", n);
        this.checkClosed();
        InputStream inputStream = (InputStream)this.getStream(n, StreamType.BINARY);
        loggerExternal.exiting(this.getClassNameLogging(), "getBinaryStream", inputStream);
        return inputStream;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBinaryStream", string);
        this.checkClosed();
        InputStream inputStream = (InputStream)this.getStream(this.findColumn(string), StreamType.BINARY);
        loggerExternal.exiting(this.getClassNameLogging(), "getBinaryStream", inputStream);
        return inputStream;
    }

    @Override
    public boolean getBoolean(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBoolean", n);
        this.checkClosed();
        Boolean bl = (Boolean)this.getValue(n, JDBCType.BIT);
        loggerExternal.exiting(this.getClassNameLogging(), "getBoolean", bl);
        return null != bl ? bl : false;
    }

    @Override
    public boolean getBoolean(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBoolean", string);
        this.checkClosed();
        Boolean bl = (Boolean)this.getValue(this.findColumn(string), JDBCType.BIT);
        loggerExternal.exiting(this.getClassNameLogging(), "getBoolean", bl);
        return null != bl ? bl : false;
    }

    @Override
    public byte getByte(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getByte", n);
        this.checkClosed();
        Short s = (Short)this.getValue(n, JDBCType.TINYINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getByte", s);
        return null != s ? s.byteValue() : (byte)0;
    }

    @Override
    public byte getByte(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getByte", string);
        this.checkClosed();
        Short s = (Short)this.getValue(this.findColumn(string), JDBCType.TINYINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getByte", s);
        return null != s ? s.byteValue() : (byte)0;
    }

    @Override
    public byte[] getBytes(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBytes", n);
        this.checkClosed();
        byte[] byArray = (byte[])this.getValue(n, JDBCType.BINARY);
        loggerExternal.exiting(this.getClassNameLogging(), "getBytes", byArray);
        return byArray;
    }

    @Override
    public byte[] getBytes(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBytes", string);
        this.checkClosed();
        byte[] byArray = (byte[])this.getValue(this.findColumn(string), JDBCType.BINARY);
        loggerExternal.exiting(this.getClassNameLogging(), "getBytes", byArray);
        return byArray;
    }

    @Override
    public Date getDate(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDate", n);
        this.checkClosed();
        Date date = (Date)this.getValue(n, JDBCType.DATE);
        loggerExternal.exiting(this.getClassNameLogging(), "getDate", date);
        return date;
    }

    @Override
    public Date getDate(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDate", string);
        this.checkClosed();
        Date date = (Date)this.getValue(this.findColumn(string), JDBCType.DATE);
        loggerExternal.exiting(this.getClassNameLogging(), "getDate", date);
        return date;
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getDate", new Object[]{n, calendar});
        }
        this.checkClosed();
        Date date = (Date)this.getValue(n, JDBCType.DATE, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "getDate", date);
        return date;
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getDate", new Object[]{string, calendar});
        }
        this.checkClosed();
        Date date = (Date)this.getValue(this.findColumn(string), JDBCType.DATE, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "getDate", date);
        return date;
    }

    @Override
    public double getDouble(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDouble", n);
        this.checkClosed();
        Double d = (Double)this.getValue(n, JDBCType.DOUBLE);
        loggerExternal.exiting(this.getClassNameLogging(), "getDouble", d);
        return null != d ? d : 0.0;
    }

    @Override
    public double getDouble(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getDouble", string);
        this.checkClosed();
        Double d = (Double)this.getValue(this.findColumn(string), JDBCType.DOUBLE);
        loggerExternal.exiting(this.getClassNameLogging(), "getDouble", d);
        return null != d ? d : 0.0;
    }

    @Override
    public float getFloat(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getFloat", n);
        this.checkClosed();
        Float f = (Float)this.getValue(n, JDBCType.REAL);
        loggerExternal.exiting(this.getClassNameLogging(), "getFloat", f);
        return null != f ? f.floatValue() : 0.0f;
    }

    @Override
    public float getFloat(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getFloat", string);
        this.checkClosed();
        Float f = (Float)this.getValue(this.findColumn(string), JDBCType.REAL);
        loggerExternal.exiting(this.getClassNameLogging(), "getFloat", f);
        return null != f ? f.floatValue() : 0.0f;
    }

    @Override
    public int getInt(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getInt", n);
        this.checkClosed();
        Integer n2 = (Integer)this.getValue(n, JDBCType.INTEGER);
        loggerExternal.exiting(this.getClassNameLogging(), "getInt", n2);
        return null != n2 ? n2 : 0;
    }

    @Override
    public int getInt(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getInt", string);
        this.checkClosed();
        Integer n = (Integer)this.getValue(this.findColumn(string), JDBCType.INTEGER);
        loggerExternal.exiting(this.getClassNameLogging(), "getInt", n);
        return null != n ? n : 0;
    }

    @Override
    public long getLong(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getLong", n);
        this.checkClosed();
        Long l = (Long)this.getValue(n, JDBCType.BIGINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getLong", l);
        return null != l ? l : 0L;
    }

    @Override
    public long getLong(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getLong", string);
        this.checkClosed();
        Long l = (Long)this.getValue(this.findColumn(string), JDBCType.BIGINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getLong", l);
        return null != l ? l : 0L;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMetaData");
        this.checkClosed();
        if (this.metaData == null) {
            this.metaData = new SQLServerResultSetMetaData(this.stmt.connection, this);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getMetaData", this.metaData);
        return this.metaData;
    }

    @Override
    public Object getObject(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getObject", n);
        this.checkClosed();
        Object object = this.getValue(n, this.getterGetColumn(n).getTypeInfo().getSSType().getJDBCType());
        loggerExternal.exiting(this.getClassNameLogging(), "getObject", object);
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getObject", string);
        this.checkClosed();
        Object object = this.getObject(this.findColumn(string));
        loggerExternal.exiting(this.getClassNameLogging(), "getObject", object);
        return object;
    }

    @Override
    public short getShort(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getShort", n);
        this.checkClosed();
        Short s = (Short)this.getValue(n, JDBCType.SMALLINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getShort", s);
        return null != s ? s : (short)0;
    }

    @Override
    public short getShort(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getShort", string);
        this.checkClosed();
        Short s = (Short)this.getValue(this.findColumn(string), JDBCType.SMALLINT);
        loggerExternal.exiting(this.getClassNameLogging(), "getShort", s);
        return null != s ? s : (short)0;
    }

    @Override
    public String getString(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getString", n);
        this.checkClosed();
        String string = (String)this.getValue(n, JDBCType.CHAR);
        loggerExternal.exiting(this.getClassNameLogging(), "getString", string);
        return string;
    }

    @Override
    public String getString(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getString", string);
        this.checkClosed();
        String string2 = (String)this.getValue(this.findColumn(string), JDBCType.CHAR);
        loggerExternal.exiting(this.getClassNameLogging(), "getString", string2);
        return string2;
    }

    @Override
    public String getNString(int n) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getNString", n);
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        String string = (String)this.getValue(n, JDBCType.NCHAR);
        loggerExternal.exiting(this.getClassNameLogging(), "getNString", string);
        return string;
    }

    @Override
    public String getNString(String string) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getNString", string);
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        String string2 = (String)this.getValue(this.findColumn(string), JDBCType.NCHAR);
        loggerExternal.exiting(this.getClassNameLogging(), "getNString", string2);
        return string2;
    }

    @Override
    public Time getTime(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTime", n);
        this.checkClosed();
        Time time = (Time)this.getValue(n, JDBCType.TIME);
        loggerExternal.exiting(this.getClassNameLogging(), "getTime", time);
        return time;
    }

    @Override
    public Time getTime(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTime", string);
        this.checkClosed();
        Time time = (Time)this.getValue(this.findColumn(string), JDBCType.TIME);
        loggerExternal.exiting(this.getClassNameLogging(), "getTime", time);
        return time;
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTime", new Object[]{n, calendar});
        }
        this.checkClosed();
        Time time = (Time)this.getValue(n, JDBCType.TIME, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "getTime", time);
        return time;
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTime", new Object[]{string, calendar});
        }
        this.checkClosed();
        Time time = (Time)this.getValue(this.findColumn(string), JDBCType.TIME, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "getTime", time);
        return time;
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTimestamp", n);
        this.checkClosed();
        Timestamp timestamp = (Timestamp)this.getValue(n, JDBCType.TIMESTAMP);
        loggerExternal.exiting(this.getClassNameLogging(), "getTimestamp", timestamp);
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTimestamp", string);
        this.checkClosed();
        Timestamp timestamp = (Timestamp)this.getValue(this.findColumn(string), JDBCType.TIMESTAMP);
        loggerExternal.exiting(this.getClassNameLogging(), "getTimestamp", timestamp);
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTimestamp", new Object[]{n, calendar});
        }
        this.checkClosed();
        Timestamp timestamp = (Timestamp)this.getValue(n, JDBCType.TIMESTAMP, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "getTimeStamp", timestamp);
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getTimestamp", new Object[]{string, calendar});
        }
        this.checkClosed();
        Timestamp timestamp = (Timestamp)this.getValue(this.findColumn(string), JDBCType.TIMESTAMP, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "getTimestamp", timestamp);
        return timestamp;
    }

    @Override
    public DateTimeOffset getDateTimeOffset(int n) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getDateTimeOffset", n);
        this.checkClosed();
        if (!this.stmt.connection.isKatmaiOrLater()) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        DateTimeOffset dateTimeOffset = (DateTimeOffset)this.getValue(n, JDBCType.DATETIMEOFFSET);
        loggerExternal.exiting(this.getClassNameLogging(), "getDateTimeOffset", dateTimeOffset);
        return dateTimeOffset;
    }

    @Override
    public DateTimeOffset getDateTimeOffset(String string) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getDateTimeOffset", string);
        this.checkClosed();
        if (!this.stmt.connection.isKatmaiOrLater()) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        DateTimeOffset dateTimeOffset = (DateTimeOffset)this.getValue(this.findColumn(string), JDBCType.DATETIMEOFFSET);
        loggerExternal.exiting(this.getClassNameLogging(), "getDateTimeOffset", dateTimeOffset);
        return dateTimeOffset;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getUnicodeStream", n);
        this.NotImplemented();
        return null;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getUnicodeStream", string);
        this.NotImplemented();
        return null;
    }

    public Object getObject(int n, Map map) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getObject", new Object[]{n, map});
        }
        this.NotImplemented();
        return null;
    }

    @Override
    public Ref getRef(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getRef");
        this.NotImplemented();
        return null;
    }

    @Override
    public Blob getBlob(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBlob", n);
        this.checkClosed();
        Blob blob = (Blob)this.getValue(n, JDBCType.BLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getBlob", blob);
        return blob;
    }

    @Override
    public Blob getBlob(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBlob", string);
        this.checkClosed();
        Blob blob = (Blob)this.getValue(this.findColumn(string), JDBCType.BLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getBlob", blob);
        return blob;
    }

    @Override
    public Clob getClob(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getClob", n);
        this.checkClosed();
        Clob clob = (Clob)this.getValue(n, JDBCType.CLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getClob", clob);
        return clob;
    }

    @Override
    public Clob getClob(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getClob", string);
        this.checkClosed();
        Clob clob = (Clob)this.getValue(this.findColumn(string), JDBCType.CLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getClob", clob);
        return clob;
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getNClob", n);
        this.checkClosed();
        NClob nClob = (NClob)this.getValue(n, JDBCType.NCLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getNClob", nClob);
        return nClob;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getNClob", string);
        this.checkClosed();
        NClob nClob = (NClob)this.getValue(this.findColumn(string), JDBCType.NCLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "getNClob", nClob);
        return nClob;
    }

    @Override
    public Array getArray(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(String string, Map map) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public Ref getRef(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public Array getArray(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    @Override
    public String getCursorName() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getCursorName");
        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_positionedUpdatesNotSupported"), null, false);
        loggerExternal.exiting(this.getClassNameLogging(), "getCursorName", null);
        return null;
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getCharacterStream", n);
        this.checkClosed();
        Reader reader = (Reader)this.getStream(n, StreamType.CHARACTER);
        loggerExternal.exiting(this.getClassNameLogging(), "getCharacterStream", reader);
        return reader;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLServerException {
        this.checkClosed();
        loggerExternal.entering(this.getClassNameLogging(), "getCharacterStream", string);
        Reader reader = (Reader)this.getStream(this.findColumn(string), StreamType.CHARACTER);
        loggerExternal.exiting(this.getClassNameLogging(), "getCharacterStream", reader);
        return reader;
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getNCharacterStream", n);
        this.checkClosed();
        Reader reader = (Reader)this.getStream(n, StreamType.NCHARACTER);
        loggerExternal.exiting(this.getClassNameLogging(), "getNCharacterStream", reader);
        return reader;
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getNCharacterStream", string);
        this.checkClosed();
        Reader reader = (Reader)this.getStream(this.findColumn(string), StreamType.NCHARACTER);
        loggerExternal.exiting(this.getClassNameLogging(), "getNCharacterStream", reader);
        return reader;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBigDecimal", n);
        this.checkClosed();
        BigDecimal bigDecimal = (BigDecimal)this.getValue(n, JDBCType.DECIMAL);
        loggerExternal.exiting(this.getClassNameLogging(), "getBigDecimal", bigDecimal);
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getBigDecimal", string);
        this.checkClosed();
        BigDecimal bigDecimal = (BigDecimal)this.getValue(this.findColumn(string), JDBCType.DECIMAL);
        loggerExternal.exiting(this.getClassNameLogging(), "getBigDecimal", bigDecimal);
        return bigDecimal;
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getSQLXML", n);
        SQLXML sQLXML = this.getSQLXMLInternal(n);
        loggerExternal.exiting(this.getClassNameLogging(), "getSQLXML", sQLXML);
        return sQLXML;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getSQLXML", string);
        SQLXML sQLXML = this.getSQLXMLInternal(this.findColumn(string));
        loggerExternal.exiting(this.getClassNameLogging(), "getSQLXML", sQLXML);
        return sQLXML;
    }

    @Override
    public boolean rowUpdated() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "rowUpdated");
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        loggerExternal.exiting(this.getClassNameLogging(), "rowUpdated", false);
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "rowInserted");
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        loggerExternal.exiting(this.getClassNameLogging(), "rowInserted", false);
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "rowDeleted");
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        if (this.isOnInsertRow || !this.hasCurrentRow()) {
            return false;
        }
        boolean bl = this.currentRowDeleted();
        loggerExternal.exiting(this.getClassNameLogging(), "rowDeleted", bl);
        return bl;
    }

    private final boolean currentRowDeleted() throws SQLServerException {
        assert (this.hasCurrentRow());
        assert (null != this.tdsReader);
        return this.deletedCurrentRow || 0 != this.serverCursorId && 2 == this.loadColumn(this.columns.length).getInt(this.tdsReader);
    }

    private final Column updaterGetColumn(int n) throws SQLServerException {
        this.verifyResultSetIsUpdatable();
        this.verifyValidColumnIndex(n);
        if (!this.columns[n - 1].isUpdatable()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_cantUpdateColumn"), "07009", false);
        }
        if (!this.isOnInsertRow) {
            if (!this.hasCurrentRow()) {
                SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_resultsetNoCurrentRow"), null, true);
            }
            this.verifyCurrentRowIsNotDeleted("R_cantUpdateDeletedRow");
        }
        return this.getColumn(n);
    }

    private void updateValue(int n, JDBCType jDBCType, Object object, JavaType javaType) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(jDBCType, object, javaType, null, null, null, this.stmt.connection);
    }

    private void updateValue(int n, JDBCType jDBCType, Object object, JavaType javaType, Calendar calendar) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(jDBCType, object, javaType, null, calendar, null, this.stmt.connection);
    }

    private void updateStream(int n, StreamType streamType, Object object, JavaType javaType, long l) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(streamType.getJDBCType(), object, javaType, new StreamSetterArgs(streamType, l), null, null, this.stmt.connection);
    }

    private final void updateSQLXMLInternal(int n, SQLXML sQLXML) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(JDBCType.SQLXML, sQLXML, JavaType.SQLXML, new StreamSetterArgs(StreamType.SQLXML, -1L), null, null, this.stmt.connection);
    }

    @Override
    public void updateNull(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "updateNull", n);
        this.checkClosed();
        this.updateValue(n, this.updaterGetColumn(n).getTypeInfo().getSSType().getJDBCType(), null, JavaType.OBJECT);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNull");
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBoolean", new Object[]{n, bl});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.BIT, bl, JavaType.BOOLEAN);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBoolean");
    }

    @Override
    public void updateByte(int n, byte by) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateByte", new Object[]{n, by});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.TINYINT, by, JavaType.BYTE);
        loggerExternal.exiting(this.getClassNameLogging(), "updateByte");
    }

    @Override
    public void updateShort(int n, short s) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateShort", new Object[]{n, s});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.SMALLINT, s, JavaType.SHORT);
        loggerExternal.exiting(this.getClassNameLogging(), "updateShort");
    }

    @Override
    public void updateInt(int n, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateInt", new Object[]{n, n2});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.INTEGER, n2, JavaType.INTEGER);
        loggerExternal.exiting(this.getClassNameLogging(), "updateInt");
    }

    @Override
    public void updateLong(int n, long l) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateLong", new Object[]{n, l});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.BIGINT, l, JavaType.LONG);
        loggerExternal.exiting(this.getClassNameLogging(), "updateLong");
    }

    @Override
    public void updateFloat(int n, float f) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateFloat", new Object[]{n, Float.valueOf(f)});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.REAL, Float.valueOf(f), JavaType.FLOAT);
        loggerExternal.exiting(this.getClassNameLogging(), "updateFloat");
    }

    @Override
    public void updateDouble(int n, double d) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateDouble", new Object[]{n, d});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.DOUBLE, d, JavaType.DOUBLE);
        loggerExternal.exiting(this.getClassNameLogging(), "updateDouble");
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBigDecimal", new Object[]{n, bigDecimal});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.DECIMAL, bigDecimal, JavaType.BIGDECIMAL);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBigDecimal");
    }

    @Override
    public void updateString(int n, String string) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateString", new Object[]{n, string});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.VARCHAR, string, JavaType.STRING);
        loggerExternal.exiting(this.getClassNameLogging(), "updateString");
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateNString", new Object[]{n, string});
        }
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        this.updateValue(n, JDBCType.NVARCHAR, string, JavaType.STRING);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNString");
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateNString", new Object[]{string, string2});
        }
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.NVARCHAR, string2, JavaType.STRING);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNString");
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBytes", new Object[]{n, byArray});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.BINARY, byArray, JavaType.BYTEARRAY);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBytes");
    }

    @Override
    public void updateDate(int n, Date date) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateDate", new Object[]{n, date});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.DATE, date, JavaType.DATE);
        loggerExternal.exiting(this.getClassNameLogging(), "updateDate");
    }

    @Override
    public void updateTime(int n, Time time) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateTime", new Object[]{n, time});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.TIME, time, JavaType.TIME);
        loggerExternal.exiting(this.getClassNameLogging(), "updateTime");
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateTimestamp", new Object[]{n, timestamp});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.TIMESTAMP, timestamp, JavaType.TIMESTAMP);
        loggerExternal.exiting(this.getClassNameLogging(), "updateTimestamp");
    }

    @Override
    public void updateDateTimeOffset(int n, DateTimeOffset dateTimeOffset) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateDateTimeOffset", new Object[]{n, dateTimeOffset});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.DATETIMEOFFSET, dateTimeOffset, JavaType.DATETIMEOFFSET);
        loggerExternal.exiting(this.getClassNameLogging(), "updateDateTimeOffset");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateAsciiStream", new Object[]{n, inputStream});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.ASCII, inputStream, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateAsciiStream", new Object[]{n, inputStream, n2});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.ASCII, inputStream, JavaType.INPUTSTREAM, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "updateAsciiStream", new Object[]{n, inputStream, l});
        this.checkClosed();
        this.updateStream(n, StreamType.ASCII, inputStream, JavaType.INPUTSTREAM, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateAsciiStream", new Object[]{string, inputStream});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.ASCII, inputStream, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateAsciiStream", new Object[]{string, inputStream, n});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.ASCII, inputStream, JavaType.INPUTSTREAM, n);
        loggerExternal.exiting(this.getClassNameLogging(), "updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateAsciiStream", new Object[]{string, inputStream, l});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.ASCII, inputStream, JavaType.INPUTSTREAM, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBinaryStream", new Object[]{n, inputStream});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBinaryStream", new Object[]{n, inputStream, n2});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBinaryStream", new Object[]{n, inputStream, l});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBinaryStream", new Object[]{string, inputStream});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBinaryStream", new Object[]{string, inputStream, n});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, n);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBinaryStream", new Object[]{string, inputStream, l});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateCharacterStream", new Object[]{n, reader});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.CHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateCharacterStream", new Object[]{n, reader, n2});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.CHARACTER, reader, JavaType.READER, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateCharacterStream", new Object[]{n, reader, l});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.CHARACTER, reader, JavaType.READER, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateCharacterStream", new Object[]{string, reader});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.CHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateCharacterStream", new Object[]{string, reader, n});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.CHARACTER, reader, JavaType.READER, n);
        loggerExternal.exiting(this.getClassNameLogging(), "updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateCharacterStream", new Object[]{string, reader, l});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.CHARACTER, reader, JavaType.READER, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateNCharacterStream", new Object[]{n, reader});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.NCHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateNCharacterStream", new Object[]{n, reader, l});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.NCHARACTER, reader, JavaType.READER, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateNCharacterStream", new Object[]{string, reader});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.NCHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateNCharacterStream", new Object[]{string, reader, l});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.NCHARACTER, reader, JavaType.READER, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNCharacterStream");
    }

    @Override
    public void updateObject(int n, Object object) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateObject", new Object[]{n, object});
        }
        this.checkClosed();
        this.updateObject(n, object, (Integer)null);
        loggerExternal.exiting(this.getClassNameLogging(), "updateObject");
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateObject", new Object[]{n, object, n2});
        }
        this.checkClosed();
        this.updateObject(n, object, new Integer(n2));
        loggerExternal.exiting(this.getClassNameLogging(), "updateObject");
    }

    private final void updateObject(int n, Object object, Integer n2) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        SSType sSType = column.getTypeInfo().getSSType();
        if (null == object) {
            column.updateValue(sSType.getJDBCType(), object, JavaType.OBJECT, null, null, n2, this.stmt.connection);
        } else {
            JavaType javaType = JavaType.of(object);
            JDBCType jDBCType = javaType.getJDBCType(sSType, sSType.getJDBCType());
            StreamSetterArgs streamSetterArgs = null;
            switch (javaType) {
                case READER: {
                    streamSetterArgs = new StreamSetterArgs(StreamType.CHARACTER, -1L);
                    break;
                }
                case INPUTSTREAM: {
                    streamSetterArgs = new StreamSetterArgs(jDBCType.isTextual() ? StreamType.CHARACTER : StreamType.BINARY, -1L);
                    break;
                }
                case SQLXML: {
                    streamSetterArgs = new StreamSetterArgs(StreamType.SQLXML, -1L);
                }
            }
            column.updateValue(jDBCType, object, javaType, streamSetterArgs, null, n2, this.stmt.connection);
        }
    }

    @Override
    public void updateNull(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "updateNull", string);
        this.checkClosed();
        int n = this.findColumn(string);
        this.updateValue(n, this.updaterGetColumn(n).getTypeInfo().getSSType().getJDBCType(), null, JavaType.OBJECT);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNull");
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBoolean", new Object[]{string, bl});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.BIT, bl, JavaType.BOOLEAN);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBoolean");
    }

    @Override
    public void updateByte(String string, byte by) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateByte", new Object[]{string, by});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.BINARY, by, JavaType.BYTE);
        loggerExternal.exiting(this.getClassNameLogging(), "updateByte");
    }

    @Override
    public void updateShort(String string, short s) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateShort", new Object[]{string, s});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.SMALLINT, s, JavaType.SHORT);
        loggerExternal.exiting(this.getClassNameLogging(), "updateShort");
    }

    @Override
    public void updateInt(String string, int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateInt", new Object[]{string, n});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.INTEGER, n, JavaType.INTEGER);
        loggerExternal.exiting(this.getClassNameLogging(), "updateInt");
    }

    @Override
    public void updateLong(String string, long l) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateLong", new Object[]{string, l});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.BIGINT, l, JavaType.LONG);
        loggerExternal.exiting(this.getClassNameLogging(), "updateLong");
    }

    @Override
    public void updateFloat(String string, float f) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateFloat", new Object[]{string, Float.valueOf(f)});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.REAL, Float.valueOf(f), JavaType.FLOAT);
        loggerExternal.exiting(this.getClassNameLogging(), "updateFloat");
    }

    @Override
    public void updateDouble(String string, double d) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateDouble", new Object[]{string, d});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.DOUBLE, d, JavaType.DOUBLE);
        loggerExternal.exiting(this.getClassNameLogging(), "updateDouble");
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBigDecimal", new Object[]{string, bigDecimal});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.DECIMAL, bigDecimal, JavaType.BIGDECIMAL);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBigDecimal");
    }

    @Override
    public void updateString(String string, String string2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateString", new Object[]{string, string2});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.VARCHAR, string2, JavaType.STRING);
        loggerExternal.exiting(this.getClassNameLogging(), "updateString");
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBytes", new Object[]{string, byArray});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.BINARY, byArray, JavaType.BYTEARRAY);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBytes");
    }

    @Override
    public void updateDate(String string, Date date) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateDate", new Object[]{string, date});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.DATE, date, JavaType.DATE);
        loggerExternal.exiting(this.getClassNameLogging(), "updateDate");
    }

    @Override
    public void updateTime(String string, Time time) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateTime", new Object[]{string, time});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.TIME, time, JavaType.TIME);
        loggerExternal.exiting(this.getClassNameLogging(), "updateTime");
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateTimestamp", new Object[]{string, timestamp});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.TIMESTAMP, timestamp, JavaType.TIMESTAMP);
        loggerExternal.exiting(this.getClassNameLogging(), "updateTimestamp");
    }

    @Override
    public void updateDateTimeOffset(String string, DateTimeOffset dateTimeOffset) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateDateTimeOffset", new Object[]{string, dateTimeOffset});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.DATETIMEOFFSET, dateTimeOffset, JavaType.DATETIMEOFFSET);
        loggerExternal.exiting(this.getClassNameLogging(), "updateDateTimeOffset");
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateObject", new Object[]{string, object, n});
        }
        this.checkClosed();
        this.updateObject(this.findColumn(string), object, (Integer)n);
        loggerExternal.exiting(this.getClassNameLogging(), "updateObject");
    }

    @Override
    public void updateObject(String string, Object object) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateObject", new Object[]{string, object});
        }
        this.checkClosed();
        this.updateObject(this.findColumn(string), object, (Integer)null);
        loggerExternal.exiting(this.getClassNameLogging(), "updateObject");
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateSQLXML", new Object[]{n, sQLXML});
        }
        this.updateSQLXMLInternal(n, sQLXML);
        loggerExternal.exiting(this.getClassNameLogging(), "updateSQLXML");
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateSQLXML", new Object[]{string, sQLXML});
        }
        DriverJDBCVersion.checkSupportsJDBC4();
        this.updateSQLXMLInternal(this.findColumn(string), sQLXML);
        loggerExternal.exiting(this.getClassNameLogging(), "updateSQLXML");
    }

    @Override
    public int getHoldability() throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "getHoldability");
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        int n = 0 == this.stmt.getServerCursorId() ? 1 : (!this.stmt.connection.isYukonOrLater() ? this.stmt.connection.getHoldabilityInternal() : this.stmt.getExecProps().getHoldability());
        loggerExternal.exiting(this.getClassNameLogging(), "getHoldability", n);
        return n;
    }

    @Override
    public void insertRow() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "insertRow");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        if (!this.isOnInsertRow) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_mustBeOnInsertRow"), null, true);
        }
        Column column = null;
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i].hasUpdates()) {
                column = this.columns[i];
                break;
            }
            if (null != column || !this.columns[i].isUpdatable()) continue;
            column = this.columns[i];
        }
        if (null == column) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_noColumnParameterValue"), null, true);
        }
        assert (column.isUpdatable());
        assert (null != column.getTableName());
        final class InsertRowRPC
        extends TDSCommand {
            final String tableName;

            InsertRowRPC(String string) {
                super("InsertRowRPC", 0);
                this.tableName = string;
            }

            @Override
            final boolean doExecute() throws SQLServerException {
                SQLServerResultSet.this.doInsertRowRPC(this, this.tableName);
                return true;
            }
        }
        this.stmt.executeCommand(new InsertRowRPC(column.getTableName().asEscapedString()));
        if (-3 != this.rowCount) {
            ++this.rowCount;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "insertRow");
    }

    private final void doInsertRowRPC(TDSCommand tDSCommand, String string) throws SQLServerException {
        assert (0 != this.serverCursorId);
        assert (null != string);
        assert (string.length() > 0);
        TDSWriter tDSWriter = tDSCommand.startRequest((byte)3);
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)1);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.serverCursorId), false);
        tDSWriter.writeRPCInt(null, new Integer(4), false);
        tDSWriter.writeRPCInt(null, new Integer(this.fetchBufferGetRow()), false);
        if (this.hasUpdatedColumns()) {
            if (!this.stmt.connection.isYukonOrLater() && string.length() > 128) {
                tDSWriter.writeRPCStringUnicode("");
            } else {
                tDSWriter.writeRPCStringUnicode(string);
            }
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].sendByRPC(tDSWriter, this.stmt.connection);
            }
        } else {
            tDSWriter.writeRPCStringUnicode("");
            tDSWriter.writeRPCStringUnicode("INSERT INTO " + string + " DEFAULT VALUES");
        }
        TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "updateRow");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        this.verifyResultSetIsNotOnInsertRow();
        this.verifyResultSetHasCurrentRow();
        this.verifyCurrentRowIsNotDeleted("R_cantUpdateDeletedRow");
        if (!this.hasUpdatedColumns()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_noColumnParameterValue"), null, true);
        }
        try {
            final class UpdateRowRPC
            extends TDSCommand {
                UpdateRowRPC() {
                    super("UpdateRowRPC", 0);
                }

                @Override
                final boolean doExecute() throws SQLServerException {
                    SQLServerResultSet.this.doUpdateRowRPC(this);
                    return true;
                }
            }
            this.stmt.executeCommand(new UpdateRowRPC());
        }
        finally {
            this.cancelUpdates();
        }
        this.updatedCurrentRow = true;
        loggerExternal.exiting(this.getClassNameLogging(), "updateRow");
    }

    private final void doUpdateRowRPC(TDSCommand tDSCommand) throws SQLServerException {
        assert (0 != this.serverCursorId);
        TDSWriter tDSWriter = tDSCommand.startRequest((byte)3);
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)1);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.serverCursorId), false);
        tDSWriter.writeRPCInt(null, new Integer(33), false);
        tDSWriter.writeRPCInt(null, new Integer(this.fetchBufferGetRow()), false);
        tDSWriter.writeRPCStringUnicode("");
        assert (this.hasUpdatedColumns());
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].sendByRPC(tDSWriter, this.stmt.connection);
        }
        TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
    }

    final boolean hasUpdatedColumns() {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].hasUpdates()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "deleteRow");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        this.verifyResultSetIsNotOnInsertRow();
        this.verifyResultSetHasCurrentRow();
        this.verifyCurrentRowIsNotDeleted("R_cantUpdateDeletedRow");
        try {
            final class DeleteRowRPC
            extends TDSCommand {
                DeleteRowRPC() {
                    super("DeleteRowRPC", 0);
                }

                @Override
                final boolean doExecute() throws SQLServerException {
                    SQLServerResultSet.this.doDeleteRowRPC(this);
                    return true;
                }
            }
            this.stmt.executeCommand(new DeleteRowRPC());
        }
        finally {
            this.cancelUpdates();
        }
        this.deletedCurrentRow = true;
        loggerExternal.exiting(this.getClassNameLogging(), "deleteRow");
    }

    private final void doDeleteRowRPC(TDSCommand tDSCommand) throws SQLServerException {
        assert (0 != this.serverCursorId);
        TDSWriter tDSWriter = tDSCommand.startRequest((byte)3);
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)1);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.serverCursorId), false);
        tDSWriter.writeRPCInt(null, new Integer(34), false);
        tDSWriter.writeRPCInt(null, new Integer(this.fetchBufferGetRow()), false);
        tDSWriter.writeRPCStringUnicode("");
        TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
    }

    @Override
    public void refreshRow() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "refreshRow");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.verifyResultSetIsUpdatable();
        this.verifyResultSetIsNotOnInsertRow();
        this.verifyResultSetHasCurrentRow();
        this.verifyCurrentRowIsNotDeleted("R_cantUpdateDeletedRow");
        if (1004 == this.stmt.getResultSetType() || 0 == this.serverCursorId) {
            return;
        }
        this.cancelUpdates();
        this.doRefreshRow();
        loggerExternal.exiting(this.getClassNameLogging(), "refreshRow");
    }

    private void doRefreshRow() throws SQLServerException {
        int n;
        assert (this.hasCurrentRow());
        int n2 = this.fetchBufferGetRow();
        this.doServerFetch(128, 0, 0);
        for (n = 0; n < n2 && (this.isForwardOnly() ? this.fetchBufferNext() : this.scrollWindow.next(this)); ++n) {
        }
        if (n < n2) {
            this.currentRow = -1;
            return;
        }
        this.updatedCurrentRow = false;
    }

    private final void cancelUpdates() {
        if (!this.isOnInsertRow) {
            this.clearColumnsValues();
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "cancelRowUpdates");
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        this.verifyResultSetIsNotOnInsertRow();
        this.cancelUpdates();
        loggerExternal.exiting(this.getClassNameLogging(), "cancelRowUpdates");
    }

    @Override
    public void moveToInsertRow() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "moveToInsertRow");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        this.cancelUpdates();
        this.isOnInsertRow = true;
        loggerExternal.exiting(this.getClassNameLogging(), "moveToInsertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "moveToCurrentRow");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        this.cancelInsert();
        loggerExternal.exiting(this.getClassNameLogging(), "moveToCurrentRow");
    }

    @Override
    public Statement getStatement() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getStatement");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getStatement", this.stmt);
        return this.stmt;
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateClob", new Object[]{n, clob});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.CLOB, clob, JavaType.CLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "updateClob");
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateClob", new Object[]{n, reader});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.CHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateClob");
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateClob", new Object[]{n, reader, l});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.CHARACTER, reader, JavaType.READER, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateClob");
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateClob", new Object[]{string, clob});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.CLOB, clob, JavaType.CLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "updateClob");
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateClob", new Object[]{string, reader});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.CHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateClob");
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateClob", new Object[]{string, reader, l});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.CHARACTER, reader, JavaType.READER, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateClob");
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateClob", new Object[]{n, nClob});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.NCLOB, nClob, JavaType.NCLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNClob");
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateNClob", new Object[]{n, reader});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.NCHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNClob");
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateNClob", new Object[]{n, reader, l});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.NCHARACTER, reader, JavaType.READER, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNClob");
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateNClob", new Object[]{string, nClob});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.NCLOB, nClob, JavaType.NCLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNClob");
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateNClob", new Object[]{string, reader});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.NCHARACTER, reader, JavaType.READER, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNClob");
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateNClob", new Object[]{string, reader, l});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.NCHARACTER, reader, JavaType.READER, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateNClob");
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBlob", new Object[]{n, blob});
        }
        this.checkClosed();
        this.updateValue(n, JDBCType.BLOB, blob, JavaType.BLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBlob");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBlob", new Object[]{n, inputStream});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBlob");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBlob", new Object[]{n, inputStream, l});
        }
        this.checkClosed();
        this.updateStream(n, StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBlob");
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBlob", new Object[]{string, blob});
        }
        this.checkClosed();
        this.updateValue(this.findColumn(string), JDBCType.BLOB, blob, JavaType.BLOB);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBlob");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBlob", new Object[]{string, inputStream});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBlob");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "updateBlob", new Object[]{string, inputStream, l});
        }
        this.checkClosed();
        this.updateStream(this.findColumn(string), StreamType.BINARY, inputStream, JavaType.INPUTSTREAM, l);
        loggerExternal.exiting(this.getClassNameLogging(), "updateBlob");
    }

    @Override
    public void updateArray(int n, Array array) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    @Override
    public void updateArray(String string, Array array) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    @Override
    public URL getURL(int n) throws SQLServerException {
        this.stmt.NotImplemented();
        return null;
    }

    @Override
    public URL getURL(String string) throws SQLServerException {
        this.stmt.NotImplemented();
        return null;
    }

    private final void checkShilohCancel(TDSReader tDSReader) throws SQLServerException {
        assert (this.stmt.executedSqlDirectly);
        assert (172 == tDSReader.peekTokenType());
        if (!this.stmt.connection.isYukonOrLater()) {
            tDSReader.getCommand().checkForInterrupt();
        }
    }

    final void doServerFetch(int n, int n2, int n3) throws SQLServerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + " fetchType:" + n + " startRow:" + n2 + " numRows:" + n3);
        }
        this.discardFetchBuffer();
        this.fetchBuffer.init();
        CursorFetchCommand cursorFetchCommand = new CursorFetchCommand(this.serverCursorId, n, n2, n3);
        this.stmt.executeCommand(cursorFetchCommand);
        this.numFetchedRows = 0;
        this.lastColumnIndex = 0;
        if (null != this.scrollWindow && 128 != n) {
            this.scrollWindow.resize(this.fetchSize);
        }
        if (n3 < 0 || n2 < 0) {
            block7: {
                try {
                    while (this.scrollWindow.next(this)) {
                    }
                }
                catch (SQLException sQLException) {
                    if (!logger.isLoggable(Level.FINER)) break block7;
                    logger.finer(this.toString() + " Ignored exception from row error during server cursor fixup: " + sQLException.getMessage());
                }
            }
            if (this.fetchBuffer.needsServerCursorFixup()) {
                this.doServerFetch(1, 0, 0);
                return;
            }
            this.scrollWindow.reset();
        }
    }

    private final void discardFetchBuffer() {
        block4: {
            this.fetchBuffer.clearStartMark();
            if (null != this.scrollWindow) {
                this.scrollWindow.clear();
            }
            try {
                while (this.fetchBufferNext()) {
                }
            }
            catch (SQLServerException sQLServerException) {
                if (!logger.isLoggable(Level.FINER)) break block4;
                logger.finer(this + " Encountered exception discarding fetch buffer: " + sQLServerException.getMessage());
            }
        }
    }

    final void closeServerCursor() {
        if (0 == this.serverCursorId) {
            return;
        }
        if (this.stmt.connection.isClosedInternal()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this + ": Not closing cursor:" + this.serverCursorId + "; connection is already closed.");
            }
        } else {
            block8: {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + " Closing cursor:" + this.serverCursorId);
                }
                try {
                    final class CloseServerCursorCommand
                    extends UninterruptableTDSCommand {
                        CloseServerCursorCommand() {
                            super("closeServerCursor");
                        }

                        @Override
                        final boolean doExecute() throws SQLServerException {
                            TDSWriter tDSWriter = this.startRequest((byte)3);
                            tDSWriter.writeShort((short)-1);
                            tDSWriter.writeShort((short)9);
                            tDSWriter.writeByte((byte)0);
                            tDSWriter.writeByte((byte)0);
                            tDSWriter.writeRPCInt(null, new Integer(SQLServerResultSet.this.serverCursorId), false);
                            TDSParser.parse(this.startResponse(), this.getLogContext());
                            return true;
                        }
                    }
                    this.stmt.executeCommand(new CloseServerCursorCommand());
                }
                catch (SQLServerException sQLServerException) {
                    if (!logger.isLoggable(Level.FINER)) break block8;
                    logger.finer(this.toString() + " Ignored error closing cursor:" + this.serverCursorId + " " + sQLServerException.getMessage());
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " Closed cursor:" + this.serverCursorId);
            }
        }
    }

    private final class CursorFetchCommand
    extends TDSCommand {
        private final int serverCursorId;
        private int fetchType;
        private int startRow;
        private int numRows;

        CursorFetchCommand(int n, int n2, int n3, int n4) {
            super("doServerFetch", ((SQLServerResultSet)SQLServerResultSet.this).stmt.queryTimeout);
            this.serverCursorId = n;
            this.fetchType = n2;
            this.startRow = n3;
            this.numRows = n4;
        }

        @Override
        final boolean doExecute() throws SQLServerException {
            TDSWriter tDSWriter = this.startRequest((byte)3);
            tDSWriter.writeShort((short)-1);
            tDSWriter.writeShort((short)7);
            tDSWriter.writeByte((byte)2);
            tDSWriter.writeByte((byte)0);
            tDSWriter.writeRPCInt(null, new Integer(this.serverCursorId), false);
            tDSWriter.writeRPCInt(null, new Integer(this.fetchType), false);
            tDSWriter.writeRPCInt(null, new Integer(this.startRow), false);
            tDSWriter.writeRPCInt(null, new Integer(this.numRows), false);
            SQLServerResultSet.this.tdsReader = this.startResponse(SQLServerResultSet.this.isForwardOnly() && 1007 != ((SQLServerResultSet)SQLServerResultSet.this).stmt.resultSetConcurrency && SQLServerResultSet.this.stmt.getExecProps().wasResponseBufferingSet() && SQLServerResultSet.this.stmt.getExecProps().isResponseBufferingAdaptive());
            return false;
        }

        @Override
        final void processResponse(TDSReader tDSReader) throws SQLServerException {
            SQLServerResultSet.this.tdsReader = tDSReader;
            SQLServerResultSet.this.discardFetchBuffer();
        }
    }

    private final class FetchBuffer {
        private final FetchBufferTokenHandler fetchBufferTokenHandler = new FetchBufferTokenHandler();
        private TDSReaderMark startMark;
        private boolean foundRow;
        private boolean done;
        private boolean needsServerCursorFixup;

        final void clearStartMark() {
            this.startMark = null;
        }

        final boolean needsServerCursorFixup() {
            return this.needsServerCursorFixup;
        }

        FetchBuffer() {
            this.init();
        }

        final void ensureStartMark() {
            if (null == this.startMark && !SQLServerResultSet.this.isForwardOnly()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + " Setting fetch buffer start mark");
                }
                this.startMark = SQLServerResultSet.this.tdsReader.mark();
            }
        }

        final void reset() {
            assert (null != SQLServerResultSet.this.tdsReader);
            assert (null != this.startMark);
            SQLServerResultSet.this.tdsReader.reset(this.startMark);
            this.foundRow = false;
            this.done = false;
        }

        final void init() {
            this.startMark = 0 == SQLServerResultSet.this.serverCursorId && !SQLServerResultSet.this.isForwardOnly() ? SQLServerResultSet.this.tdsReader.mark() : null;
            this.foundRow = false;
            this.done = false;
            this.needsServerCursorFixup = false;
        }

        final boolean nextRow() throws SQLServerException {
            this.foundRow = false;
            while (null != SQLServerResultSet.this.tdsReader && !this.done && !this.foundRow) {
                TDSParser.parse(SQLServerResultSet.this.tdsReader, this.fetchBufferTokenHandler);
            }
            if (!this.foundRow && null != this.fetchBufferTokenHandler.getDatabaseError()) {
                SQLServerException.makeFromDatabaseError(((SQLServerResultSet)SQLServerResultSet.this).stmt.connection, null, this.fetchBufferTokenHandler.getDatabaseError().getMessage(), this.fetchBufferTokenHandler.getDatabaseError(), false);
            }
            return this.foundRow;
        }

        private final class FetchBufferTokenHandler
        extends TDSTokenHandler {
            FetchBufferTokenHandler() {
                super("FetchBufferTokenHandler");
            }

            @Override
            boolean onColMetaData(TDSReader tDSReader) throws SQLServerException {
                new StreamColumns().setFromTDS(tDSReader);
                return true;
            }

            @Override
            boolean onRow(TDSReader tDSReader) throws SQLServerException {
                FetchBuffer.this.ensureStartMark();
                if (209 != tDSReader.readUnsignedByte()) assert (false);
                FetchBuffer.this.foundRow = true;
                return false;
            }

            @Override
            boolean onDone(TDSReader tDSReader) throws SQLServerException {
                FetchBuffer.this.ensureStartMark();
                StreamDone streamDone = new StreamDone();
                streamDone.setFromTDS(tDSReader);
                FetchBuffer.this.done = true;
                return 0 != SQLServerResultSet.this.serverCursorId;
            }

            @Override
            boolean onRetStatus(TDSReader tDSReader) throws SQLServerException {
                StreamRetStatus streamRetStatus = new StreamRetStatus();
                streamRetStatus.setFromTDS(tDSReader);
                FetchBuffer.this.needsServerCursorFixup = 2 == streamRetStatus.getStatus();
                return true;
            }

            @Override
            boolean onRetValue(TDSReader tDSReader) throws SQLServerException {
                FetchBuffer.this.done = true;
                SQLServerResultSet.this.checkShilohCancel(tDSReader);
                tDSReader.throwInvalidTDS();
                return false;
            }

            @Override
            void onEOF(TDSReader tDSReader) throws SQLServerException {
                super.onEOF(tDSReader);
                FetchBuffer.this.done = true;
            }
        }
    }
}

