/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.server.integration.TaskManagement;
import org.jbpm.api.TaskService;
import org.jbpm.api.task.Task;
import org.jbpm.integration.console.JBPMIntegration;
import org.jbpm.integration.console.ModelAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManagementImpl
extends JBPMIntegration
implements TaskManagement {
    public List<TaskRef> getAssignedTasks(String idRef) {
        TaskService taskService = (TaskService)this.processEngine.get(TaskService.class);
        ArrayList<TaskRef> results = new ArrayList<TaskRef>();
        List assignedTasks = taskService.findPersonalTasks(idRef);
        this.adoptTasks(assignedTasks, results);
        return results;
    }

    public List<TaskRef> getUnassignedTasks(String idRef, String participationType) {
        TaskService taskService = (TaskService)this.processEngine.get(TaskService.class);
        ArrayList<TaskRef> results = new ArrayList<TaskRef>();
        if (null != participationType && !participationType.equals("candidate")) {
            throw new IllegalArgumentException("Unknown participation type: " + participationType);
        }
        List groupTasks = taskService.findGroupTasks(idRef);
        this.adoptTasks(groupTasks, results);
        return results;
    }

    private void adoptTasks(List<Task> tasks, List<TaskRef> results) {
        for (Task t0 : tasks) {
            results.add(ModelAdaptor.adoptTask(t0));
        }
    }

    public TaskRef getTaskById(long taskId) {
        TaskService taskService = (TaskService)this.processEngine.get(TaskService.class);
        Task t0 = taskService.getTask(Long.toString(taskId));
        return ModelAdaptor.adoptTask(t0);
    }

    public void assignTask(long taskId, String idRef, String performingUser) {
        TaskService taskService = (TaskService)this.processEngine.get(TaskService.class);
        taskService.assignTask(Long.toString(taskId), idRef);
    }

    public void releaseTask(long taskId, String performingUser) {
        TaskService taskService = (TaskService)this.processEngine.get(TaskService.class);
        taskService.assignTask(Long.toString(taskId), null);
    }

    public void completeTask(long taskId, Map data, String performingUser) {
        TaskService taskService = (TaskService)this.processEngine.get(TaskService.class);
        if (data != null) {
            taskService.setVariables(Long.toString(taskId), data);
        }
        taskService.completeTask(Long.toString(taskId));
    }

    public void completeTask(long taskId, String outcome, Map data, String performingUser) {
        TaskService taskService = (TaskService)this.processEngine.get(TaskService.class);
        if (data != null) {
            taskService.setVariables(Long.toString(taskId), data);
        }
        taskService.completeTask(Long.toString(taskId), outcome);
    }
}

