/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.flownodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.model.Activity;
import org.jbpm.bpmn.flownodes.AbstractGatewayActivity;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMergingGatewayActivity
extends AbstractGatewayActivity {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(AbstractMergingGatewayActivity.class.getName());
    protected LockMode lockMode = LockMode.UPGRADE;

    @Override
    public void execute(ActivityExecution execution) {
        this.execute((ExecutionImpl)execution);
    }

    @Override
    public void execute(ExecutionImpl execution) {
        int nrOfIncoming = execution.getActivity().getIncomingTransitions().size();
        if (nrOfIncoming == 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Only one incoming sequence flow found. Executing fork logic.");
            }
            this.fork(execution);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Multiple incoming sequence flow found. Handling incoming execution.");
            }
            boolean allExecutionsArrived = this.handleIncomingExecution(execution);
            if (LOG.isDebugEnabled()) {
                LOG.debug("All executions arrived at the gateway: " + allExecutionsArrived);
            }
            if (allExecutionsArrived) {
                ExecutionImpl outgoingExecution = this.join(execution);
                this.fork(outgoingExecution);
            }
        }
    }

    protected boolean handleIncomingExecution(ExecutionImpl execution) {
        if ("active-concurrent".equals(execution.getState())) {
            Session session = EnvironmentImpl.getFromCurrent(Session.class);
            session.lock((Object)execution.getParent(), this.lockMode);
            execution.setState("inactive-join");
        }
        execution.waitForSignal();
        return this.isComplete(execution);
    }

    protected ExecutionImpl join(ExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        ExecutionImpl concurrentRoot = execution.getParent();
        if (concurrentRoot == null) {
            return execution;
        }
        List<ExecutionImpl> joinedExecutions = this.getJoinedExecutions(concurrentRoot, activity);
        this.endJoinedExecutions(joinedExecutions);
        ExecutionImpl outgoingExecution = null;
        if (concurrentRoot.getExecutions().size() == 0) {
            outgoingExecution = concurrentRoot;
            outgoingExecution.setState("active-root");
        } else {
            outgoingExecution = concurrentRoot.createExecution();
            outgoingExecution.setState("active-concurrent");
        }
        outgoingExecution.setActivity((Activity)activity);
        return outgoingExecution;
    }

    protected List<ExecutionImpl> getJoinedExecutions(ExecutionImpl concurrentRoot, Activity activity) {
        ArrayList<ExecutionImpl> joinedExecutions = new ArrayList<ExecutionImpl>();
        Collection<ExecutionImpl> concurrentExecutions = concurrentRoot.getExecutions();
        for (ExecutionImpl concurrentExecution : concurrentExecutions) {
            if (!"inactive-join".equals(concurrentExecution.getState()) || concurrentExecution.getActivity() != activity) continue;
            joinedExecutions.add(concurrentExecution);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found " + joinedExecutions.size() + " executions currently waiting at the gateway");
        }
        return joinedExecutions;
    }

    protected void endJoinedExecutions(List<ExecutionImpl> joinedExecutions) {
        for (ExecutionImpl joinedExecution : joinedExecutions) {
            joinedExecution.end();
        }
    }

    protected abstract void fork(ExecutionImpl var1);

    protected abstract boolean isComplete(ExecutionImpl var1);
}

