/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.flownodes;

import java.util.List;
import org.jbpm.bpmn.flownodes.BpmnBinding;
import org.jbpm.bpmn.flownodes.JavaServiceTaskActivity;
import org.jbpm.bpmn.model.BpmnProcessDefinition;
import org.jbpm.bpmn.parser.BpmnParser;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.descriptor.ArgDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.jbpm.pvm.internal.wire.operation.InvokeOperation;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

public class ServiceTaskBinding
extends BpmnBinding {
    static final String TAG = "serviceTask";

    public ServiceTaskBinding() {
        super(TAG);
    }

    public Object parse(Element element, Parse parse, BpmnParser bpmnParser) {
        JavaServiceTaskActivity javaActivity = new JavaServiceTaskActivity();
        BpmnProcessDefinition bpmnProcessDefinition = parse.contextStackFind(BpmnProcessDefinition.class);
        String operationRef = XmlUtil.attribute(element, "operationRef", parse);
        Element operationElement = bpmnProcessDefinition.getOperations().get(operationRef);
        if (operationElement == null) {
            parse.addProblem("No operation found for operationRef " + operationRef, operationElement);
        }
        Element interfaceElement = (Element)operationElement.getParentNode();
        javaActivity.setMethodName(operationElement.getAttribute("name"));
        String outMessageRef = XmlUtil.element(operationElement, "outMessageRef").getTextContent().trim();
        String outStructureRef = bpmnProcessDefinition.getMessages().get(outMessageRef).getAttribute("structureRef");
        Element outItemDefinition = bpmnProcessDefinition.getItemDefinitions().get(outStructureRef);
        Element var = XmlUtil.element(outItemDefinition, "var");
        javaActivity.setVariableName(var.getAttribute("name"));
        String inMessageRef = XmlUtil.element(operationElement, "inMessageRef").getTextContent().trim();
        String inStructureRef = bpmnProcessDefinition.getMessages().get(inMessageRef).getAttribute("structureRef");
        Element itemDefinition = bpmnProcessDefinition.getItemDefinitions().get(inStructureRef);
        List<Element> argElements = XmlUtil.elements(itemDefinition, "arg");
        if (!argElements.isEmpty()) {
            List<ArgDescriptor> argDescriptors = wireParser.parseArgs(argElements, parse);
            InvokeOperation invokeOperation = new InvokeOperation();
            invokeOperation.setArgDescriptors(argDescriptors);
            javaActivity.setInvokeOperation(invokeOperation);
        }
        if (interfaceElement.getAttribute("name") != null) {
            ObjectDescriptor objectDescriptor = new ObjectDescriptor();
            objectDescriptor.setClassName(interfaceElement.getAttribute("name"));
            Object target = WireContext.create(objectDescriptor);
            if (target == null) {
                parse.addProblem("name attribute must resolv to a class in serviceTask", element);
            }
            javaActivity.setTarget(target);
        } else {
            parse.addProblem("no target specified in serviceTask : must specify attribute 'class' or 'expr'", element);
        }
        javaActivity.setDefault(this.getDefault());
        return javaActivity;
    }
}

