/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.api.model.Transition;
import org.jbpm.bpmn.common.Resource;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.model.VariableDefinitionImpl;
import org.jbpm.pvm.internal.task.TaskDefinitionImpl;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnProcessDefinition
extends ProcessDefinitionImpl {
    private static final long serialVersionUID = 1L;
    protected Map<String, Element> messages = new HashMap<String, Element>();
    protected Map<String, Element> itemDefinitions = new HashMap<String, Element>();
    protected Map<String, Element> interfaces = new HashMap<String, Element>();
    protected Map<String, Element> operations = new HashMap<String, Element>();
    protected Map<String, Resource> resources = new HashMap<String, Resource>();
    protected Map<String, Transition> sequenceFlow = new HashMap<String, Transition>();
    protected Map<String, Set<String>> sourceToTargetMapping = new HashMap<String, Set<String>>();

    @Override
    protected ExecutionImpl newProcessInstance() {
        return new ExecutionImpl();
    }

    public TaskDefinitionImpl createTaskDefinition(String name) {
        TaskDefinitionImpl taskDefinition = new TaskDefinitionImpl();
        taskDefinition.setName(name);
        this.taskDefinitions.put(name, taskDefinition);
        return taskDefinition;
    }

    public Map<String, TaskDefinitionImpl> getTaskDefinitions() {
        return this.taskDefinitions;
    }

    public String getType(String typeRef) {
        return this.itemDefinitions.get(typeRef).getAttribute("strutcureRef");
    }

    public void setVariableDefinition(List<VariableDefinitionImpl> variableDefinitions) {
        this.variableDefinitions = variableDefinitions;
    }

    public Resource getResource(String ref) {
        return this.resources.get(ref);
    }

    public Map<String, Resource> getResources() {
        return this.resources;
    }

    public Map<String, Element> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(Map<String, Element> interfaces) {
        this.interfaces = interfaces;
    }

    public Map<String, Element> getOperations() {
        return this.operations;
    }

    public void setOperations(Map<String, Element> operations) {
        this.operations = operations;
    }

    public Map<String, Element> getMessages() {
        return this.messages;
    }

    public void setMessages(Map<String, Element> messages) {
        this.messages = messages;
    }

    public Map<String, Element> getItemDefinitions() {
        return this.itemDefinitions;
    }

    public void setItemDefinitions(Map<String, Element> itemDefinitions) {
        this.itemDefinitions = itemDefinitions;
    }

    public void addSequenceFlow(String transitionId, Transition transition) {
        this.sequenceFlow.put(transitionId, transition);
        String source = transition.getSource().getName();
        if (this.sourceToTargetMapping.get(source) == null) {
            this.sourceToTargetMapping.put(source, new HashSet());
        }
        this.sourceToTargetMapping.get(source).add(transition.getDestination().getName());
    }

    public Map<String, Set<String>> getSourceToTargetMapping() {
        return this.sourceToTargetMapping;
    }

    public boolean isReachable(String srcActivityId, String dstActivityId) {
        return this.isReachable(srcActivityId, dstActivityId, new HashSet<String>());
    }

    protected boolean isReachable(String srcActivityId, String dstActivityId, Set<String> alreadyVisited) {
        if (srcActivityId.equals(dstActivityId)) {
            return true;
        }
        alreadyVisited.add(srcActivityId);
        Set<String> directReachable = this.sourceToTargetMapping.get(srcActivityId);
        if (directReachable != null) {
            for (String destinationId : this.sourceToTargetMapping.get(srcActivityId)) {
                if (alreadyVisited.contains(destinationId) || !this.isReachable(destinationId, dstActivityId, alreadyVisited)) continue;
                return true;
            }
        }
        return false;
    }
}

