/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.model.Activity;
import org.jbpm.api.model.Transition;
import org.jbpm.jpdl.internal.activity.JpdlActivity;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.Condition;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;

public class ForkActivity
extends JpdlActivity {
    private static final long serialVersionUID = 1L;

    public void execute(ActivityExecution execution) {
        this.execute((ExecutionImpl)execution);
    }

    public void execute(ExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        ArrayList<Transition> forkingTransitions = new ArrayList<Transition>();
        for (Transition transition : activity.getOutgoingTransitions()) {
            Condition condition = ((TransitionImpl)transition).getCondition();
            if (condition != null && !condition.evaluate(execution)) continue;
            forkingTransitions.add(transition);
        }
        block0 : switch (forkingTransitions.size()) {
            case 0: {
                execution.end();
                break;
            }
            case 1: {
                execution.take((Transition)forkingTransitions.get(0));
                break;
            }
            default: {
                ExecutionImpl concurrentRoot;
                if ("active-root".equals(execution.getState())) {
                    concurrentRoot = execution;
                    execution.setState("inactive-concurrent-root");
                    execution.setActivity(null);
                } else if ("active-concurrent".equals(execution.getState())) {
                    concurrentRoot = execution.getParent();
                    execution.end();
                } else {
                    throw new AssertionError((Object)execution.getState());
                }
                HashMap<Transition, ExecutionImpl> hashMap = new HashMap<Transition, ExecutionImpl>();
                for (Transition transition : forkingTransitions) {
                    ExecutionImpl concurrentExecution = concurrentRoot.createExecution(transition.getName());
                    concurrentExecution.setActivity((Activity)activity);
                    concurrentExecution.setState("active-concurrent");
                    hashMap.put(transition, concurrentExecution);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    ((ExecutionImpl)entry.getValue()).take((Transition)entry.getKey());
                    if (!concurrentRoot.isEnded()) continue;
                    break block0;
                }
            }
        }
    }
}

