/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.env;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.Context;
import org.jbpm.pvm.internal.env.EnvironmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicEnvironment
extends EnvironmentImpl {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog(BasicEnvironment.class.getName());
    protected String authenticatedUserId;
    protected Map<String, Context> contexts = new LinkedHashMap<String, Context>();
    protected Throwable exception;
    protected transient ClassLoader classLoader;

    @Override
    public Context getContext(String contextName) {
        return this.contexts.get(contextName);
    }

    @Override
    public void setContext(Context context) {
        this.contexts.put(context.getName(), context);
    }

    @Override
    public Context removeContext(Context context) {
        return this.removeContext(context.getName());
    }

    @Override
    public Context removeContext(String contextName) {
        return this.contexts.remove(contextName);
    }

    public Context getEnvironmentFactoryContext() {
        return this.getContext("process-engine");
    }

    public Context getEnvironmentContext() {
        return this.getContext("transaction");
    }

    @Override
    public String getAuthenticatedUserId() {
        return this.authenticatedUserId;
    }

    @Override
    public void setAuthenticatedUserId(String authenticatedUserId) {
        this.authenticatedUserId = authenticatedUserId;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Object get(String name) {
        return this.get(name, null);
    }

    @Override
    public Object get(String name, String[] searchOrder) {
        return this.get(name, searchOrder, true);
    }

    @Override
    public Object get(String name, boolean nullIfNotFound) {
        return this.get(name, null, nullIfNotFound);
    }

    @Override
    public Object get(String name, String[] searchOrder, boolean nullIfNotFound) {
        if (searchOrder == null) {
            searchOrder = this.getDefaultSearchOrder();
        }
        for (String contextName : searchOrder) {
            Context context = this.contexts.get(contextName);
            if (!context.has(name)) continue;
            return context.get(name);
        }
        if (nullIfNotFound) {
            return null;
        }
        throw new JbpmException("Null value found for " + name + " but null is not allowed");
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.get(type, (String[])null);
    }

    @Override
    public <T> T get(Class<T> type, String[] searchOrder) {
        if (searchOrder == null) {
            searchOrder = this.getDefaultSearchOrder();
        }
        for (String contextName : searchOrder) {
            Context context = this.contexts.get(contextName);
            T object = context.get(type);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public <T> T get(Class<T> type, Context requester) {
        int i;
        String[] searchOrder = this.getDefaultSearchOrder();
        int searchPosition = 0;
        for (i = 0; i < searchOrder.length; ++i) {
            if (this.contexts.get(searchOrder[i]) != requester) continue;
            searchPosition = i + 1;
            break;
        }
        for (i = searchPosition; i < searchOrder.length; ++i) {
            Context context = this.contexts.get(searchOrder[i]);
            T object = context.get(type);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public void close() {
        log.trace("closing " + this);
        EnvironmentImpl popped = EnvironmentImpl.popEnvironment();
        if (this != popped) {
            throw new JbpmException("environment nesting problem");
        }
    }

    protected String[] getDefaultSearchOrder() {
        int size = this.contexts.size();
        String[] defaultSearchOrder = new String[size];
        int index = size;
        for (String contextName : this.contexts.keySet()) {
            defaultSearchOrder[--index] = contextName;
        }
        return defaultSearchOrder;
    }
}

