/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.history.events;

import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessInstance;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.model.HistoryProcessInstanceImpl;
import org.jbpm.pvm.internal.history.model.HistoryProcessInstanceMigrationImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.session.DbSession;

public class ProcessInstanceMigration
extends HistoryEvent {
    private static final long serialVersionUID = 1L;
    ProcessInstance processInstance;
    ProcessDefinition processDefinition;

    public ProcessInstanceMigration(ProcessInstance processInstance, ProcessDefinition processDefinition) {
        this.processInstance = processInstance;
        this.processDefinition = processDefinition;
    }

    public void process() {
        if (this.processDefinition == null || this.processInstance == null || !(this.processInstance instanceof ExecutionImpl)) {
            return;
        }
        DbSession dbSession = EnvironmentImpl.getFromCurrent(DbSession.class);
        HistoryProcessInstanceImpl historyProcessInstance = null;
        long processInstanceDbid = ((ExecutionImpl)this.processInstance).getDbid();
        historyProcessInstance = dbSession.get(HistoryProcessInstanceImpl.class, processInstanceDbid);
        if (historyProcessInstance == null) {
            return;
        }
        String oldVersion = historyProcessInstance.getProcessDefinitionId();
        String newVersion = this.processDefinition.getId();
        historyProcessInstance.setProcessDefinitionId(newVersion);
        HistoryProcessInstanceMigrationImpl historyProcessInstanceMigration = new HistoryProcessInstanceMigrationImpl(oldVersion, newVersion);
        historyProcessInstance.addDetail(historyProcessInstanceMigration);
        dbSession.save(historyProcessInstanceMigration);
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }
}

