/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.history.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.pvm.internal.history.model.HistoryActivityInstanceImpl;
import org.jbpm.pvm.internal.history.model.HistoryDetailImpl;
import org.jbpm.pvm.internal.history.model.HistoryVariableImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryProcessInstanceImpl
implements HistoryProcessInstance,
Serializable {
    private static final long serialVersionUID = 1L;
    protected long dbid;
    protected int dbversion;
    protected ProcessDefinitionImpl processDefinition;
    protected String processDefinitionId;
    protected String processInstanceId;
    protected String key;
    protected String state;
    protected String endActivityName;
    protected Date startTime;
    protected Date endTime;
    protected Long duration;
    protected int nextDetailIndex = 1;
    protected Set<HistoryActivityInstanceImpl> historyActivityInstances;
    protected Set<HistoryVariableImpl> historyVariables;
    protected Set<HistoryDetailImpl> details = new HashSet<HistoryDetailImpl>();

    public void addDetail(HistoryDetailImpl detail) {
        detail.setHistoryProcessInstance(this, this.nextDetailIndex);
        ++this.nextDetailIndex;
    }

    public HistoryProcessInstanceImpl() {
    }

    public HistoryProcessInstanceImpl(ExecutionImpl processInstance) {
        this.dbid = processInstance.getDbid();
        this.processDefinition = processInstance.getProcessDefinition();
        this.processDefinitionId = this.processDefinition.getId();
        this.processInstanceId = processInstance.getId();
        this.key = processInstance.getKey();
        this.state = "active";
        this.startTime = Clock.getTime();
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        this.duration = endTime.getTime() - this.startTime.getTime();
        this.state = "ended";
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    public long getDbid() {
        return this.dbid;
    }

    public ProcessDefinitionImpl getProcessDefinition() {
        return this.processDefinition;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public Long getDuration() {
        return this.duration;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getEndActivityName() {
        return this.endActivityName;
    }

    public void setEndActivityName(String endActivityName) {
        this.endActivityName = endActivityName;
    }

    public Set<HistoryVariableImpl> getHistoryVariables() {
        return this.historyVariables;
    }
}

