/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.job;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.job.Job;
import org.jbpm.pvm.internal.lob.Lob;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.wire.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JobImpl
implements Command<Boolean>,
Serializable,
Job {
    private static final long serialVersionUID = 1L;
    public static final String STATE_WAITING = "waiting";
    public static final String STATE_ACQUIRED = "acquired";
    public static final String STATE_ERROR = "error";
    public static final String STATE_SUSPENDED = "suspended";
    protected long dbid;
    protected int dbversion;
    protected Date dueDate;
    protected String state = "waiting";
    protected ExecutionImpl execution;
    protected ExecutionImpl processInstance;
    protected boolean isExclusive;
    protected String lockOwner;
    protected Date lockExpirationTime;
    protected String exception;
    protected int retries = 3;
    protected Lob configurationBytes;
    protected Object configuration;
    protected Descriptor commandDescriptor;

    public void setExecution(ExecutionImpl execution) {
        this.execution = execution;
        this.processInstance = execution.getProcessInstance();
    }

    public void acquire(String lockOwner, Date lockExpirationTime) {
        this.state = STATE_ACQUIRED;
        this.lockOwner = lockOwner;
        this.lockExpirationTime = lockExpirationTime;
    }

    public void release() {
        this.state = STATE_WAITING;
        this.lockOwner = null;
        this.lockExpirationTime = null;
    }

    public void setRetries(int retries) {
        this.retries = retries;
        if (this.retries == 0) {
            this.state = STATE_ERROR;
        }
    }

    public void suspend() {
        this.state = STATE_SUSPENDED;
    }

    public void resume() {
        this.state = this.retries == 0 ? STATE_ERROR : STATE_WAITING;
    }

    public Object getConfiguration() {
        if (this.configuration == null && this.configurationBytes != null) {
            try {
                byte[] bytes = this.configurationBytes.extractBytes();
                ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
                ObjectInputStream objectStream = new ObjectInputStream(byteStream);
                this.configuration = objectStream.readObject();
            }
            catch (Exception e) {
                throw new JbpmException("couldn't deserialize configuration object for " + this, e);
            }
        }
        return this.configuration;
    }

    public void setConfiguration(Object configuration) {
        this.configuration = configuration;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(configuration);
            byte[] bytes = byteStream.toByteArray();
            this.configurationBytes = new Lob(bytes, true);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't serialize configuration object for " + this, e);
        }
    }

    @Override
    public String getId() {
        return Long.toString(this.dbid);
    }

    public long getDbid() {
        return this.dbid;
    }

    public void setDbid(long id) {
        this.dbid = id;
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Override
    @Deprecated
    public Date getDuedate() {
        return this.getDueDate();
    }

    @Deprecated
    public void setDuedate(Date duedate) {
        this.setDueDate(duedate);
    }

    @Override
    public String getException() {
        return this.exception;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public boolean isExclusive() {
        return this.isExclusive;
    }

    @Override
    public ExecutionImpl getExecution() {
        return this.execution;
    }

    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    public void setLockOwner(String jobExecutorName) {
        this.lockOwner = jobExecutorName;
    }

    @Override
    public ExecutionImpl getProcessInstance() {
        return this.processInstance;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    @Override
    public Date getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    public void setLockExpirationTime(Date lockExpirationTime) {
        this.lockExpirationTime = lockExpirationTime;
    }

    public Descriptor getCommandDescriptor() {
        return this.commandDescriptor;
    }

    public void setCommandDescriptor(Descriptor commandDescriptor) {
        this.commandDescriptor = commandDescriptor;
    }
}

