/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.jobexecutor.JobAddedNotification;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.tx.Transaction;

public class JobAdditionNotifier {
    private static final Log log = Log.getLog(JobAdditionNotifier.class.getName());
    Transaction transaction;
    JobExecutor jobExecutor;
    private boolean notificationRegistered;

    public void registerNotification() {
        if (this.jobExecutor == null) {
            log.debug("cannot find jobExecutor");
            return;
        }
        if (this.transaction == null) {
            log.debug("cannot find transaction");
            return;
        }
        if (this.notificationRegistered) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("registering job addition notifier with " + this.transaction);
        }
        this.transaction.registerSynchronization(new JobAddedNotification(this.jobExecutor));
        this.notificationRegistered = true;
    }
}

