/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.util;

import org.jbpm.api.JbpmException;

public abstract class Priority {
    public static final int HIGHEST = 2;
    public static final int HIGH = 1;
    public static final int NORMAL = 0;
    public static final int LOW = -1;
    public static final int LOWEST = -2;
    public static final String TEXT_HIGHEST = "highest";
    public static final String TEXT_HIGH = "high";
    public static final String TEXT_NORMAL = "normal";
    public static final String TEXT_LOW = "low";
    public static final String TEXT_LOWEST = "lowest";

    public static String toString(int priority) {
        if (priority == 3) {
            return TEXT_NORMAL;
        }
        if (priority == 2) {
            return TEXT_HIGH;
        }
        if (priority == 1) {
            return TEXT_HIGHEST;
        }
        if (priority == 4) {
            return TEXT_LOW;
        }
        if (priority == 5) {
            return TEXT_LOWEST;
        }
        return Integer.toString(priority);
    }

    public static int parsePriority(String priorityText) {
        if (TEXT_NORMAL.equalsIgnoreCase(priorityText)) {
            return 0;
        }
        if (TEXT_HIGH.equalsIgnoreCase(priorityText)) {
            return 1;
        }
        if (TEXT_HIGHEST.equalsIgnoreCase(priorityText)) {
            return 2;
        }
        if (TEXT_LOW.equalsIgnoreCase(priorityText)) {
            return -1;
        }
        if (TEXT_LOWEST.equalsIgnoreCase(priorityText)) {
            return -2;
        }
        try {
            return Integer.parseInt(priorityText);
        }
        catch (NumberFormatException e) {
            throw new JbpmException("priority '" + priorityText + "' could not be parsed as a priority", e);
        }
    }
}

