/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import org.jbpm.pvm.internal.wire.binding.BasicTypeBinding;
import org.jbpm.pvm.internal.wire.descriptor.AbstractDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.FloatDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

public class FloatBinding
extends BasicTypeBinding {
    public FloatBinding() {
        super("float");
    }

    protected AbstractDescriptor createDescriptor(String value, Element element, Parse parse) {
        Float floatValue;
        FloatDescriptor floatDescriptor = new FloatDescriptor();
        try {
            floatValue = new Float(value);
        }
        catch (NumberFormatException e) {
            parse.addProblem(this.createValueExceptionMessage("'" + value + "' cannot be parsed to a float", element), element);
            return null;
        }
        floatDescriptor.setValue(floatValue);
        return floatDescriptor;
    }
}

