/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.naming.InitialContext;
import junit.framework.TestCase;
import org.jbpm.internal.log.Log;
import org.jbpm.test.JmsTopicListener;

public class JmsXATopicListener
implements JmsTopicListener {
    private static Log log = Log.getLog(JmsXATopicListener.class.getName());
    String topicJndiName = null;
    String connectionFactoryJndiName = null;
    Topic topic = null;
    XATopicConnectionFactory topicConnectionFactory = null;
    XATopicConnection topicConnection = null;
    XATopicSession topicSession = null;
    MessageConsumer messageConsumer = null;
    List<Message> messages = null;

    JmsXATopicListener(String connectionFactoryJndiName, String topicJndiName) {
        this.connectionFactoryJndiName = connectionFactoryJndiName;
        this.topicJndiName = topicJndiName;
        this.start();
    }

    void start() {
        try {
            this.messages = Collections.synchronizedList(new ArrayList());
            InitialContext context = new InitialContext();
            this.topicConnectionFactory = (XATopicConnectionFactory)context.lookup(this.connectionFactoryJndiName);
            this.topic = (Topic)context.lookup(this.topicJndiName);
            this.topicConnection = this.topicConnectionFactory.createXATopicConnection();
            this.topicSession = this.topicConnection.createXATopicSession();
            this.messageConsumer = this.topicSession.createConsumer((Destination)this.topic);
            this.messageConsumer.setMessageListener((MessageListener)new Listener());
            this.topicConnection.start();
        }
        catch (Exception e) {
            this.stop();
            throw new RuntimeException("couldn't subscribe message listener to topic '" + this.topicJndiName + "': " + e.getMessage(), e);
        }
    }

    public void stop() {
        if (this.topicConnection != null) {
            try {
                this.topicConnection.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.messageConsumer != null) {
            try {
                this.messageConsumer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.messageConsumer = null;
        }
        if (this.topicSession != null) {
            try {
                this.topicSession.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.topicSession = null;
        }
        if (this.topicConnection != null) {
            try {
                this.topicConnection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.topicConnection = null;
        }
    }

    public Message getNextMessage(long timeout) {
        long start = System.currentTimeMillis();
        while (this.messages.isEmpty()) {
            if (System.currentTimeMillis() - start > timeout) {
                TestCase.fail((String)("no message for topic " + this.topicJndiName));
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                log.info("waiting for next message got interrupted");
                continue;
            }
            break;
        }
        return this.messages.remove(0);
    }

    private class Listener
    implements MessageListener {
        private Listener() {
        }

        public void onMessage(Message message) {
            JmsXATopicListener.this.messages.add(message);
        }
    }
}

