/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.parsing.ReaderContext;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cache.annotation.AnnotationCacheOperationSource;
import org.springframework.cache.config.CacheNamespaceHandler;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheInterceptor;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheUpdateOperation;
import org.springframework.cache.interceptor.NameMatchCacheOperationSource;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheAdviceParser
extends AbstractSingleBeanDefinitionParser {
    private static final String CACHEABLE_ELEMENT = "cacheable";
    private static final String CACHE_EVICT_ELEMENT = "cache-evict";
    private static final String METHOD_ATTRIBUTE = "method";
    private static final String DEFS_ELEMENT = "definitions";

    CacheAdviceParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return CacheInterceptor.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addPropertyReference("cacheManager", CacheNamespaceHandler.extractCacheManager(element));
        CacheNamespaceHandler.parseKeyGenerator(element, (BeanDefinition)builder.getBeanDefinition());
        List cacheDefs = DomUtils.getChildElementsByTagName((Element)element, (String)DEFS_ELEMENT);
        if (cacheDefs.size() >= 1) {
            List<RootBeanDefinition> attributeSourceDefinitions = this.parseDefinitionsSources(cacheDefs, parserContext);
            builder.addPropertyValue("cacheOperationSources", attributeSourceDefinitions);
        } else {
            builder.addPropertyValue("cacheOperationSources", (Object)new RootBeanDefinition(AnnotationCacheOperationSource.class));
        }
    }

    private List<RootBeanDefinition> parseDefinitionsSources(List<Element> definitions, ParserContext parserContext) {
        ManagedList defs = new ManagedList(definitions.size());
        for (Element element : definitions) {
            defs.add((Object)this.parseDefinitionSource(element, parserContext));
        }
        return defs;
    }

    private RootBeanDefinition parseDefinitionSource(Element definition, ParserContext parserContext) {
        Props prop = new Props(definition);
        ManagedMap cacheOpeMap = new ManagedMap();
        cacheOpeMap.setSource(parserContext.extractSource((Object)definition));
        List updateCacheMethods = DomUtils.getChildElementsByTagName((Element)definition, (String)CACHEABLE_ELEMENT);
        for (Element opElement : updateCacheMethods) {
            String name = opElement.getAttribute(METHOD_ATTRIBUTE);
            TypedStringValue nameHolder = new TypedStringValue(name);
            nameHolder.setSource(parserContext.extractSource((Object)opElement));
            CacheOperation op = prop.merge(opElement, (ReaderContext)parserContext.getReaderContext(), new CacheUpdateOperation());
            cacheOpeMap.put((Object)nameHolder, (Object)op);
        }
        List evictCacheMethods = DomUtils.getChildElementsByTagName((Element)definition, (String)CACHE_EVICT_ELEMENT);
        for (Element opElement : evictCacheMethods) {
            String name = opElement.getAttribute(METHOD_ATTRIBUTE);
            TypedStringValue nameHolder = new TypedStringValue(name);
            nameHolder.setSource(parserContext.extractSource((Object)opElement));
            CacheOperation op = prop.merge(opElement, (ReaderContext)parserContext.getReaderContext(), new CacheEvictOperation());
            cacheOpeMap.put((Object)nameHolder, (Object)op);
        }
        RootBeanDefinition attributeSourceDefinition = new RootBeanDefinition(NameMatchCacheOperationSource.class);
        attributeSourceDefinition.setSource(parserContext.extractSource((Object)definition));
        attributeSourceDefinition.getPropertyValues().add("nameMap", (Object)cacheOpeMap);
        return attributeSourceDefinition;
    }

    private static class Props {
        private String key;
        private String condition;
        private String[] caches = null;

        Props(Element root) {
            String defaultCache = root.getAttribute("cache");
            this.key = root.getAttribute("key");
            this.condition = root.getAttribute("condition");
            if (StringUtils.hasText((String)defaultCache)) {
                this.caches = StringUtils.commaDelimitedListToStringArray((String)defaultCache.trim());
            }
        }

        CacheOperation merge(Element element, ReaderContext readerCtx, CacheOperation op) {
            String cache = element.getAttribute("cache");
            String k = element.getAttribute("key");
            String c = element.getAttribute("condition");
            String[] localCaches = this.caches;
            String localKey = this.key;
            String localCondition = this.condition;
            if (StringUtils.hasText((String)cache)) {
                localCaches = StringUtils.commaDelimitedListToStringArray((String)cache.trim());
            } else if (this.caches == null) {
                readerCtx.error("No cache specified specified for " + element.getNodeName(), (Object)element);
            }
            if (StringUtils.hasText((String)k)) {
                localKey = k.trim();
            }
            if (StringUtils.hasText((String)c)) {
                localCondition = c.trim();
            }
            op.setCacheNames(localCaches);
            op.setKey(localKey);
            op.setCondition(localCondition);
            return op;
        }
    }
}

