/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import java.util.Map;
import org.springframework.aop.config.AopConfigUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.annotation.ImportSelectorContext;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.ProxyTransactionManagementConfiguration;
import org.springframework.util.Assert;

public class TransactionManagementConfigurationSelector
implements ImportSelector {
    public String[] selectImports(ImportSelectorContext context) {
        AnnotationMetadata importingClassMetadata = context.getImportingClassMetadata();
        BeanDefinitionRegistry registry = context.getBeanDefinitionRegistry();
        Map enableTx = importingClassMetadata.getAnnotationAttributes(EnableTransactionManagement.class.getName());
        Assert.notNull((Object)enableTx, (String)("@EnableTransactionManagement is not present on importing class " + importingClassMetadata.getClassName()));
        switch ((AdviceMode)enableTx.get("mode")) {
            case PROXY: {
                AopConfigUtils.registerAutoProxyCreatorIfNecessary((BeanDefinitionRegistry)registry);
                if (((Boolean)enableTx.get("proxyTargetClass")).booleanValue()) {
                    AopConfigUtils.forceAutoProxyCreatorToUseClassProxying((BeanDefinitionRegistry)registry);
                }
                return new String[]{ProxyTransactionManagementConfiguration.class.getName()};
            }
            case ASPECTJ: {
                return new String[]{"org.springframework.transaction.aspectj.AspectJTransactionManagementConfiguration"};
            }
        }
        throw new IllegalArgumentException("Unknown AdviceMode " + enableTx.get("mode"));
    }
}

