/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.Config;
import com.google.zxing.client.j2se.Inputs;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Hashtable;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DecodeThread
extends Thread {
    private int successful;
    private final Config config;
    private final Inputs inputs;

    DecodeThread(Config config, Inputs inputs) {
        this.config = config;
        this.inputs = inputs;
    }

    @Override
    public void run() {
        String input;
        while ((input = this.inputs.getNextInput()) != null) {
            Result result;
            File inputFile = new File(input);
            if (inputFile.exists()) {
                try {
                    if (this.config.isMulti()) {
                        Result[] results = this.decodeMulti(inputFile.toURI(), this.config.getHints());
                        if (results == null) continue;
                        ++this.successful;
                        if (!this.config.isDumpResults()) continue;
                        DecodeThread.dumpResultMulti(inputFile, results);
                        continue;
                    }
                    result = this.decode(inputFile.toURI(), this.config.getHints());
                    if (result == null) continue;
                    ++this.successful;
                    if (!this.config.isDumpResults()) continue;
                    DecodeThread.dumpResult(inputFile, result);
                }
                catch (IOException result2) {}
                continue;
            }
            try {
                result = this.decode(new URI(input), this.config.getHints());
                if (result == null) continue;
                ++this.successful;
            }
            catch (Exception exception) {}
        }
    }

    public int getSuccessful() {
        return this.successful;
    }

    private static void dumpResult(File input, Result result) throws IOException {
        String name = input.getAbsolutePath();
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        File dump = new File(String.valueOf(name) + ".txt");
        DecodeThread.writeStringToFile(result.getText(), dump);
    }

    private static void dumpResultMulti(File input, Result[] results) throws IOException {
        String name = input.getAbsolutePath();
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        File dump = new File(String.valueOf(name) + ".txt");
        DecodeThread.writeResultsToFile(results, dump);
    }

    private static void writeStringToFile(String value, File file) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF8"));
        try {
            out.write(value);
        }
        finally {
            ((Writer)out).close();
        }
    }

    private static void writeResultsToFile(Result[] results, File file) throws IOException {
        String newline = System.getProperty("line.separator");
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF8"));
        try {
            Result[] resultArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Result result = resultArray[n2];
                out.write(result.getText());
                out.write(newline);
                ++n2;
            }
        }
        finally {
            ((Writer)out).close();
        }
    }

    private Result decode(URI uri, Hashtable<DecodeHintType, Object> hints) throws IOException {
        BufferedImage image;
        try {
            image = ImageIO.read(uri.toURL());
        }
        catch (IllegalArgumentException iae) {
            throw new FileNotFoundException("Resource not found: " + uri);
        }
        if (image == null) {
            System.err.println(String.valueOf(uri.toString()) + ": Could not load image");
            return null;
        }
        try {
            BufferedImageLuminanceSource source;
            if (this.config.getCrop() == null) {
                source = new BufferedImageLuminanceSource(image);
            } else {
                int[] crop = this.config.getCrop();
                source = new BufferedImageLuminanceSource(image, crop[0], crop[1], crop[2], crop[3]);
            }
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            if (this.config.isDumpBlackPoint()) {
                DecodeThread.dumpBlackPoint(uri, image, bitmap);
            }
            Result result = new MultiFormatReader().decode(bitmap, hints);
            if (this.config.isBrief()) {
                System.out.println(String.valueOf(uri.toString()) + ": Success");
            } else {
                ParsedResult parsedResult = ResultParser.parseResult((Result)result);
                System.out.println(String.valueOf(uri.toString()) + " (format: " + result.getBarcodeFormat() + ", type: " + parsedResult.getType() + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                System.out.println("Found " + result.getResultPoints().length + " result points.");
                int i = 0;
                while (i < result.getResultPoints().length) {
                    ResultPoint rp = result.getResultPoints()[i];
                    System.out.println("  Point " + i + ": (" + rp.getX() + ',' + rp.getY() + ')');
                    ++i;
                }
            }
            return result;
        }
        catch (NotFoundException nfe) {
            System.out.println(String.valueOf(uri.toString()) + ": No barcode found");
            return null;
        }
    }

    private Result[] decodeMulti(URI uri, Hashtable<DecodeHintType, Object> hints) throws IOException {
        BufferedImage image;
        try {
            image = ImageIO.read(uri.toURL());
        }
        catch (IllegalArgumentException iae) {
            throw new FileNotFoundException("Resource not found: " + uri);
        }
        if (image == null) {
            System.err.println(String.valueOf(uri.toString()) + ": Could not load image");
            return null;
        }
        try {
            BufferedImageLuminanceSource source;
            if (this.config.getCrop() == null) {
                source = new BufferedImageLuminanceSource(image);
            } else {
                int[] crop = this.config.getCrop();
                source = new BufferedImageLuminanceSource(image, crop[0], crop[1], crop[2], crop[3]);
            }
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            if (this.config.isDumpBlackPoint()) {
                DecodeThread.dumpBlackPoint(uri, image, bitmap);
            }
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            GenericMultipleBarcodeReader reader = new GenericMultipleBarcodeReader((Reader)multiFormatReader);
            Result[] results = reader.decodeMultiple(bitmap, hints);
            if (this.config.isBrief()) {
                System.out.println(String.valueOf(uri.toString()) + ": Success");
            } else {
                Result[] resultArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    Result result = resultArray[n2];
                    ParsedResult parsedResult = ResultParser.parseResult((Result)result);
                    System.out.println(String.valueOf(uri.toString()) + " (format: " + result.getBarcodeFormat() + ", type: " + parsedResult.getType() + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                    System.out.println("Found " + result.getResultPoints().length + " result points.");
                    int i = 0;
                    while (i < result.getResultPoints().length) {
                        ResultPoint rp = result.getResultPoints()[i];
                        System.out.println("  Point " + i + ": (" + rp.getX() + ',' + rp.getY() + ')');
                        ++i;
                    }
                    ++n2;
                }
            }
            return results;
        }
        catch (NotFoundException nfe) {
            System.out.println(String.valueOf(uri.toString()) + ": No barcode found");
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void dumpBlackPoint(URI uri, BufferedImage image, BinaryBitmap bitmap) {
        inputName = uri.getPath();
        if (inputName.contains(".mono.png")) {
            return;
        }
        width = bitmap.getWidth();
        height = bitmap.getHeight();
        stride = width * 3;
        pixels = new int[stride * height];
        argb = new int[width];
        y = 0;
        while (y < height) {
            image.getRGB(0, y, width, 1, argb, 0, width);
            System.arraycopy(argb, 0, pixels, y * stride, width);
            ++y;
        }
        row = new BitArray(width);
        y = 0;
        while (y < height) {
            block12: {
                block11: {
                    try {
                        row = bitmap.getBlackRow(y, row);
                        break block11;
                    }
                    catch (NotFoundException nfe) {
                        offset = y * stride + width;
                        x = 0;
                        ** while (x < width)
                    }
lbl-1000:
                    // 1 sources

                    {
                        pixels[offset + x] = -65536;
                        ++x;
                        continue;
lbl29:
                        // 1 sources

                        break block12;
                    }
                }
                offset = y * stride + width;
                x = 0;
                while (x < width) {
                    pixels[offset + x] = row.get(x) != false ? -16777216 : -1;
                    ++x;
                }
            }
            ++y;
        }
        try {
            y = 0;
            while (y < height) {
                matrix = bitmap.getBlackMatrix();
                offset = y * stride + width * 2;
                x = 0;
                while (x < width) {
                    pixels[offset + x] = matrix.get(x, y) != false ? -16777216 : -1;
                    ++x;
                }
                ++y;
            }
        }
        catch (NotFoundException var10_12) {
            // empty catch block
        }
        DecodeThread.writeResultImage(stride, height, pixels, uri, inputName, ".mono.png");
    }

    private static void writeResultImage(int stride, int height, int[] pixels, URI uri, String inputName, String suffix) {
        int pos;
        BufferedImage result = new BufferedImage(stride, height, 2);
        result.setRGB(0, 0, stride, height, pixels, 0, stride);
        String resultName = inputName;
        if ("http".equals(uri.getScheme()) && (pos = resultName.lastIndexOf(47)) > 0) {
            resultName = String.valueOf('.') + resultName.substring(pos);
        }
        if ((pos = resultName.lastIndexOf(46)) > 0) {
            resultName = resultName.substring(0, pos);
        }
        resultName = String.valueOf(resultName) + suffix;
        FileOutputStream outStream = null;
        try {
            try {
                outStream = new FileOutputStream(resultName);
                ImageIO.write((RenderedImage)result, "png", outStream);
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not create " + resultName);
                try {
                    if (outStream != null) {
                        ((OutputStream)outStream).close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                System.err.println("Could not write to " + resultName);
                try {
                    if (outStream != null) {
                        ((OutputStream)outStream).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (outStream != null) {
                    ((OutputStream)outStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

