/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.result.ResultExternal;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.ResultTempTable;
import org.h2.result.SortOrder;
import org.h2.util.New;
import org.h2.util.ValueHashMap;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class LocalResult
implements ResultInterface,
ResultTarget {
    private int maxMemoryRows;
    private Session session;
    private int visibleColumnCount;
    private Expression[] expressions;
    private int rowId;
    private int rowCount;
    private ArrayList<Value[]> rows;
    private SortOrder sort;
    private ValueHashMap<Value[]> distinctRows;
    private Value[] currentRow;
    private int offset;
    private int limit = -1;
    private ResultExternal external;
    private int diskOffset;
    private boolean distinct;
    private boolean randomAccess;
    private boolean closed;
    private boolean containsLobs;

    public LocalResult() {
    }

    public LocalResult(Session session, Expression[] expressionArray, int n) {
        Database database;
        this.session = session;
        this.maxMemoryRows = session == null ? Integer.MAX_VALUE : ((database = session.getDatabase()).isPersistent() && !database.isReadOnly() ? session.getDatabase().getMaxMemoryRows() : Integer.MAX_VALUE);
        this.rows = New.arrayList();
        this.visibleColumnCount = n;
        this.rowId = -1;
        this.expressions = expressionArray;
    }

    public void setMaxMemoryRows(int n) {
        this.maxMemoryRows = n;
    }

    public static LocalResult read(Session session, ResultSet resultSet, int n) {
        Expression[] expressionArray = Expression.getExpressionColumns(session, resultSet);
        int n2 = expressionArray.length;
        LocalResult localResult = new LocalResult(session, expressionArray, n2);
        try {
            for (int i = 0; (n == 0 || i < n) && resultSet.next(); ++i) {
                Value[] valueArray = new Value[n2];
                for (int j = 0; j < n2; ++j) {
                    int n3 = localResult.getColumnType(j);
                    valueArray[j] = DataType.readValue(session, resultSet, j + 1, n3);
                }
                localResult.addRow(valueArray);
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        localResult.done();
        return localResult;
    }

    public LocalResult createShallowCopy(Session session) {
        if (this.external == null && (this.rows == null || this.rows.size() < this.rowCount)) {
            return null;
        }
        if (this.containsLobs) {
            return null;
        }
        ResultExternal resultExternal = null;
        if (this.external != null && (resultExternal = this.external.createShallowCopy()) == null) {
            return null;
        }
        LocalResult localResult = new LocalResult();
        localResult.maxMemoryRows = this.maxMemoryRows;
        localResult.session = session;
        localResult.visibleColumnCount = this.visibleColumnCount;
        localResult.expressions = this.expressions;
        localResult.rowId = -1;
        localResult.rowCount = this.rowCount;
        localResult.rows = this.rows;
        localResult.sort = this.sort;
        localResult.distinctRows = this.distinctRows;
        localResult.distinct = this.distinct;
        localResult.randomAccess = this.randomAccess;
        localResult.currentRow = null;
        localResult.offset = 0;
        localResult.limit = -1;
        localResult.external = resultExternal;
        localResult.diskOffset = this.diskOffset;
        return localResult;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sort = sortOrder;
    }

    public void setDistinct() {
        this.distinct = true;
        this.distinctRows = ValueHashMap.newInstance();
    }

    public void setRandomAccess() {
        this.randomAccess = true;
    }

    public void removeDistinct(Value[] valueArray) {
        if (!this.distinct) {
            DbException.throwInternalError();
        }
        if (this.distinctRows != null) {
            ValueArray valueArray2 = ValueArray.get(valueArray);
            this.distinctRows.remove(valueArray2);
            this.rowCount = this.distinctRows.size();
        } else {
            this.rowCount = this.external.removeRow(valueArray);
        }
    }

    public boolean containsDistinct(Value[] valueArray) {
        Object object;
        if (this.external != null) {
            return this.external.contains(valueArray);
        }
        if (this.distinctRows == null) {
            this.distinctRows = ValueHashMap.newInstance();
            object = this.rows.iterator();
            while (object.hasNext()) {
                Value[] valueArray2 = (Value[])object.next();
                ValueArray valueArray3 = this.getArrayOfVisible(valueArray2);
                this.distinctRows.put(valueArray3, valueArray3.getList());
            }
        }
        return this.distinctRows.get((Value)(object = ValueArray.get(valueArray))) != null;
    }

    @Override
    public void reset() {
        this.rowId = -1;
        if (this.external != null) {
            this.external.reset();
            if (this.diskOffset > 0) {
                for (int i = 0; i < this.diskOffset; ++i) {
                    this.external.next();
                }
            }
        }
    }

    @Override
    public Value[] currentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (!this.closed && this.rowId < this.rowCount) {
            ++this.rowId;
            if (this.rowId < this.rowCount) {
                this.currentRow = this.external != null ? this.external.next() : this.rows.get(this.rowId);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    @Override
    public int getRowId() {
        return this.rowId;
    }

    private void cloneLobs(Value[] valueArray) {
        for (int i = 0; i < valueArray.length; ++i) {
            Value value = valueArray[i];
            Value value2 = value.copyToResult();
            if (value2 == value) continue;
            this.containsLobs = true;
            this.session.addTemporaryLob(value2);
            valueArray[i] = value2;
        }
    }

    private ValueArray getArrayOfVisible(Value[] valueArray) {
        if (valueArray.length > this.visibleColumnCount) {
            Value[] valueArray2 = new Value[this.visibleColumnCount];
            System.arraycopy(valueArray, 0, valueArray2, 0, this.visibleColumnCount);
            valueArray = valueArray2;
        }
        return ValueArray.get(valueArray);
    }

    @Override
    public void addRow(Value[] valueArray) {
        this.cloneLobs(valueArray);
        if (this.distinct) {
            if (this.distinctRows != null) {
                ValueArray valueArray2 = this.getArrayOfVisible(valueArray);
                this.distinctRows.put(valueArray2, valueArray);
                this.rowCount = this.distinctRows.size();
                if (this.rowCount > this.maxMemoryRows) {
                    this.external = new ResultTempTable(this.session, this.expressions, true, this.sort);
                    this.rowCount = this.external.addRows(this.distinctRows.values());
                    this.distinctRows = null;
                }
            } else {
                this.rowCount = this.external.addRow(valueArray);
            }
            return;
        }
        this.rows.add(valueArray);
        ++this.rowCount;
        if (this.rows.size() > this.maxMemoryRows) {
            if (this.external == null) {
                this.external = new ResultTempTable(this.session, this.expressions, false, this.sort);
            }
            this.addRowsToDisk();
        }
    }

    private void addRowsToDisk() {
        this.rowCount = this.external.addRows(this.rows);
        this.rows.clear();
    }

    @Override
    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public void done() {
        if (this.distinct) {
            if (this.distinctRows != null) {
                this.rows = this.distinctRows.values();
            } else if (this.external != null && this.sort != null) {
                Value[] valueArray;
                ResultExternal resultExternal = this.external;
                this.external = null;
                resultExternal.reset();
                this.rows = New.arrayList();
                while ((valueArray = resultExternal.next()) != null) {
                    if (this.external == null) {
                        this.external = new ResultTempTable(this.session, this.expressions, true, this.sort);
                    }
                    this.rows.add(valueArray);
                    if (this.rows.size() <= this.maxMemoryRows) continue;
                    this.rowCount = this.external.addRows(this.rows);
                    this.rows.clear();
                }
                resultExternal.close();
            }
        }
        if (this.external != null) {
            this.addRowsToDisk();
            this.external.done();
        } else if (this.sort != null) {
            if (this.offset > 0 || this.limit > 0) {
                this.sort.sort(this.rows, this.offset, this.limit < 0 ? this.rows.size() : this.limit);
            } else {
                this.sort.sort(this.rows);
            }
        }
        this.applyOffset();
        this.applyLimit();
        this.reset();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    private void applyLimit() {
        if (this.limit < 0) {
            return;
        }
        if (this.external == null) {
            if (this.rows.size() > this.limit) {
                this.rows = New.arrayList(this.rows.subList(0, this.limit));
                this.rowCount = this.limit;
            }
        } else if (this.limit < this.rowCount) {
            this.rowCount = this.limit;
        }
    }

    @Override
    public boolean needToClose() {
        return this.external != null;
    }

    @Override
    public void close() {
        if (this.external != null) {
            this.external.close();
            this.external = null;
            this.closed = true;
        }
    }

    @Override
    public String getAlias(int n) {
        return this.expressions[n].getAlias();
    }

    @Override
    public String getTableName(int n) {
        return this.expressions[n].getTableName();
    }

    @Override
    public String getSchemaName(int n) {
        return this.expressions[n].getSchemaName();
    }

    @Override
    public int getDisplaySize(int n) {
        return this.expressions[n].getDisplaySize();
    }

    @Override
    public String getColumnName(int n) {
        return this.expressions[n].getColumnName();
    }

    @Override
    public int getColumnType(int n) {
        return this.expressions[n].getType();
    }

    @Override
    public long getColumnPrecision(int n) {
        return this.expressions[n].getPrecision();
    }

    @Override
    public int getNullable(int n) {
        return this.expressions[n].getNullable();
    }

    @Override
    public boolean isAutoIncrement(int n) {
        return this.expressions[n].isAutoIncrement();
    }

    @Override
    public int getColumnScale(int n) {
        return this.expressions[n].getScale();
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    private void applyOffset() {
        if (this.offset <= 0) {
            return;
        }
        if (this.external == null) {
            if (this.offset >= this.rows.size()) {
                this.rows.clear();
                this.rowCount = 0;
            } else {
                int n = Math.min(this.offset, this.rows.size());
                this.rows = New.arrayList(this.rows.subList(n, this.rows.size()));
                this.rowCount -= n;
            }
        } else if (this.offset >= this.rowCount) {
            this.rowCount = 0;
        } else {
            this.diskOffset = this.offset;
            this.rowCount -= this.offset;
        }
    }

    public String toString() {
        return super.toString() + " columns: " + this.visibleColumnCount + " rows: " + this.rowCount + " pos: " + this.rowId;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public void setFetchSize(int n) {
    }
}

