/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd.processor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.cmd.Command;
import org.openas2.cmd.CommandResult;
import org.openas2.cmd.processor.BaseCommandProcessor;
import org.openas2.cmd.processor.SocketCommandParser;
import org.openas2.util.CommandTokenizer;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketCommandProcessor
extends BaseCommandProcessor
implements Runnable {
    private BufferedReader rdr = null;
    private BufferedWriter wrtr = null;
    private SSLServerSocket sslserversocket = null;
    private String userid;
    private String password;
    SocketCommandParser parser;

    @Override
    public void deInit() throws OpenAS2Exception {
    }

    @Override
    public void init() throws OpenAS2Exception {
    }

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        String p = parameters.get("portid");
        try {
            int port = Integer.parseInt(p);
            SSLServerSocketFactory sslserversocketfactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            this.sslserversocket = (SSLServerSocket)sslserversocketfactory.createServerSocket(port);
            String cipherSuites = System.getProperty("CmdProcessorSocketCipher", "TLS_DH_anon_WITH_AES_256_CBC_SHA");
            String[] enabledCipherSuites = new String[]{cipherSuites};
            try {
                this.sslserversocket.setEnabledCipherSuites(enabledCipherSuites);
            }
            catch (IllegalArgumentException e) {
                throw new OpenAS2Exception("Cipher is not supported. Use command line switch -DCmdProcessorSocketCipher=<some cipher suite> to use one supported by your version of java security.", e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OpenAS2Exception(e);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new OpenAS2Exception("error converting portid parameter " + e);
        }
        this.userid = parameters.get("userid");
        if (this.userid == null || this.userid.length() < 1) {
            throw new OpenAS2Exception("missing userid parameter");
        }
        this.password = parameters.get("password");
        if (this.password == null || this.password.length() < 1) {
            throw new OpenAS2Exception("missing password parameter");
        }
        try {
            this.parser = new SocketCommandParser();
        }
        catch (Exception e) {
            new OpenAS2Exception(e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processCommand() throws OpenAS2Exception {
        SSLSocket socket = null;
        try {
            try {
                CommandTokenizer cmdTkn;
                socket = (SSLSocket)this.sslserversocket.accept();
                socket.setSoTimeout(20000);
                this.rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.wrtr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                String line = this.rdr.readLine();
                this.parser.parse(line);
                if (!this.parser.getUserid().equals(this.userid)) {
                    this.wrtr.write("Bad userid/password");
                    throw new OpenAS2Exception("Bad userid");
                }
                if (!this.parser.getPassword().equals(this.password)) {
                    this.wrtr.write("Bad userid/password");
                    throw new OpenAS2Exception("Bad password");
                }
                String str = this.parser.getCommandText();
                if (str != null && str.length() > 0 && (cmdTkn = new CommandTokenizer(str)).hasMoreTokens()) {
                    String commandName = cmdTkn.nextToken().toLowerCase();
                    if (commandName.equals("exit")) {
                        this.terminate();
                    } else {
                        ArrayList<String> params = new ArrayList<String>();
                        while (cmdTkn.hasMoreTokens()) {
                            params.add(cmdTkn.nextToken());
                        }
                        Command cmd = this.getCommand(commandName);
                        if (cmd != null) {
                            CommandResult result = cmd.execute(params.toArray());
                            if (result.getType() == "OK") {
                                this.wrtr.write(result.toXML());
                            } else {
                                this.wrtr.write("\r\nError executing command\r\n");
                                this.wrtr.write(result.getResult());
                            }
                        } else {
                            this.wrtr.write("Error: command not found> " + commandName + "\r\n");
                            List<Command> l = this.getCommands();
                            this.wrtr.write("List of commands:\r\n");
                            int i = 0;
                            while (i < l.size()) {
                                cmd = l.get(i);
                                this.wrtr.write(String.valueOf(cmd.getName()) + "\r\n");
                                ++i;
                            }
                        }
                    }
                }
                this.wrtr.flush();
                return;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if (socket == null) return;
                try {
                    socket.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (SAXException e) {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                new OpenAS2Exception(e);
                if (socket == null) return;
                try {
                    socket.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (Exception e) {
                new OpenAS2Exception(e);
                if (socket == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    socket.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.processCommand();
            }
        }
        catch (OpenAS2Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

