/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.h2.jdbcx.JdbcConnectionPool;
import org.openas2.OpenAS2Exception;
import org.openas2.database.IDBHandler;

public class H2DBHandler
implements IDBHandler {
    JdbcConnectionPool cp = null;
    private String jdbcDriver = "org.h2.Driver";
    private String connectString = "jdbc:h2:file:DB/openas2";

    public H2DBHandler() {
    }

    public H2DBHandler(String jdbcDriver) {
        this.setJdbcDriver(jdbcDriver);
    }

    @Override
    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    @Override
    public void createConnectionPool(String connectString, String userName, String pwd) throws OpenAS2Exception {
        if (this.cp != null) {
            throw new OpenAS2Exception("Connection pool already initialized. Cannot create a new connection pool. Stop current one first. DB connect string:" + connectString + " :: Active pool connect string: " + this.connectString);
        }
        this.connectString = connectString;
        this.cp = JdbcConnectionPool.create((String)connectString, (String)userName, (String)pwd);
    }

    @Override
    public void destroyConnectionPool() {
        if (this.cp == null) {
            return;
        }
        this.cp.dispose();
        this.cp = null;
    }

    @Override
    public Connection getConnection() throws SQLException, OpenAS2Exception {
        if (this.cp == null) {
            throw new OpenAS2Exception("Connection pool not initialized.");
        }
        return this.cp.getConnection();
    }

    @Override
    public Connection connect(String connectString, String userName, String password) throws Exception {
        Class.forName(this.jdbcDriver);
        try {
            return DriverManager.getConnection(connectString, userName, password);
        }
        catch (SQLException e) {
            throw new Exception("Failed to obtain connection to database: " + connectString, e);
        }
    }

    @Override
    public boolean shutdown(String connectString) throws SQLException, OpenAS2Exception {
        try {
            for (int waitCount = 0; this.cp.getActiveConnections() > 0 && waitCount < 10; ++waitCount) {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Connection c = this.getConnection();
        Statement st = c.createStatement();
        boolean result = st.execute("SHUTDOWN");
        c.close();
        return result;
    }
}

