/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.bc.BcRSAKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.ZlibCompressor;
import org.bouncycastle.cms.jcajce.ZlibExpanderProvider;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMECompressed;
import org.bouncycastle.mail.smime.SMIMECompressedGenerator;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMESignedParser;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.util.CRLFOutputStream;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.InputExpanderProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputCompressor;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.openas2.DispositionException;
import org.openas2.OpenAS2Exception;
import org.openas2.lib.helper.ICryptoHelper;
import org.openas2.lib.util.IOUtil;
import org.openas2.logging.Log;
import org.openas2.message.AS2Message;
import org.openas2.message.Message;
import org.openas2.util.AS2Util;
import org.openas2.util.DispositionType;

public class BCCryptoHelper
implements ICryptoHelper {
    private org.apache.commons.logging.Log logger = LogFactory.getLog((String)BCCryptoHelper.class.getSimpleName());

    @Override
    public boolean isEncrypted(MimeBodyPart part) throws MessagingException {
        ContentType contentType = new ContentType(part.getContentType());
        String baseType = contentType.getBaseType().toLowerCase();
        if (baseType.equalsIgnoreCase("application/pkcs7-mime")) {
            boolean checkResult;
            String smimeType = contentType.getParameter("smime-type");
            boolean bl = checkResult = smimeType != null && smimeType.equalsIgnoreCase("enveloped-data");
            if (!checkResult && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Check for encrypted data failed on SMIME content type: " + smimeType));
            }
            return checkResult;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Check for encrypted data failed on BASE content type: " + baseType));
        }
        return false;
    }

    @Override
    public boolean isSigned(MimeBodyPart part) throws MessagingException {
        ContentType contentType = new ContentType(part.getContentType());
        String baseType = contentType.getBaseType().toLowerCase();
        return baseType.equalsIgnoreCase("multipart/signed");
    }

    @Override
    public boolean isCompressed(MimeBodyPart part) throws MessagingException {
        ContentType contentType = new ContentType(part.getContentType());
        String baseType = contentType.getBaseType().toLowerCase();
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)("Compression check.  MIME Base Content-Type:" + contentType.getBaseType()));
                this.logger.trace((Object)("Compression check.  SMIME-TYPE:" + contentType.getParameter("smime-type")));
                this.logger.trace((Object)("Compressed MIME msg AFTER COMPRESSION Content-Disposition:" + part.getDisposition()));
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
        if (baseType.equalsIgnoreCase("application/pkcs7-mime")) {
            boolean checkResult;
            String smimeType = contentType.getParameter("smime-type");
            boolean bl = checkResult = smimeType != null && smimeType.equalsIgnoreCase("compressed-data");
            if (!checkResult && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Check for compressed data failed on SMIME content type: " + smimeType));
            }
            return checkResult;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Check for compressed data failed on BASE content type: " + baseType));
        }
        return false;
    }

    @Override
    public String calculateMIC(MimeBodyPart part, String digest, boolean includeHeaders) throws GeneralSecurityException, MessagingException, IOException {
        return this.calculateMIC(part, digest, includeHeaders, false);
    }

    @Override
    public String calculateMIC(MimeBodyPart part, String digest, boolean includeHeaders, boolean noCanonicalize) throws GeneralSecurityException, MessagingException, IOException {
        String micAlg = this.convertAlgorithm(digest, true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Calc MIC called with digest: " + digest + " ::: Incl headers? " + includeHeaders + " ::: Prevent canonicalization: " + noCanonicalize + " ::: Encoding: " + part.getEncoding()));
        }
        MessageDigest md = MessageDigest.getInstance(micAlg, "BC");
        if (includeHeaders && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Calculating MIC on MIMEPART Headers: " + AS2Util.printHeaders(part.getAllHeaders())));
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ByteArrayOutputStream os = null;
        String encoding = part.getEncoding();
        if (encoding == null) {
            encoding = "binary";
        }
        os = "binary".equals(encoding) || noCanonicalize ? bOut : new CRLFOutputStream((OutputStream)bOut);
        if (includeHeaders) {
            part.writeTo((OutputStream)os);
        } else {
            IOUtil.copy(part.getInputStream(), os);
        }
        byte[] data = bOut.toByteArray();
        InputStream bIn = this.trimCRLFPrefix(data);
        DigestInputStream digIn = new DigestInputStream(bIn, md);
        byte[] buf = new byte[4096];
        while (digIn.read(buf) >= 0) {
        }
        bOut.close();
        byte[] mic = digIn.getMessageDigest().digest();
        String micString = new String(Base64.encode((byte[])mic));
        StringBuffer micResult = new StringBuffer(micString);
        micResult.append(", ").append(digest);
        return micResult.toString();
    }

    @Override
    public MimeBodyPart decrypt(MimeBodyPart part, Certificate cert, Key key) throws GeneralSecurityException, MessagingException, CMSException, IOException, SMIMEException {
        if (!this.isEncrypted(part)) {
            throw new GeneralSecurityException("Content-Type indicates data isn't encrypted");
        }
        X509Certificate x509Cert = this.castCertificate(cert);
        SMIMEEnveloped envelope = new SMIMEEnveloped(part);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Extracted X500 info::  PRINCIPAL : " + x509Cert.getIssuerX500Principal() + " ::  NAME : " + x509Cert.getIssuerX500Principal().getName()));
        }
        X500Name x500Name = new X500Name(x509Cert.getIssuerX500Principal().getName());
        KeyTransRecipientId certRecId = new KeyTransRecipientId(x500Name, x509Cert.getSerialNumber());
        RecipientInformationStore recipientInfoStore = envelope.getRecipientInfos();
        Collection recipients = recipientInfoStore.getRecipients();
        if (recipients == null) {
            throw new GeneralSecurityException("Certificate recipients could not be extracted");
        }
        boolean foundRecipient = false;
        for (RecipientInformation recipientInfo : recipients) {
            if (!(recipientInfo instanceof KeyTransRecipientInformation)) continue;
            if (certRecId.match((Object)recipientInfo) && !foundRecipient) {
                foundRecipient = true;
                byte[] decryptedData = recipientInfo.getContent((Recipient)new BcRSAKeyTransEnvelopedRecipient(PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)key.getEncoded()))));
                return SMIMEUtil.toMimeBodyPart((byte[])decryptedData);
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Failed match on recipient ID's:\n     RID from msg:" + recipientInfo.getRID().toString() + "    \n     RID from priv cert: " + certRecId.toString()));
        }
        throw new GeneralSecurityException("Matching certificate recipient could not be found");
    }

    @Override
    public void deinitialize() {
    }

    @Override
    public MimeBodyPart encrypt(MimeBodyPart part, Certificate cert, String algorithm, String contentTxfrEncoding) throws GeneralSecurityException, SMIMEException, MessagingException {
        X509Certificate x509Cert = this.castCertificate(cert);
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        gen.setContentTransferEncoding(this.getEncoding(contentTxfrEncoding));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Encrypting on MIME part containing the following headers: " + AS2Util.printHeaders(part.getAllHeaders())));
        }
        gen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(x509Cert).setProvider("BC"));
        MimeBodyPart encData = gen.generate(part, this.getOutputEncryptor(algorithm));
        System.gc();
        return encData;
    }

    @Override
    public void initialize() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        mc.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mc.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        mc.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        mc.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        CommandMap.setDefaultCommandMap((CommandMap)mc);
    }

    @Override
    public MimeBodyPart sign(MimeBodyPart part, Certificate cert, Key key, String digest, String contentTxfrEncoding, boolean adjustDigestToOldName, boolean isRemoveCmsAlgorithmProtectionAttr) throws GeneralSecurityException, SMIMEException, MessagingException {
        SignerInfoGenerator sig;
        X509Certificate x509Cert = this.castCertificate(cert);
        PrivateKey privKey = this.castKey(key);
        String encryptAlg = cert.getPublicKey().getAlgorithm();
        SMIMESignedGenerator sGen = new SMIMESignedGenerator();
        sGen.setContentTransferEncoding(this.getEncoding(contentTxfrEncoding));
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Params for creating SMIME signed generator:: SIGN DIGEST: " + digest + " PUB ENCRYPT ALG: " + encryptAlg + " X509 CERT: " + x509Cert));
                this.logger.debug((Object)("Signing on MIME part containing the following headers: " + AS2Util.printHeaders(part.getAllHeaders())));
            }
            if (digest.toUpperCase().startsWith("SHA-")) {
                digest = digest.replaceAll("-", "");
            }
            JcaSimpleSignerInfoGeneratorBuilder jSig = new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC");
            sig = jSig.build(digest + "with" + encryptAlg, privKey, x509Cert);
            if (isRemoveCmsAlgorithmProtectionAttr) {
                final CMSAttributeTableGenerator sAttrGen = sig.getSignedAttributeTableGenerator();
                sig = new SignerInfoGenerator(sig, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(){

                    public AttributeTable getAttributes(Map parameters) {
                        AttributeTable ret = sAttrGen.getAttributes(parameters);
                        return ret.remove(CMSAttributes.cmsAlgorithmProtect);
                    }
                }, sig.getUnsignedAttributeTableGenerator());
            }
        }
        catch (OperatorCreationException e) {
            throw new GeneralSecurityException(e);
        }
        sGen.addSignerInfoGenerator(sig);
        MimeMultipart signedData = sGen.generate(part);
        MimeBodyPart tmpBody = new MimeBodyPart();
        tmpBody.setContent((Multipart)signedData);
        String ct = signedData.getContentType();
        if (adjustDigestToOldName && digest.equalsIgnoreCase("SHA1")) {
            ct = ct.replaceAll("-1", "1");
        }
        tmpBody.setHeader("Content-Type", ct);
        return tmpBody;
    }

    @Override
    public MimeBodyPart verifySignature(MimeBodyPart part, Certificate cert) throws GeneralSecurityException, IOException, MessagingException, CMSException, OperatorCreationException {
        if (!this.isSigned(part)) {
            throw new GeneralSecurityException("Content-Type indicates data isn't signed");
        }
        X509Certificate x509Cert = this.castCertificate(cert);
        MimeMultipart mainParts = (MimeMultipart)part.getContent();
        SMIMESigned signedPart = new SMIMESigned(mainParts);
        DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
        String contentTxfrEnc = signedPart.getContent().getEncoding();
        if (contentTxfrEnc == null || contentTxfrEnc.length() < 1) {
            contentTxfrEnc = "binary";
        }
        SMIMESignedParser ssp = new SMIMESignedParser(dcp, mainParts, contentTxfrEnc);
        SignerInformationStore sis = ssp.getSignerInfos();
        if (this.logger.isTraceEnabled()) {
            String headers = null;
            try {
                headers = AS2Util.printHeaders(part.getAllHeaders());
                this.logger.trace((Object)("Headers on MimeBodyPart passed in to signature verifier: " + headers));
                headers = AS2Util.printHeaders(ssp.getContent().getAllHeaders());
                this.logger.trace((Object)("Checking signature on SIGNED MIME part extracted from multipart contains headers: " + headers));
            }
            catch (Throwable e) {
                this.logger.trace((Object)("Error logging mime part for signer: " + Log.getExceptionMsg(e)), e);
            }
        }
        Iterator it = sis.getSigners().iterator();
        SignerInformationVerifier signerInfoVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509Cert);
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            if (this.logger.isTraceEnabled()) {
                AttributeTable attrTbl = signer.getSignedAttributes();
                this.logger.trace((Object)("Signer Attributes: " + (attrTbl == null ? "NULL" : attrTbl.toHashtable())));
            }
            if (signer.verify(signerInfoVerifier)) {
                this.logSignerInfo("Verified signature for signer info", signer, part, x509Cert);
                return signedPart.getContent();
            }
            this.logSignerInfo("Failed to verify signature for signer info", signer, part, x509Cert);
        }
        throw new SignatureException("Signature Verification failed");
    }

    @Override
    public MimeBodyPart compress(Message msg, MimeBodyPart mbp, String compressionType, String contentTxfrEncoding) throws SMIMEException, OpenAS2Exception {
        ZlibCompressor compressor = null;
        if (compressionType != null) {
            if (compressionType.equalsIgnoreCase("zlib")) {
                compressor = new ZlibCompressor();
            } else {
                throw new OpenAS2Exception("Unsupported compression type: " + compressionType);
            }
        }
        SMIMECompressedGenerator sCompGen = new SMIMECompressedGenerator();
        sCompGen.setContentTransferEncoding(this.getEncoding(contentTxfrEncoding));
        MimeBodyPart smime = sCompGen.generate(mbp, (OutputCompressor)compressor);
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)("Compressed MIME msg AFTER COMPRESSION Content-Type:" + smime.getContentType()));
                this.logger.trace((Object)("Compressed MIME msg AFTER COMPRESSION Content-Disposition:" + smime.getDisposition()));
            }
            catch (MessagingException e) {
                // empty catch block
            }
        }
        return smime;
    }

    @Override
    public void decompress(AS2Message msg) throws DispositionException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Decompressing a compressed message");
            }
            SMIMECompressed compressed = new SMIMECompressed(msg.getData());
            MimeBodyPart recoveredPart = SMIMEUtil.toMimeBodyPart((byte[])compressed.getContent((InputExpanderProvider)new ZlibExpanderProvider()));
            msg.setData(recoveredPart);
        }
        catch (Exception ex) {
            msg.setLogMsg("Error decompressing received message: " + ex.getCause());
            this.logger.error((Object)msg, (Throwable)ex);
            throw new DispositionException(new DispositionType("automatic-action", "MDN-sent-automatically", "processed", "Error", "unexpected-processing-error"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decompressing the content.", ex);
        }
    }

    protected String getEncoding(String contentTxfrEncoding) {
        return "binary".equalsIgnoreCase(contentTxfrEncoding) ? "binary" : "base64";
    }

    protected X509Certificate castCertificate(Certificate cert) throws GeneralSecurityException {
        if (cert == null) {
            throw new GeneralSecurityException("Certificate is null");
        }
        if (!(cert instanceof X509Certificate)) {
            throw new GeneralSecurityException("Certificate must be an instance of X509Certificate");
        }
        return (X509Certificate)cert;
    }

    protected PrivateKey castKey(Key key) throws GeneralSecurityException {
        if (!(key instanceof PrivateKey)) {
            throw new GeneralSecurityException("Key must implement PrivateKey interface");
        }
        return (PrivateKey)key;
    }

    protected String convertAlgorithm(String algorithm, boolean toBC) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm is null");
        }
        if (toBC) {
            if (algorithm.toUpperCase().startsWith("SHA-")) {
                algorithm = algorithm.replaceAll("-", "");
            }
            if (algorithm.equalsIgnoreCase("md5")) {
                return SMIMESignedGenerator.DIGEST_MD5;
            }
            if (algorithm.equalsIgnoreCase("sha1")) {
                return SMIMESignedGenerator.DIGEST_SHA1;
            }
            if (algorithm.equalsIgnoreCase("sha224")) {
                return SMIMESignedGenerator.DIGEST_SHA224;
            }
            if (algorithm.equalsIgnoreCase("sha256")) {
                return SMIMESignedGenerator.DIGEST_SHA256;
            }
            if (algorithm.equalsIgnoreCase("sha384")) {
                return SMIMESignedGenerator.DIGEST_SHA384;
            }
            if (algorithm.equalsIgnoreCase("sha512")) {
                return SMIMESignedGenerator.DIGEST_SHA512;
            }
            if (algorithm.equalsIgnoreCase("3des")) {
                return SMIMEEnvelopedGenerator.DES_EDE3_CBC;
            }
            if (algorithm.equalsIgnoreCase("cast5")) {
                return "1.2.840.113533.7.66.10";
            }
            if (algorithm.equalsIgnoreCase("idea")) {
                return "1.3.6.1.4.1.188.7.1.1.2";
            }
            if (algorithm.equalsIgnoreCase("rc2")) {
                return SMIMEEnvelopedGenerator.RC2_CBC;
            }
            if (algorithm.equalsIgnoreCase("rc2_cbc")) {
                return SMIMEEnvelopedGenerator.RC2_CBC;
            }
            if (algorithm.equalsIgnoreCase("aes256")) {
                return SMIMEEnvelopedGenerator.AES256_CBC;
            }
            if (algorithm.equalsIgnoreCase("aes192")) {
                return SMIMEEnvelopedGenerator.AES192_CBC;
            }
            if (algorithm.equalsIgnoreCase("aes128")) {
                return SMIMEEnvelopedGenerator.AES128_CBC;
            }
            if (algorithm.equalsIgnoreCase("aes256_wrap")) {
                return SMIMEEnvelopedGenerator.AES256_WRAP;
            }
            throw new NoSuchAlgorithmException("Unsupported or invalid algorithm: " + algorithm);
        }
        if (algorithm.equalsIgnoreCase(SMIMESignedGenerator.DIGEST_MD5)) {
            return "md5";
        }
        if (algorithm.equalsIgnoreCase(SMIMESignedGenerator.DIGEST_SHA1)) {
            return "sha1";
        }
        if (algorithm.equalsIgnoreCase(SMIMESignedGenerator.DIGEST_SHA224)) {
            return "sha224";
        }
        if (algorithm.equalsIgnoreCase(SMIMESignedGenerator.DIGEST_SHA256)) {
            return "sha256";
        }
        if (algorithm.equalsIgnoreCase(SMIMESignedGenerator.DIGEST_SHA384)) {
            return "sha384";
        }
        if (algorithm.equalsIgnoreCase(SMIMESignedGenerator.DIGEST_SHA512)) {
            return "sha512";
        }
        if (algorithm.equalsIgnoreCase("1.2.840.113533.7.66.10")) {
            return "cast5";
        }
        if (algorithm.equalsIgnoreCase(SMIMEEnvelopedGenerator.AES128_CBC)) {
            return "aes128";
        }
        if (algorithm.equalsIgnoreCase(SMIMEEnvelopedGenerator.AES192_CBC)) {
            return "aes192";
        }
        if (algorithm.equalsIgnoreCase(SMIMEEnvelopedGenerator.AES256_CBC)) {
            return "aes256";
        }
        if (algorithm.equalsIgnoreCase(SMIMEEnvelopedGenerator.AES256_WRAP)) {
            return "aes256_wrap";
        }
        if (algorithm.equalsIgnoreCase(SMIMEEnvelopedGenerator.DES_EDE3_CBC)) {
            return "3des";
        }
        if (algorithm.equalsIgnoreCase("1.3.6.1.4.1.188.7.1.1.2")) {
            return "idea";
        }
        if (algorithm.equalsIgnoreCase(SMIMEEnvelopedGenerator.RC2_CBC)) {
            return "rc2";
        }
        throw new NoSuchAlgorithmException("Unknown algorithm: " + algorithm);
    }

    protected OutputEncryptor getOutputEncryptor(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm is null");
        }
        ASN1ObjectIdentifier asn1ObjId = null;
        int keyLen = -1;
        if (algorithm.equalsIgnoreCase("md2")) {
            asn1ObjId = new ASN1ObjectIdentifier(PKCSObjectIdentifiers.md2.getId());
        } else if (algorithm.equalsIgnoreCase("md5")) {
            asn1ObjId = new ASN1ObjectIdentifier(PKCSObjectIdentifiers.md5.getId());
        } else if (algorithm.equalsIgnoreCase("sha1")) {
            asn1ObjId = new ASN1ObjectIdentifier(OIWObjectIdentifiers.idSHA1.getId());
        } else if (algorithm.equalsIgnoreCase("sha224")) {
            asn1ObjId = new ASN1ObjectIdentifier(NISTObjectIdentifiers.id_sha224.getId());
        } else if (algorithm.equalsIgnoreCase("sha256")) {
            asn1ObjId = new ASN1ObjectIdentifier(NISTObjectIdentifiers.id_sha256.getId());
        } else if (algorithm.equalsIgnoreCase("sha384")) {
            asn1ObjId = new ASN1ObjectIdentifier(NISTObjectIdentifiers.id_sha384.getId());
        } else if (algorithm.equalsIgnoreCase("sha512")) {
            asn1ObjId = new ASN1ObjectIdentifier(NISTObjectIdentifiers.id_sha512.getId());
        } else if (algorithm.equalsIgnoreCase("3des")) {
            asn1ObjId = new ASN1ObjectIdentifier(PKCSObjectIdentifiers.des_EDE3_CBC.getId());
        } else if (algorithm.equalsIgnoreCase("rc2_cbc") || algorithm.equalsIgnoreCase("rc2_cbc")) {
            asn1ObjId = new ASN1ObjectIdentifier(PKCSObjectIdentifiers.RC2_CBC.getId());
            keyLen = 40;
        } else if (algorithm.equalsIgnoreCase("aes128")) {
            asn1ObjId = CMSAlgorithm.AES128_CBC;
        } else if (algorithm.equalsIgnoreCase("aes192")) {
            asn1ObjId = CMSAlgorithm.AES192_CBC;
        } else if (algorithm.equalsIgnoreCase("aes256")) {
            asn1ObjId = CMSAlgorithm.AES256_CBC;
        } else if (algorithm.equalsIgnoreCase("aes256_wrap")) {
            asn1ObjId = CMSAlgorithm.AES256_WRAP;
        } else if (algorithm.equalsIgnoreCase("cast5")) {
            asn1ObjId = CMSAlgorithm.CAST5_CBC;
        } else if (algorithm.equalsIgnoreCase("idea")) {
            asn1ObjId = CMSAlgorithm.IDEA_CBC;
        } else {
            throw new NoSuchAlgorithmException("Unsupported or invalid algorithm: " + algorithm);
        }
        OutputEncryptor oe = null;
        try {
            oe = keyLen < 0 ? new JceCMSContentEncryptorBuilder(asn1ObjId).setProvider("BC").build() : new JceCMSContentEncryptorBuilder(asn1ObjId, keyLen).setProvider("BC").build();
        }
        catch (CMSException e1) {
            throw new NoSuchAlgorithmException("Error creating encryptor builder using algorithm: " + algorithm + " Cause:" + e1.getCause());
        }
        return oe;
    }

    protected InputStream trimCRLFPrefix(byte[] data) {
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        int len = data.length;
        for (int scanPos = 0; scanPos < len - 1; scanPos += 2) {
            if (new String(data, scanPos, 2).equals("\r\n")) {
                bIn.read();
                bIn.read();
                continue;
            }
            return bIn;
        }
        return bIn;
    }

    @Override
    public KeyStore getKeyStore() throws KeyStoreException, NoSuchProviderException {
        return KeyStore.getInstance("PKCS12", "BC");
    }

    @Override
    public KeyStore loadKeyStore(InputStream in, char[] password) throws Exception {
        KeyStore ks = this.getKeyStore();
        ks.load(in, password);
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyStore loadKeyStore(String filename, char[] password) throws Exception {
        FileInputStream fIn = new FileInputStream(filename);
        try {
            KeyStore keyStore = this.loadKeyStore(fIn, password);
            return keyStore;
        }
        finally {
            fIn.close();
        }
    }

    public String getHeaderValue(MimeBodyPart part, String headerName) {
        try {
            String[] values = part.getHeader(headerName);
            if (values == null) {
                return null;
            }
            return values[0];
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public void logSignerInfo(String msgPrefix, SignerInformation signer, MimeBodyPart part, X509Certificate cert) {
        if (this.logger.isDebugEnabled()) {
            try {
                this.logger.debug((Object)(msgPrefix + ": \n    Digest Alg OID: " + signer.getDigestAlgOID() + "\n    Encrypt Alg OID: " + signer.getEncryptionAlgOID() + "\n    Signer Version: " + signer.getVersion() + "\n    Content Digest: " + Arrays.toString(signer.getContentDigest()) + "\n    Content Type: " + signer.getContentType() + "\n    SID: " + signer.getSID().getIssuer() + "\n    Signature: " + signer.getSignature() + "\n    Unsigned attribs: " + signer.getUnsignedAttributes() + "\n    Content-transfer-encoding: " + part.getEncoding() + "\n    Certificate: " + cert));
            }
            catch (Throwable e) {
                this.logger.debug((Object)("Error logging signer info: " + Log.getExceptionMsg(e)), e);
            }
        }
    }
}

