/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.helper;

import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.mail.smime.SMIMEException;
import org.openas2.DispositionException;
import org.openas2.OpenAS2Exception;
import org.openas2.message.AS2Message;
import org.openas2.message.Message;

public interface ICryptoHelper {
    public static final String DIGEST_MD2 = "md2";
    public static final String DIGEST_MD5 = "md5";
    public static final String DIGEST_SHA1 = "sha1";
    public static final String DIGEST_SHA224 = "sha224";
    public static final String DIGEST_SHA256 = "sha256";
    public static final String DIGEST_SHA384 = "sha384";
    public static final String DIGEST_SHA512 = "sha512";
    public static final String CRYPT_CAST5 = "cast5";
    public static final String CRYPT_3DES = "3des";
    public static final String CRYPT_IDEA = "idea";
    public static final String CRYPT_RC2 = "rc2";
    public static final String CRYPT_RC2_CBC = "rc2_cbc";
    public static final String AES128_CBC = "aes128";
    public static final String AES192_CBC = "aes192";
    public static final String AES256_CBC = "aes256";
    public static final String AES256_WRAP = "aes256_wrap";
    public static final String COMPRESSION_UNKNOWN = "compression-unknown";
    public static final String COMPRESSION_NONE = "none";
    public static final String COMPRESSION_ZLIB = "zlib";

    public boolean isEncrypted(MimeBodyPart var1) throws Exception;

    public KeyStore getKeyStore() throws Exception;

    public KeyStore loadKeyStore(InputStream var1, char[] var2) throws Exception;

    public KeyStore loadKeyStore(String var1, char[] var2) throws Exception;

    public boolean isSigned(MimeBodyPart var1) throws Exception;

    public boolean isCompressed(MimeBodyPart var1) throws Exception;

    public String calculateMIC(MimeBodyPart var1, String var2, boolean var3) throws Exception;

    public String calculateMIC(MimeBodyPart var1, String var2, boolean var3, boolean var4) throws Exception;

    public MimeBodyPart decrypt(MimeBodyPart var1, Certificate var2, Key var3) throws Exception;

    public void deinitialize() throws Exception;

    public MimeBodyPart encrypt(MimeBodyPart var1, Certificate var2, String var3, String var4) throws Exception;

    public void initialize() throws Exception;

    public MimeBodyPart sign(MimeBodyPart var1, Certificate var2, Key var3, String var4, String var5, boolean var6, boolean var7) throws Exception;

    public MimeBodyPart verifySignature(MimeBodyPart var1, Certificate var2) throws Exception;

    public MimeBodyPart compress(Message var1, MimeBodyPart var2, String var3, String var4) throws SMIMEException, OpenAS2Exception;

    public void decompress(AS2Message var1) throws DispositionException;
}

