/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.message;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class MessageID {
    private static Random rndGen;
    private Date timeStamp;
    private String receiverID;
    private String senderID;
    private String uniqueStamp;

    protected synchronized Random getRandomGenerator() {
        if (rndGen == null) {
            rndGen = new Random();
        }
        return rndGen;
    }

    public MessageID(String senderID, String receiverID) {
        this.senderID = senderID;
        this.receiverID = receiverID;
    }

    public void setReceiverID(String receiver) {
        this.receiverID = receiver;
    }

    public String getReceiverID() {
        return this.receiverID;
    }

    public void setSenderID(String sender) {
        this.senderID = sender;
    }

    public String getSenderID() {
        return this.senderID;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Date getTimeStamp() {
        if (this.timeStamp == null) {
            this.timeStamp = new Date();
        }
        return this.timeStamp;
    }

    public void setUniqueStamp(String uniqueStamp) {
        this.uniqueStamp = uniqueStamp;
    }

    public String getUniqueStamp() {
        if (this.uniqueStamp == null) {
            DecimalFormat randomFormatter = new DecimalFormat("0000");
            this.uniqueStamp = randomFormatter.format(this.getRandomGenerator().nextInt(10000));
        }
        return this.uniqueStamp;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("ddMMyyyyHHmmssZ");
        buf.append("<OPENAS2-").append(formatter.format(this.getTimeStamp()));
        buf.append("-").append(this.getUniqueStamp());
        if (this.getSenderID() != null || this.getReceiverID() != null) {
            buf.append("@").append(this.getSenderID());
            buf.append("_").append(this.getReceiverID());
        }
        buf.append(">");
        return buf.toString();
    }
}

