/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.logging;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.openas2.OpenAS2Exception;
import org.openas2.logging.BaseFormatter;
import org.openas2.logging.Level;
import org.openas2.util.DateUtil;

public class DefaultFormatter
extends BaseFormatter {
    public String getTerminatedMessage(OpenAS2Exception exception) {
        StringBuffer buf = new StringBuffer("Termination of exception:" + System.getProperty("line.separator"));
        StringWriter strWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(strWriter);
        exception.printStackTrace(printWriter);
        buf.append(strWriter.toString());
        Map<String, Object> sources = exception.getSources();
        for (Map.Entry<String, Object> source : sources.entrySet()) {
            buf.append(source.getKey().toString()).append(System.getProperty("line.separator"));
            buf.append(source.getValue().toString()).append(System.getProperty("line.separator")).append(System.getProperty("line.separator"));
        }
        return buf.toString();
    }

    @Override
    public void format(Level level, String msg, OutputStream out) {
        PrintWriter writer = new PrintWriter(out);
        writer.print(DateUtil.formatDate("MM/dd/yy HH:mm:ss"));
        writer.print(" ");
        writer.println(msg);
        writer.flush();
    }

    @Override
    public void format(OpenAS2Exception exception, boolean terminated, OutputStream out) {
        PrintWriter writer = new PrintWriter(out);
        if (terminated) {
            writer.println("Termination of exception:");
        }
        exception.printStackTrace(writer);
        if (terminated) {
            Map<String, Object> sources = exception.getSources();
            for (Map.Entry<String, Object> source : sources.entrySet()) {
                if (source.getKey() != null) {
                    writer.println(source.getKey().toString());
                } else {
                    writer.println("null key");
                }
                if (source.getValue() != null) {
                    writer.println(source.getValue().toString());
                    continue;
                }
                writer.println("null value");
            }
        }
        writer.println();
        writer.flush();
    }
}

