/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.message;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.ParseException;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.WrappedException;
import org.openas2.logging.Log;
import org.openas2.message.DataHistory;
import org.openas2.message.DataHistoryItem;
import org.openas2.message.Message;
import org.openas2.message.MessageMDN;
import org.openas2.params.InvalidParameterException;
import org.openas2.partner.Partnership;

public abstract class BaseMessage
implements Message {
    private static final long serialVersionUID = 1L;
    private DataHistory history;
    private InternetHeaders headers;
    private Map<String, String> attributes;
    private MessageMDN MDN;
    private MimeBodyPart data;
    private Partnership partnership;
    private String compressionType = "none";
    private boolean rxdMsgWasSigned = false;
    private boolean rxdMsgWasEncrypted = false;
    private Map<Object, Object> options = new HashMap<Object, Object>();
    private String calculatedMIC = null;
    private String logMsg = null;
    private String status = "initializing_msg";
    private Map<String, String> customOuterMimeHeaders = new HashMap<String, String>();
    private String payloadFilename = null;
    private String appTitle;

    @Override
    public String getAppTitle() {
        return this.appTitle;
    }

    @Override
    public void setAppTitle(String title) {
        this.appTitle = title;
    }

    @Override
    public Map<Object, Object> getOptions() {
        if (this.options == null) {
            this.options = new HashMap<Object, Object>();
        }
        return this.options;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public Map<String, String> getCustomOuterMimeHeaders() {
        return this.customOuterMimeHeaders;
    }

    @Override
    public void setCustomOuterMimeHeaders(Map<String, String> customOuterMimeHeaders) {
        this.customOuterMimeHeaders = customOuterMimeHeaders;
    }

    @Override
    public void addCustomOuterMimeHeader(String key, String value) {
        this.customOuterMimeHeaders.put(key, value);
    }

    @Override
    public void setOption(Object key, Object value) {
        this.getOptions().put(key, value);
    }

    @Override
    public Object getOption(Object key) {
        return this.getOptions().get(key);
    }

    @Override
    public void setAttribute(String key, String value) {
        this.getAttributes().put(key, value);
    }

    @Override
    public String getAttribute(String key) {
        return this.getAttributes().get(key);
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    @Override
    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public String getCompressionType() {
        return this.compressionType;
    }

    @Override
    public void setCompressionType(String myCompressionType) {
        this.compressionType = myCompressionType;
    }

    @Override
    public void setContentDisposition(String contentDisposition) {
        this.setHeader("Content-Disposition", contentDisposition);
    }

    @Override
    public String getContentDisposition() {
        return this.getHeader("Content-Disposition");
    }

    @Override
    public void setData(MimeBodyPart data, DataHistoryItem historyItem) {
        this.data = data;
        if (data != null) {
            try {
                this.setContentType(data.getContentType());
            }
            catch (MessagingException e) {
                this.setContentType(null);
            }
            try {
                this.setContentDisposition(data.getHeader("Content-Disposition", null));
            }
            catch (MessagingException e) {
                this.setContentDisposition(null);
            }
        }
        if (historyItem != null) {
            this.getHistory().getItems().add(historyItem);
        }
    }

    @Override
    public DataHistoryItem setData(MimeBodyPart data) throws OpenAS2Exception {
        try {
            DataHistoryItem historyItem = new DataHistoryItem(data.getContentType());
            this.setData(data, historyItem);
            return historyItem;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    @Override
    public MimeBodyPart getData() {
        return this.data;
    }

    @Override
    public void setHeader(String key, String value) {
        this.getHeaders().setHeader(key, value);
    }

    @Override
    public String getHeader(String key) {
        return this.getHeader(key, ", ");
    }

    @Override
    public String getHeader(String key, String delimiter) {
        return this.getHeaders().getHeader(key, delimiter);
    }

    @Override
    public void setHeaders(InternetHeaders headers) {
        this.headers = headers;
    }

    @Override
    public InternetHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new InternetHeaders();
        }
        return this.headers;
    }

    @Override
    public void setHistory(DataHistory history) {
        this.history = history;
    }

    @Override
    public DataHistory getHistory() {
        if (this.history == null) {
            this.history = new DataHistory();
        }
        return this.history;
    }

    @Override
    public void setMDN(MessageMDN mdn) {
        this.MDN = mdn;
    }

    @Override
    public MessageMDN getMDN() {
        return this.MDN;
    }

    @Override
    public void setMessageID(String messageID) {
        this.setHeader("Message-ID", messageID);
    }

    @Override
    public String getMessageID() {
        return this.getHeader("Message-ID");
    }

    @Override
    public void setPartnership(Partnership partnership) {
        this.partnership = partnership;
    }

    @Override
    public Partnership getPartnership() {
        if (this.partnership == null) {
            this.partnership = new Partnership();
        }
        return this.partnership;
    }

    @Override
    public abstract String generateMessageID() throws InvalidParameterException;

    @Override
    public void setSubject(String subject) {
        this.setHeader("Subject", subject);
    }

    @Override
    public String getSubject() {
        return this.getHeader("Subject");
    }

    public boolean isRxdMsgWasSigned() {
        return this.rxdMsgWasSigned;
    }

    public void setRxdMsgWasSigned(boolean rxdMsgWasSigned) {
        this.rxdMsgWasSigned = rxdMsgWasSigned;
    }

    public boolean isRxdMsgWasEncrypted() {
        return this.rxdMsgWasEncrypted;
    }

    public void setRxdMsgWasEncrypted(boolean rxdMsgWasEncrypted) {
        this.rxdMsgWasEncrypted = rxdMsgWasEncrypted;
    }

    @Override
    public void addHeader(String key, String value) {
        this.getHeaders().addHeader(key, value);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Message From:").append(this.getPartnership().getSenderIDs());
        buf.append("To:").append(this.getPartnership().getReceiverIDs());
        Enumeration headerEn = this.getHeaders().getAllHeaders();
        buf.append(System.getProperty("line.separator") + "Headers:{");
        while (headerEn.hasMoreElements()) {
            Header header = (Header)headerEn.nextElement();
            buf.append(header.getName()).append("=").append(header.getValue());
            if (!headerEn.hasMoreElements()) continue;
            buf.append(", ");
        }
        buf.append("}");
        buf.append(System.getProperty("line.separator") + "Attributes:").append(this.getAttributes());
        MessageMDN mdn = this.getMDN();
        if (mdn != null) {
            buf.append(System.getProperty("line.separator") + "MDN:");
            buf.append(mdn.toString());
        }
        return buf.toString();
    }

    @Override
    public void updateMessageID() throws InvalidParameterException {
        this.setMessageID(this.generateMessageID());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.partnership = (Partnership)in.readObject();
        this.attributes = (Map)in.readObject();
        this.history = (DataHistory)in.readObject();
        try {
            this.headers = new InternetHeaders((InputStream)in);
            if (in.read() == 1) {
                this.data = new MimeBodyPart((InputStream)in);
            }
        }
        catch (MessagingException me) {
            throw new IOException("Messaging exception: " + me.getMessage());
        }
        this.MDN = (MessageMDN)in.readObject();
        if (this.MDN != null) {
            this.MDN.setMessage(this);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.partnership);
        out.writeObject(this.attributes);
        out.writeObject(this.history);
        Enumeration en = this.headers.getAllHeaderLines();
        while (en.hasMoreElements()) {
            out.writeBytes(((String)en.nextElement()).toString() + "\r\n");
        }
        out.writeBytes(new String("\r\n"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.data != null) {
                baos.write(1);
                this.data.writeTo((OutputStream)baos);
            } else {
                baos.write(0);
            }
        }
        catch (MessagingException e) {
            throw new IOException("Messaging exception: " + e.getMessage());
        }
        out.write(baos.toByteArray());
        baos.close();
        out.writeObject(this.MDN);
    }

    @Override
    public String getLogMsgID() {
        return " [" + this.getMessageID() + "]";
    }

    @Override
    public void setLogMsg(String msg) {
        this.logMsg = msg;
    }

    @Override
    public String getLogMsg() {
        return this.logMsg;
    }

    @Override
    public String getCalculatedMIC() {
        return this.calculatedMIC;
    }

    @Override
    public void setCalculatedMIC(String calculatedMIC) {
        this.calculatedMIC = calculatedMIC;
    }

    @Override
    public String getPayloadFilename() {
        return this.payloadFilename;
    }

    @Override
    public void setPayloadFilename(String filename) {
        this.payloadFilename = filename;
    }

    @Override
    public void trackMsgState(Session session) {
        try {
            this.options.put("OPTIONAL_MODULE", "true");
            session.getProcessor().handle("track_msg", this, this.options);
        }
        catch (Exception et) {
            this.setLogMsg("Unable to persist message tracking state: " + Log.getExceptionMsg(et));
            LogFactory.getLog((String)BaseMessage.class.getSimpleName()).error((Object)this, (Throwable)et);
        }
    }

    @Override
    public String extractPayloadFilename() throws ParseException {
        String s = this.getContentDisposition();
        if (s == null || s.length() < 1) {
            return null;
        }
        String tmpFilename = null;
        ContentDisposition cd = new ContentDisposition(s);
        tmpFilename = cd.getParameter("filename");
        if (tmpFilename == null || tmpFilename.length() < 1) {
            int n = s.indexOf("filename=");
            if (n > -1) {
                tmpFilename = s.substring(n);
                int n1 = (tmpFilename = tmpFilename.replaceFirst("filename=", "")).indexOf(",");
                if (n1 > -1) {
                    s = s.substring(0, n1 - 1);
                }
                tmpFilename = tmpFilename.replaceAll("\"", "");
                s = s.trim();
            } else {
                int pos = s.lastIndexOf(File.separator);
                if (pos >= 0) {
                    tmpFilename = s.substring(pos + 1);
                }
            }
        }
        return tmpFilename;
    }
}

