/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.receiver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.WrappedException;
import org.openas2.logging.Log;
import org.openas2.message.InvalidMessageException;
import org.openas2.message.Message;
import org.openas2.params.InvalidParameterException;
import org.openas2.params.MessageParameters;
import org.openas2.params.ParameterParser;
import org.openas2.processor.receiver.BaseReceiverModule;
import org.openas2.util.AS2Util;
import org.openas2.util.IOUtilOld;

public abstract class MessageBuilderModule
extends BaseReceiverModule {
    public static final String PARAM_ERROR_DIRECTORY = "errordir";
    public static final String PARAM_SENT_DIRECTORY = "sentdir";
    public static final String PARAM_FORMAT = "format";
    public static final String PARAM_DELIMITERS = "delimiters";
    public static final String PARAM_DEFAULTS = "defaults";
    public static final String PARAM_MIMETYPE = "mimetype";
    public static final String PARAM_RESEND_MAX_RETRIES = "resend_max_retries";
    private org.apache.commons.logging.Log logger = LogFactory.getLog((String)MessageBuilderModule.class.getSimpleName());

    @Override
    public void init(Session session, Map<String, String> options) throws OpenAS2Exception {
        super.init(session, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message processDocument(InputStream ip, String filename) throws OpenAS2Exception, FileNotFoundException {
        String maxRetryCnt;
        Message msg = this.createMessage();
        msg.setAttribute("filename", filename);
        String pendingFile = AS2Util.buildPendingFileName(msg, this.getSession().getProcessor(), "pendingmdn");
        msg.setAttribute("pendingfilename", pendingFile);
        File doc = new File(pendingFile);
        FileOutputStream fo = null;
        try {
            fo = new FileOutputStream(doc);
        }
        catch (FileNotFoundException e1) {
            throw new OpenAS2Exception("Could not create file in pending folder: " + pendingFile, e1);
        }
        try {
            IOUtilOld.copy(ip, fo);
        }
        catch (IOException e1) {
            fo = null;
            throw new OpenAS2Exception("Could not write file to pending folder: " + pendingFile, e1);
        }
        try {
            ip.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ip = null;
        try {
            fo.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        fo = null;
        msg.setAttribute(PARAM_ERROR_DIRECTORY, this.getParameter(PARAM_ERROR_DIRECTORY, true));
        if (this.getParameter(PARAM_SENT_DIRECTORY, false) != null) {
            msg.setAttribute(PARAM_SENT_DIRECTORY, this.getParameter(PARAM_SENT_DIRECTORY, false));
        }
        FileInputStream fis = new FileInputStream(doc);
        try {
            this.updateMessage(msg, fis, filename);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            fis = null;
            doc = null;
        }
        String customHeaderList = msg.getPartnership().getAttribute("custom_mime_header_names_from_filename");
        if (customHeaderList != null && customHeaderList.length() > 0) {
            String[] headerNames = customHeaderList.split("\\s*,\\s*");
            String delimiters = msg.getPartnership().getAttribute("custom_mime_header_name_delimiters_in_filename");
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Adding custom headers based on message file name to custom headers map. Delimeters: " + delimiters + msg.getLogMsgID()));
            }
            if (delimiters != null) {
                StringTokenizer valueTokens = new StringTokenizer(filename, delimiters, false);
                if (valueTokens != null && valueTokens.countTokens() != headerNames.length) {
                    msg.setLogMsg("Filename does not match headers list: Headers=" + customHeaderList + " ::: Filename=" + filename + " ::: String delimiters=" + delimiters);
                    this.logger.error((Object)msg);
                    throw new OpenAS2Exception("Invalid filename for extracting custom headers: " + filename);
                }
                for (int i = 0; i < headerNames.length; ++i) {
                    String[] header = headerNames[i].split("\\.");
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Adding custom header: " + headerNames[i] + " :::Split count:" + header.length + msg.getLogMsgID()));
                    }
                    if (header.length != 2) {
                        throw new OpenAS2Exception("Invalid custom header: " + headerNames[i] + "  :: The header name must be prefixed by \"header.\" or \"junk.\" etc");
                    }
                    if (!"header".equalsIgnoreCase(header[0])) continue;
                    msg.addCustomOuterMimeHeader(header[1], valueTokens.nextToken());
                }
            } else {
                String regex = msg.getPartnership().getAttribute("custom_mime_header_names_regex_on_filename");
                if (regex != null) {
                    Pattern p = Pattern.compile(regex);
                    Matcher m = p.matcher(filename);
                    if (!m.find() || m.groupCount() != headerNames.length) {
                        msg.setLogMsg("Could not match filename to headers required using the regex provided: " + (m.find() ? "Mismatch in header count to extracted group count: " + headerNames.length + "::" + m.groupCount() : "No match found in filename"));
                        this.logger.error((Object)msg);
                        throw new OpenAS2Exception("Invalid filename for extracting custom headers: " + filename);
                    }
                    for (int i = 0; i < headerNames.length; ++i) {
                        msg.addCustomOuterMimeHeader(headerNames[i], m.group(i + 1));
                    }
                }
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("File assigned to message: " + filename + msg.getLogMsgID()));
        }
        if (msg.getData() == null) {
            throw new InvalidMessageException("Failed to retrieve data for outbound AS2 message for file: " + filename);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("PARTNERSHIP parms: " + msg.getPartnership().getAttributes() + msg.getLogMsgID()));
        }
        if ((maxRetryCnt = msg.getPartnership().getAttribute(PARAM_RESEND_MAX_RETRIES)) == null || maxRetryCnt.length() < 1) {
            maxRetryCnt = this.getSession().getProcessor().getParameters().get(PARAM_RESEND_MAX_RETRIES);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("RESEND COUNT extracted from config: " + maxRetryCnt + msg.getLogMsgID()));
        }
        Map<Object, Object> options = msg.getOptions();
        options.put("retries", maxRetryCnt);
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)("Message object in directory polling module. Content-Disposition: " + msg.getContentDisposition() + "\n      Content-Type : " + msg.getContentType() + "\n      HEADERS : " + AS2Util.printHeaders(msg.getData().getAllHeaders()) + "\n      Content-Disposition in MSG getData() MIMEPART: " + msg.getData().getContentType() + msg.getLogMsgID()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            msg.setStatus("sending_msg");
            this.getSession().getProcessor().handle("send", msg, options);
        }
        catch (Exception e) {
            msg.setLogMsg("Fatal error sending message: " + Log.getExceptionMsg(e));
            this.logger.error((Object)msg, (Throwable)e);
            AS2Util.cleanupFiles(msg, true);
        }
        return msg;
    }

    protected abstract Message createMessage();

    public void updateMessage(Message msg, InputStream ip, String filename) throws OpenAS2Exception {
        String format;
        MessageParameters params = new MessageParameters(msg);
        String defaults = this.getParameter(PARAM_DEFAULTS, false);
        if (defaults != null) {
            params.setParameters(defaults);
        }
        if ((format = this.getParameter(PARAM_FORMAT, false)) != null) {
            String delimiters = this.getParameter(PARAM_DELIMITERS, ".-");
            params.setParameters(format, delimiters, filename);
        }
        this.getSession().getPartnershipFactory().updatePartnership(msg, true);
        msg.updateMessageID();
        msg.setHeader("AS2-To", msg.getPartnership().getReceiverID("as2_id"));
        msg.setHeader("AS2-From", msg.getPartnership().getSenderID("as2_id"));
        try {
            String contentType = this.getParameter(PARAM_MIMETYPE, false);
            if (contentType == null) {
                contentType = "application/octet-stream";
            } else {
                try {
                    contentType = ParameterParser.parse(contentType, params);
                }
                catch (InvalidParameterException e) {
                    throw new OpenAS2Exception("Bad content-type" + contentType, e);
                }
            }
            ByteArrayDataSource byteSource = new ByteArrayDataSource(ip, contentType);
            MimeBodyPart body = new MimeBodyPart();
            body.setDataHandler(new DataHandler((DataSource)byteSource));
            body.setHeader("Content-Type", contentType);
            String sendFileName = this.getParameter("sendfilename", false);
            if (sendFileName != null && sendFileName.equals("true")) {
                String contentDisposition = "Attachment; filename=\"" + msg.getAttribute("filename") + "\"";
                body.setHeader("Content-Disposition", contentDisposition);
                msg.setContentDisposition(contentDisposition);
            }
            msg.setData(body);
        }
        catch (MessagingException me) {
            throw new WrappedException(me);
        }
        catch (IOException ioe) {
            throw new WrappedException(ioe);
        }
        if (msg.getPartnership().isSetTransferEncodingOnInitialBodyPart()) {
            String contentTxfrEncoding = msg.getPartnership().getAttribute("content_transfer_encoding");
            if (contentTxfrEncoding == null) {
                contentTxfrEncoding = "binary";
            }
            try {
                msg.getData().setHeader("Content-Transfer-Encoding", contentTxfrEncoding);
            }
            catch (MessagingException e) {
                throw new OpenAS2Exception("Failed to set content transfer encoding in created MimeBodyPart: " + Log.getExceptionMsg(e), e);
            }
        }
    }
}

