/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.sender;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.cert.CertificateFactory;
import org.openas2.logging.Log;
import org.openas2.message.AS2Message;
import org.openas2.message.DataHistoryItem;
import org.openas2.message.Message;
import org.openas2.params.InvalidParameterException;
import org.openas2.partner.Partnership;
import org.openas2.processor.sender.HttpResponseException;
import org.openas2.processor.sender.HttpSenderModule;
import org.openas2.util.AS2Util;
import org.openas2.util.DateUtil;
import org.openas2.util.DispositionOptions;
import org.openas2.util.IOUtilOld;
import org.openas2.util.Profiler;
import org.openas2.util.ProfilerStub;

public class AS2SenderModule
extends HttpSenderModule {
    private org.apache.commons.logging.Log logger = LogFactory.getLog((String)AS2SenderModule.class.getSimpleName());

    @Override
    public boolean canHandle(String action, Message msg, Map<Object, Object> options) {
        if (!action.equals("send")) {
            return false;
        }
        return msg instanceof AS2Message;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handle(String action, Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkRequired(Message msg) throws InvalidParameterException {
        Partnership partnership = msg.getPartnership();
        try {
            InvalidParameterException.checkValue(msg, "ContentType", msg.getContentType());
            InvalidParameterException.checkValue(msg, "Attribute: as2_url", partnership.getAttribute("as2_url"));
            InvalidParameterException.checkValue(msg, "Receiver: as2_id", partnership.getReceiverID("as2_id"));
            InvalidParameterException.checkValue(msg, "Sender: as2_id", partnership.getSenderID("as2_id"));
            InvalidParameterException.checkValue(msg, "Subject", msg.getSubject());
            InvalidParameterException.checkValue(msg, "Sender: email", partnership.getSenderID("email"));
            InvalidParameterException.checkValue(msg, "Message Data", msg.getData());
        }
        catch (InvalidParameterException rpe) {
            rpe.addSource("message", msg);
            throw rpe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(HttpURLConnection conn, Message msg, MimeBodyPart securedData, String retries) throws Exception {
        this.updateHttpHeaders(conn, msg, securedData);
        msg.setAttribute("destination_ip", conn.getURL().getHost());
        msg.setAttribute("destination_port", Integer.toString(conn.getURL().getPort()));
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Connecting to: " + conn.getURL() + msg.getLogMsgID()));
        }
        OutputStream messageOut = conn.getOutputStream();
        InputStream messageIn = securedData.getInputStream();
        try {
            ProfilerStub transferStub = Profiler.startProfile();
            int bytes = IOUtilOld.copy(messageIn, messageOut);
            Profiler.endProfile(transferStub);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("transferred " + IOUtilOld.getTransferRate(bytes, transferStub) + msg.getLogMsgID()));
            }
        }
        finally {
            messageIn.close();
        }
        int rc = conn.getResponseCode();
        if (rc != 200 && rc != 201 && rc != 202 && rc != 206 && rc != 204) {
            msg.setLogMsg("Error sending message. URL: " + conn.getURL().toString() + " ::: Response Code: " + rc + " ::: Response Message: " + conn.getResponseMessage());
            this.logger.error((Object)msg);
            throw new HttpResponseException(conn.getURL().toString(), rc, conn.getResponseMessage());
        }
    }

    private void resend(Message msg, OpenAS2Exception cause, String tries) throws OpenAS2Exception {
        AS2Util.resend(this.getSession().getProcessor(), this, "send", msg, cause, tries, false);
    }

    protected MimeBodyPart secure(Message msg) throws Exception {
        String t;
        boolean sign;
        MimeBodyPart dataBP = msg.getData();
        Partnership partnership = msg.getPartnership();
        String contentTxfrEncoding = partnership.getAttribute("content_transfer_encoding");
        if (contentTxfrEncoding == null) {
            contentTxfrEncoding = "binary";
        }
        boolean encrypt = partnership.getAttribute("encrypt") != null;
        boolean bl = sign = partnership.getAttribute("sign") != null;
        if (!sign) {
            this.calcAndStoreMic(msg, dataBP, sign || encrypt);
        }
        String compressionType = msg.getPartnership().getAttribute("compression_type");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Compression type from config: " + compressionType));
        }
        boolean isCompress = false;
        if (compressionType != null) {
            if (compressionType.equalsIgnoreCase("zlib")) {
                isCompress = true;
            } else {
                throw new OpenAS2Exception("Unsupported compression type: " + compressionType);
            }
        }
        String compressionMode = msg.getPartnership().getAttribute("compression_mode");
        boolean isCompressBeforeSign = true;
        if (compressionMode != null && compressionMode.equalsIgnoreCase("compress-after-signing")) {
            isCompressBeforeSign = false;
        }
        if (isCompress && isCompressBeforeSign) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Compressing outbound message before signing...");
            }
            if (!sign && !encrypt) {
                this.addCustomOuterMimeHeaders(msg, dataBP);
            }
            dataBP = AS2Util.getCryptoHelper().compress(msg, dataBP, compressionType, contentTxfrEncoding);
        }
        CertificateFactory certFx = this.getSession().getCertificateFactory();
        if (sign) {
            if (!(encrypt || isCompress && !isCompressBeforeSign)) {
                this.addCustomOuterMimeHeaders(msg, dataBP);
            }
            this.calcAndStoreMic(msg, dataBP, sign || encrypt);
            X509Certificate senderCert = certFx.getCertificate(msg, "sender");
            PrivateKey senderKey = certFx.getPrivateKey(msg, senderCert);
            String digest = partnership.getAttribute("sign");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Params for creating signed body part:: DATA: " + dataBP + "\n SIGN DIGEST: " + digest + "\n CERT ALG NAME EXTRACTED: " + senderCert.getSigAlgName() + "\n CERT PUB KEY ALG NAME EXTRACTED: " + senderCert.getPublicKey().getAlgorithm() + msg.getLogMsgID()));
            }
            boolean isRemoveCmsAlgorithmProtectionAttr = "true".equalsIgnoreCase(partnership.getAttribute("remove_cms_algorithm_protection_attrib"));
            dataBP = AS2Util.getCryptoHelper().sign(dataBP, senderCert, senderKey, digest, contentTxfrEncoding, msg.getPartnership().isRenameDigestToOldName(), isRemoveCmsAlgorithmProtectionAttr);
            DataHistoryItem historyItem = new DataHistoryItem(dataBP.getContentType());
            msg.getHistory().getItems().add(historyItem);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("signed data" + msg.getLogMsgID()));
            }
        }
        if (isCompress && !isCompressBeforeSign) {
            if (!encrypt) {
                this.addCustomOuterMimeHeaders(msg, dataBP);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Compressing outbound message after signing...");
            }
            dataBP = AS2Util.getCryptoHelper().compress(msg, dataBP, compressionType, contentTxfrEncoding);
        }
        if (encrypt) {
            this.addCustomOuterMimeHeaders(msg, dataBP);
            String algorithm = partnership.getAttribute("encrypt");
            X509Certificate receiverCert = certFx.getCertificate(msg, "receiver");
            dataBP = AS2Util.getCryptoHelper().encrypt(dataBP, receiverCert, algorithm, contentTxfrEncoding);
            DataHistoryItem historyItem = new DataHistoryItem(dataBP.getContentType());
            msg.getHistory().getItems().add(historyItem);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("encrypted data" + msg.getLogMsgID()));
            }
        }
        if (((t = dataBP.getEncoding()) == null || t.length() < 1) && "true".equalsIgnoreCase(partnership.getAttribute("set_content_transfer_encoding_on_outer_mime_bodypart"))) {
            dataBP.setHeader("Content-Transfer-Encoding", contentTxfrEncoding);
        }
        return dataBP;
    }

    protected void addCustomOuterMimeHeaders(Message msg, MimeBodyPart dataBP) throws MessagingException {
        Map<String, String> hdrs;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Adding custom headers to outer MBP...." + msg.getLogMsgID()));
        }
        if ((hdrs = msg.getCustomOuterMimeHeaders()) == null) {
            return;
        }
        for (Map.Entry<String, String> entry : hdrs.entrySet()) {
            dataBP.addHeader(entry.getKey(), entry.getValue());
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace((Object)("Added custom headers to outer MBP: " + entry.getKey() + "--->" + entry.getValue() + msg.getLogMsgID()));
        }
    }

    protected void updateHttpHeaders(HttpURLConnection conn, Message msg, MimeBodyPart securedData) {
        String contentDisp;
        String receiptOption;
        String dispOptions;
        Partnership partnership = msg.getPartnership();
        conn.setRequestProperty("Connection", "close, TE");
        conn.setRequestProperty("User-Agent", msg.getAppTitle() + " (AS2Sender)");
        conn.setRequestProperty("Date", DateUtil.formatDate("EEE, dd MMM yyyy HH:mm:ss Z"));
        conn.setRequestProperty("Message-ID", msg.getMessageID());
        conn.setRequestProperty("Mime-Version", "1.0");
        try {
            conn.setRequestProperty("Content-type", securedData.getContentType());
        }
        catch (MessagingException e) {
            conn.setRequestProperty("Content-type", msg.getContentType());
        }
        conn.setRequestProperty("AS2-Version", "1.1");
        String cte = null;
        try {
            cte = securedData.getEncoding();
        }
        catch (MessagingException e1) {
            e1.printStackTrace();
        }
        if (cte == null) {
            cte = "binary";
        }
        conn.setRequestProperty("Content-Transfer-Encoding", cte);
        conn.setRequestProperty("Recipient-Address", partnership.getAttribute("as2_url"));
        conn.setRequestProperty("AS2-To", partnership.getReceiverID("as2_id"));
        conn.setRequestProperty("AS2-From", partnership.getSenderID("as2_id"));
        conn.setRequestProperty("Subject", msg.getSubject());
        conn.setRequestProperty("From", partnership.getSenderID("email"));
        String dispTo = partnership.getAttribute("as2_mdn_to");
        if (dispTo != null) {
            conn.setRequestProperty("Disposition-Notification-To", dispTo);
        }
        if ((dispOptions = partnership.getAttribute("as2_mdn_options")) != null) {
            conn.setRequestProperty("Disposition-Notification-Options", dispOptions);
        }
        if ((receiptOption = partnership.getAttribute("as2_receipt_option")) != null) {
            conn.setRequestProperty("Receipt-Delivery-Option", receiptOption);
        }
        try {
            contentDisp = securedData.getDisposition();
        }
        catch (MessagingException e) {
            contentDisp = msg.getContentDisposition();
        }
        if (contentDisp != null) {
            conn.setRequestProperty("Content-Disposition", contentDisp);
        }
        if ("true".equalsIgnoreCase(partnership.getAttribute("add_custom_mime_headers_to_http"))) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Adding custom headers to HTTP..." + msg.getLogMsgID()));
            }
            for (Map.Entry<String, String> entry : msg.getCustomOuterMimeHeaders().entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void storePendingInfo(AS2Message msg, boolean isResend) throws Exception {
        ObjectOutputStream oos = null;
        try {
            String pendingInfoFile = AS2Util.buildPendingFileName(msg, this.getSession().getProcessor(), "pendingmdninfo");
            String pendingFile = msg.getAttribute("pendingfilename");
            msg.setAttribute("pendingfilename", pendingFile);
            if (!isResend) {
                String pendingMsgObjFile = pendingFile + ".object";
                oos = new ObjectOutputStream(new FileOutputStream(pendingMsgObjFile));
                oos.writeObject(msg);
                oos.flush();
                oos.close();
            }
            msg.setAttribute("pendinginfo", pendingInfoFile);
            oos = new ObjectOutputStream(new FileOutputStream(pendingInfoFile));
            oos.writeObject(msg.getCalculatedMIC());
            String retries = (String)msg.getOption("retries");
            oos.writeObject(retries == null ? "" : retries);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Save Original mic & message id information into file: " + pendingInfoFile + msg.getLogMsgID()));
            }
            oos.writeObject(msg.getAttribute("filename"));
            oos.writeObject(pendingFile);
            oos.writeObject(msg.getAttribute("errordir"));
            String sentDir = msg.getAttribute("sentdir");
            oos.writeObject(sentDir == null ? "" : sentDir);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Pending info file written to:" + pendingInfoFile + "\n        Original MIC: " + msg.getCalculatedMIC() + "\n        Retry Count: " + retries + "\n        Original file name : " + msg.getAttribute("filename") + "\n        Pending message file : " + pendingFile + "\n        Error directory: " + msg.getAttribute("errordir") + "\n        Sent directory: " + msg.getAttribute("sentdir") + msg.getLogMsgID()));
            }
            msg.setAttribute("status", "pending");
        }
        catch (Exception e) {
            msg.setLogMsg("Error setting up pending information files: " + Log.getExceptionMsg(e));
            this.logger.error((Object)msg, (Throwable)e);
            throw new Exception("Unable to set up pending information files.");
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void calcAndStoreMic(Message msg, MimeBodyPart mbp, boolean includeHeaders) throws Exception {
        DispositionOptions dispOptions = new DispositionOptions(msg.getPartnership().getAttribute("as2_mdn_options"));
        msg.setCalculatedMIC(AS2Util.getCryptoHelper().calculateMIC(mbp, dispOptions.getMicalg(), includeHeaders, msg.getPartnership().isPreventCanonicalization()));
        if (this.logger.isTraceEnabled()) {
            String tmic = AS2Util.getCryptoHelper().calculateMIC(mbp, dispOptions.getMicalg(), includeHeaders, !msg.getPartnership().isPreventCanonicalization());
            this.logger.trace((Object)("MIC outbound with forced reversed prevent canocalization: " + tmic + msg.getLogMsgID()));
            tmic = AS2Util.getCryptoHelper().calculateMIC(msg.getData(), dispOptions.getMicalg(), false, msg.getPartnership().isPreventCanonicalization());
            this.logger.trace((Object)("MIC outbound with forced exclude headers flag: " + tmic + msg.getLogMsgID()));
        }
    }
}

