/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.DispositionException;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.cert.CertificateFactory;
import org.openas2.cert.CertificateNotFoundException;
import org.openas2.cert.KeyNotFoundException;
import org.openas2.lib.helper.BCCryptoHelper;
import org.openas2.lib.helper.ICryptoHelper;
import org.openas2.lib.util.MimeUtil;
import org.openas2.message.AS2Message;
import org.openas2.message.AS2MessageMDN;
import org.openas2.message.Message;
import org.openas2.message.MessageMDN;
import org.openas2.params.MessageParameters;
import org.openas2.params.ParameterParser;
import org.openas2.partner.Partnership;
import org.openas2.processor.Processor;
import org.openas2.util.DateUtil;
import org.openas2.util.DispositionOptions;
import org.openas2.util.DispositionType;
import org.openas2.util.HTTPUtil;
import org.openas2.util.IOUtilOld;

public class AS2Util {
    private static ICryptoHelper ch;

    public static ICryptoHelper getCryptoHelper() throws Exception {
        if (ch == null) {
            ch = new BCCryptoHelper();
            ch.initialize();
        }
        return ch;
    }

    public static MessageMDN createMDN(Session session, AS2Message msg, String mic, DispositionType disposition, String text) throws Exception {
        AS2MessageMDN mdn = new AS2MessageMDN(msg, false);
        mdn.setHeader("AS2-Version", "1.1");
        mdn.setHeader("Date", DateUtil.formatDate("EEE, dd MMM yyyy HH:mm:ss Z"));
        mdn.setHeader("Server", session.getAppTitle());
        mdn.setHeader("Mime-Version", "1.0");
        mdn.getPartnership().setSenderID("as2_id", mdn.getHeader("AS2-From"));
        mdn.getPartnership().setReceiverID("as2_id", mdn.getHeader("AS2-To"));
        session.getPartnershipFactory().updatePartnership(mdn, true);
        mdn.setHeader("From", msg.getPartnership().getReceiverID("email"));
        String subject = mdn.getPartnership().getAttribute("mdnsubject");
        if (subject != null) {
            mdn.setHeader("Subject", ParameterParser.parse(subject, new MessageParameters(msg)));
        } else {
            mdn.setHeader("Subject", "Your Requested MDN Response");
        }
        mdn.setText(ParameterParser.parse(text, new MessageParameters(msg)));
        mdn.setAttribute("REPORTING_UA", session.getAppTitle() + "@" + msg.getAttribute("destination_ip") + ":" + msg.getAttribute("destination_port"));
        mdn.setAttribute("ORIGINAL_RECIPIENT", "rfc822; " + msg.getHeader("AS2-To"));
        mdn.setAttribute("FINAL_RECIPIENT", "rfc822; " + msg.getPartnership().getReceiverID("as2_id"));
        mdn.setAttribute("ORIGINAL_MESSAGE_ID", msg.getHeader("Message-ID"));
        mdn.setAttribute("DISPOSITION", disposition.toString());
        DispositionOptions dispOptions = new DispositionOptions(msg.getHeader("Disposition-Notification-Options"));
        mdn.setAttribute("MIC", mic);
        AS2Util.createMDNData(session, mdn, dispOptions.getMicalg(), dispOptions.getProtocol());
        mdn.updateMessageID();
        msg.setMDN(mdn);
        return mdn;
    }

    public static void createMDNData(Session session, MessageMDN mdn, String micAlg, String signatureProtocol) throws Exception {
        MimeMultipart reportParts = new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        String text = mdn.getText() + "\r\n";
        textPart.setContent((Object)text, "text/plain");
        textPart.setHeader("Content-Type", "text/plain");
        reportParts.addBodyPart((BodyPart)textPart);
        MimeBodyPart reportPart = new MimeBodyPart();
        InternetHeaders reportValues = new InternetHeaders();
        reportValues.setHeader("Reporting-UA", mdn.getAttribute("REPORTING_UA"));
        reportValues.setHeader("Original-Recipient", mdn.getAttribute("ORIGINAL_RECIPIENT"));
        reportValues.setHeader("Final-Recipient", mdn.getAttribute("FINAL_RECIPIENT"));
        reportValues.setHeader("Original-Message-ID", mdn.getAttribute("ORIGINAL_MESSAGE_ID"));
        reportValues.setHeader("Disposition", mdn.getAttribute("DISPOSITION"));
        reportValues.setHeader("Received-Content-MIC", mdn.getAttribute("MIC"));
        Enumeration reportEn = reportValues.getAllHeaderLines();
        StringBuffer reportData = new StringBuffer();
        while (reportEn.hasMoreElements()) {
            reportData.append((String)reportEn.nextElement()).append("\r\n");
        }
        reportData.append("\r\n");
        String reportText = reportData.toString();
        reportPart.setContent((Object)reportText, "message/disposition-notification");
        reportPart.setHeader("Content-Type", "message/disposition-notification");
        reportParts.addBodyPart((BodyPart)reportPart);
        MimeBodyPart report = new MimeBodyPart();
        reportParts.setSubType("report; report-type=disposition-notification");
        report.setContent((Multipart)reportParts);
        report.setHeader("Content-Type", reportParts.getContentType());
        if (signatureProtocol != null) {
            CertificateFactory certFx = session.getCertificateFactory();
            try {
                X509Certificate senderCert = certFx.getCertificate(mdn, "receiver");
                PrivateKey senderKey = certFx.getPrivateKey(mdn, senderCert);
                Partnership p = mdn.getPartnership();
                String contentTxfrEncoding = p.getAttribute("content_transfer_encoding");
                boolean isRemoveCmsAlgorithmProtectionAttr = "true".equalsIgnoreCase(p.getAttribute("remove_cms_algorithm_protection_attrib"));
                if (contentTxfrEncoding == null) {
                    contentTxfrEncoding = "binary";
                }
                MimeBodyPart signedReport = AS2Util.getCryptoHelper().sign(report, senderCert, senderKey, micAlg, contentTxfrEncoding, false, isRemoveCmsAlgorithmProtectionAttr);
                mdn.setData(signedReport);
            }
            catch (CertificateNotFoundException cnfe) {
                cnfe.terminate();
                mdn.setData(report);
            }
            catch (KeyNotFoundException knfe) {
                knfe.terminate();
                mdn.setData(report);
            }
        } else {
            mdn.setData(report);
        }
        MimeBodyPart data = mdn.getData();
        mdn.setHeader("Content-Type", data.getContentType());
    }

    public static void parseMDN(Message msg, X509Certificate receiver) throws OpenAS2Exception {
        Log logger = LogFactory.getLog((String)AS2Util.class.getSimpleName());
        MessageMDN mdn = msg.getMDN();
        MimeBodyPart mainPart = mdn.getData();
        try {
            ICryptoHelper ch = AS2Util.getCryptoHelper();
            if (ch.isSigned(mainPart)) {
                mainPart = AS2Util.getCryptoHelper().verifySignature(mainPart, receiver);
            }
        }
        catch (Exception e1) {
            logger.error((Object)("Error parsing MDN: " + org.openas2.logging.Log.getExceptionMsg(e1)), (Throwable)e1);
            throw new OpenAS2Exception("Failed to verify signature of received MDN.");
        }
        try {
            ContentType reportType;
            MimeMultipart reportParts = new MimeMultipart(mainPart.getDataHandler().getDataSource());
            if (logger.isTraceEnabled() && "true".equalsIgnoreCase(System.getProperty("logRxdMdnMimeBodyParts", "false"))) {
                logger.trace((Object)("Received MimeBodyPart for inbound MDN: " + msg.getLogMsgID() + "\n" + MimeUtil.toString(mainPart, true)));
            }
            if (reportParts != null && (reportType = new ContentType(reportParts.getContentType())).getBaseType().equalsIgnoreCase("multipart/report")) {
                int reportCount = reportParts.getCount();
                for (int j = 0; j < reportCount; ++j) {
                    MimeBodyPart reportPart = (MimeBodyPart)reportParts.getBodyPart(j);
                    if (logger.isTraceEnabled() && "true".equalsIgnoreCase(System.getProperty("logRxdMdnMimeBodyParts", "false"))) {
                        logger.trace((Object)("Report MimeBodyPart from Multipart for inbound MDN: " + msg.getLogMsgID() + "\n" + MimeUtil.toString(reportPart, true)));
                    }
                    if (reportPart.isMimeType("text/plain")) {
                        mdn.setText(reportPart.getContent().toString());
                        continue;
                    }
                    if (!reportPart.isMimeType("message/disposition-notification")) continue;
                    InternetHeaders disposition = new InternetHeaders(reportPart.getInputStream());
                    mdn.setAttribute("REPORTING_UA", disposition.getHeader("Reporting-UA", ", "));
                    mdn.setAttribute("ORIGINAL_RECIPIENT", disposition.getHeader("Original-Recipient", ", "));
                    mdn.setAttribute("FINAL_RECIPIENT", disposition.getHeader("Final-Recipient", ", "));
                    mdn.setAttribute("ORIGINAL_MESSAGE_ID", disposition.getHeader("Original-Message-ID", ", "));
                    mdn.setAttribute("DISPOSITION", disposition.getHeader("Disposition", ", "));
                    mdn.setAttribute("MIC", disposition.getHeader("Received-Content-MIC", ", "));
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkMDN(AS2Message msg) throws DispositionException, OpenAS2Exception {
        String regex;
        Pattern p;
        Matcher m;
        String returnMIC;
        Log logger = LogFactory.getLog((String)AS2Util.class.getSimpleName());
        String disposition = msg.getMDN().getAttribute("DISPOSITION");
        if (disposition != null && logger.isInfoEnabled()) {
            logger.info((Object)("received MDN [" + disposition + "]" + msg.getLogMsgID()));
        }
        boolean dispositionHasWarning = false;
        try {
            new DispositionType(disposition).validate();
        }
        catch (DispositionException de) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Disposition exception on MDN. Disposition: " + disposition + msg.getLogMsgID()), (Throwable)de);
            }
            dispositionHasWarning = true;
            de.setText(msg.getMDN().getText());
            if (de.getDisposition() != null && de.getDisposition().isWarning()) {
                de.addSource("message", msg);
                de.terminate();
            }
            throw de;
        }
        catch (OpenAS2Exception e) {
            msg.setLogMsg("Processing error occurred: " + org.openas2.logging.Log.getExceptionMsg(e));
            logger.error((Object)msg, (Throwable)e);
            throw new OpenAS2Exception(e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"MIC processing start... ");
        }
        if ((returnMIC = msg.getMDN().getAttribute("MIC")) == null || returnMIC.length() < 1) {
            if (dispositionHasWarning) {
                msg.setLogMsg("Returned MIC not found but disposition has warning so might be normal.");
                logger.warn((Object)msg);
            } else {
                msg.setLogMsg("Returned MIC not found so cannot validate returned message.");
                logger.error((Object)msg);
            }
            return false;
        }
        String calcMIC = msg.getCalculatedMIC();
        if (calcMIC == null) {
            throw new OpenAS2Exception("The claculated MIC was not retrieved from the message object.");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MIC check on calculated MIC: " + calcMIC + msg.getLogMsgID()));
        }
        if (!(m = (p = Pattern.compile(regex = "^\\s*(\\S+)\\s*,\\s*(\\S+)\\s*$")).matcher(returnMIC)).find()) {
            msg.setLogMsg("Invalid MIC format in returned MIC: " + returnMIC);
            logger.error((Object)msg);
            throw new OpenAS2Exception("Invalid MIC string received. Forcing Resend");
        }
        String rMic = m.group(1);
        String rMicAlg = m.group(2);
        m = p.matcher(calcMIC);
        if (!m.find()) {
            msg.setLogMsg("Invalid MIC format in calculated MIC: " + calcMIC);
            logger.error((Object)msg);
            throw new OpenAS2Exception("Invalid MIC string retrieved from calculated MIC. Forcing Resend");
        }
        String cMic = m.group(1);
        String cMicAlg = m.group(2);
        if (!cMicAlg.equalsIgnoreCase(rMicAlg) && !cMicAlg.replaceAll("-", "").equalsIgnoreCase(rMicAlg.replaceAll("-", ""))) {
            String errmsg = "MIC algorithm returned by partner is not the same as the algorithm requested, original MIC alg: " + cMicAlg + " ::: returned MIC alg: " + rMicAlg + "\n\t\tPartner probably not implemented AS2 spec correctly or does not support the requested algorithm. Check that the \"as2_mdn_options\" attribute for the partner uses the same algorithm as the \"sign\" attribute.";
            throw new OpenAS2Exception(errmsg + " Forcing Resend");
        }
        if (!cMic.equals(rMic)) {
            msg.setLogMsg("MIC not matched, original MIC: " + calcMIC + " return MIC: " + returnMIC);
            logger.error((Object)msg);
            throw new OpenAS2Exception("MIC not matched. Forcing Resend");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MIC is matched, received MIC: " + returnMIC + msg.getLogMsgID()));
        }
        return true;
    }

    public static String retries(Map<Object, Object> options, String fallbackRetries) {
        String left;
        if (options == null || (left = (String)options.get("retries")) == null) {
            left = fallbackRetries;
        }
        if (left == null) {
            left = "-1";
        }
        try {
            Integer.parseInt(left);
        }
        catch (Exception e) {
            return "-1";
        }
        return left;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resend(Processor processor, Object sourceClass, String how, Message msg, OpenAS2Exception cause, String tries, boolean useOriginalMsgObject) throws OpenAS2Exception {
        Log logger = LogFactory.getLog((String)AS2Util.class.getSimpleName());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RESEND requested.... retries to go: " + tries + "\n        Message file from passed in object: " + msg.getAttribute("pendingfilename") + msg.getLogMsgID()));
        }
        int retries = -1;
        if (tries == null) {
            tries = "-1";
        }
        try {
            retries = Integer.parseInt(tries);
        }
        catch (Exception e) {
            msg.setLogMsg("The retry count is not a valid integer value: " + tries);
            logger.error((Object)msg);
        }
        if (retries >= 0 && retries-- <= 0) {
            msg.setLogMsg("Message abandoned after retry limit reached.");
            logger.error((Object)msg);
            throw new OpenAS2Exception("Message abandoned after retry limit reached." + msg.getLogMsgID());
        }
        if (useOriginalMsgObject) {
            Message originalMsg;
            String pendingMsgObjFileName = msg.getAttribute("pendingfilename") + ".object";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Pending msg object file to retrieve data from in MDN receiver: " + pendingMsgObjFileName));
            }
            ObjectInputStream pifois = null;
            try {
                try {
                    pifois = new ObjectInputStream(new FileInputStream(new File(pendingMsgObjFileName)));
                }
                catch (FileNotFoundException e) {
                    throw new OpenAS2Exception("Could not retrieve pending info file: " + org.openas2.logging.Log.getExceptionMsg(e), e);
                }
                catch (IOException e) {
                    throw new OpenAS2Exception("Could not open pending info file: " + org.openas2.logging.Log.getExceptionMsg(e), e);
                }
                try {
                    originalMsg = (Message)pifois.readObject();
                }
                catch (Exception e) {
                    throw new OpenAS2Exception("Cannot retrieve original message object for resend: " + org.openas2.logging.Log.getExceptionMsg(e));
                }
            }
            finally {
                try {
                    if (pifois != null) {
                        pifois.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            originalMsg.setAttribute("pendinginfo", msg.getAttribute("pendinginfo"));
            originalMsg.setMessageID(msg.getMessageID());
            originalMsg.setOption("retries", tries);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Message file extracted from passed in object: " + msg.getAttribute("pendingfilename") + "\n        Message file extracted from original object: " + originalMsg.getAttribute("pendingfilename") + msg.getLogMsgID()));
            }
            msg = originalMsg;
        }
        String oldMsgId = msg.getMessageID();
        String oldPendingInfoFileName = msg.getAttribute("pendinginfo");
        String newMsgId = ((AS2Message)msg).generateMessageID();
        msg.setMessageID(newMsgId);
        String newPendingInfoFileName = AS2Util.buildPendingFileName(msg, processor, "pendingmdninfo");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n        Old Msg Id: " + oldMsgId + "\n        Old Info File: " + oldPendingInfoFileName + "\n        New Info File: " + newPendingInfoFileName + msg.getLogMsgID()));
        }
        File oldPendInfFile = new File(oldPendingInfoFileName);
        File newPendInfFile = new File(newPendingInfoFileName);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Attempting to rename pending info file : " + oldPendInfFile.getName() + " :::: New name: " + newPendInfFile.getName() + msg.getLogMsgID()));
        }
        try {
            newPendInfFile = IOUtilOld.moveFile(oldPendInfFile, newPendInfFile, false, true);
            msg.setAttribute("pendinginfo", newPendingInfoFileName);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Renamed pending info file : " + oldPendInfFile.getName() + " :::: New name: " + newPendInfFile.getName() + msg.getLogMsgID()));
            }
        }
        catch (IOException iose) {
            msg.setLogMsg("Error renaming file: " + org.openas2.logging.Log.getExceptionMsg(iose));
            logger.error((Object)msg, (Throwable)iose);
        }
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("cause", cause);
        options.put("initial_sender", sourceClass);
        options.put("resend_method", how);
        options.put("retries", "" + retries);
        processor.handle("resend", msg, options);
        return true;
    }

    public static void processMDN(AS2Message msg, byte[] data, OutputStream out, boolean isAsyncMDN, Session session, Object sourceClass) throws OpenAS2Exception, IOException {
        Log logger = LogFactory.getLog((String)AS2Util.class.getSimpleName());
        MessageMDN mdn = msg.getMDN();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("HTTP headers in received MDN: " + AS2Util.printHeaders(mdn.getHeaders().getAllHeaders())));
        }
        mdn.getPartnership().setSenderID("as2_id", mdn.getHeader("AS2-From"));
        mdn.getPartnership().setReceiverID("as2_id", mdn.getHeader("AS2-To"));
        session.getPartnershipFactory().updatePartnership(mdn, false);
        try {
            MimeBodyPart part = new MimeBodyPart(mdn.getHeaders(), data);
            msg.getMDN().setData(part);
        }
        catch (MessagingException e1) {
            msg.setLogMsg("Failed to create mimebodypart from received MDN data: " + org.openas2.logging.Log.getExceptionMsg(e1));
            logger.error((Object)msg, (Throwable)e1);
            if (isAsyncMDN) {
                HTTPUtil.sendHTTPResponse(out, 400, false);
            }
            throw new OpenAS2Exception("Error receiving MDN. Processing stopped.");
        }
        CertificateFactory cFx = session.getCertificateFactory();
        X509Certificate senderCert = cFx.getCertificate(mdn, "receiver");
        msg.setStatus("parsing_mdn");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Parsing MDN: " + mdn.toString() + msg.getLogMsgID()));
        }
        AS2Util.parseMDN(msg, senderCert);
        if (isAsyncMDN) {
            AS2Util.getMetaData(msg, session);
        }
        String retries = (String)msg.getOption("retries");
        msg.setStatus("verifying_mdn");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MDN parsed. Checking MDN report..." + msg.getLogMsgID()));
        }
        try {
            AS2Util.checkMDN(msg);
            if (isAsyncMDN) {
                HTTPUtil.sendHTTPResponse(out, 200, false);
            }
        }
        catch (DispositionException de) {
            if (isAsyncMDN) {
                HTTPUtil.sendHTTPResponse(out, 200, false);
            }
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Disposition exception processing MDN ..." + msg.getLogMsgID()), (Throwable)de);
            }
            AS2Util.resend(session.getProcessor(), sourceClass, "send", msg, de, retries, true);
            msg.setOption("STATE", "msg_sent_mdn_received_error");
            msg.trackMsgState(session);
            return;
        }
        catch (OpenAS2Exception oae) {
            if (isAsyncMDN) {
                HTTPUtil.sendHTTPResponse(out, 200, false);
            }
            OpenAS2Exception oae2 = new OpenAS2Exception("Message was sent but an error occured while receiving the MDN: " + org.openas2.logging.Log.getExceptionMsg(oae));
            oae2.initCause(oae);
            oae2.addSource("message", msg);
            oae2.terminate();
            AS2Util.resend(session.getProcessor(), sourceClass, "send", msg, oae2, retries, true);
            msg.setOption("STATE", "msg_sent_mdn_received_error");
            msg.trackMsgState(session);
            return;
        }
        msg.setOption("STATE", "msg_sent_mdn_received_ok");
        msg.trackMsgState(session);
        session.getProcessor().handle("storemdn", msg, null);
        msg.setStatus("cleanup");
        msg.setLogMsg("Message sent and MDN received successfully.");
        logger.info((Object)msg);
        AS2Util.cleanupFiles(msg, false);
    }

    public static String buildPendingFileName(Message msg, Processor processor, String directoryIdentifier) throws OpenAS2Exception {
        String msgId = msg.getMessageID();
        String dir = processor.getParameters().get(directoryIdentifier);
        if (msgId == null || msgId.length() < 1) {
            msgId = msg.getAttribute("filename") + "." + UUID.randomUUID();
        }
        return dir + "/" + msgId;
    }

    public static void getMetaData(AS2Message msg, Session session) throws OpenAS2Exception {
        ObjectInputStream pifois;
        Log logger = LogFactory.getLog((String)AS2Util.class.getSimpleName());
        String originalMsgId = msg.getMDN().getAttribute("ORIGINAL_MESSAGE_ID");
        msg.setMessageID(originalMsgId);
        String pendinginfofile = AS2Util.buildPendingFileName(msg, session.getProcessor(), "pendingmdninfo");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Pending info file to retrieve data from in MDN receiver: " + pendinginfofile));
        }
        try {
            pifois = new ObjectInputStream(new FileInputStream(new File(pendinginfofile)));
        }
        catch (FileNotFoundException e) {
            throw new OpenAS2Exception("Could not retrieve pending info file: " + org.openas2.logging.Log.getExceptionMsg(e), e);
        }
        catch (IOException e) {
            throw new OpenAS2Exception("Could not open pending info file: " + org.openas2.logging.Log.getExceptionMsg(e), e);
        }
        try {
            msg.setCalculatedMIC((String)pifois.readObject());
            String retries = (String)pifois.readObject();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("RETRY COUNT from pending info file: " + retries));
            }
            msg.setOption("retries", retries);
            msg.setAttribute("filename", (String)pifois.readObject());
            msg.setAttribute("pendingfilename", (String)pifois.readObject());
            msg.setAttribute("errordir", (String)pifois.readObject());
            msg.setAttribute("sentdir", (String)pifois.readObject());
            msg.setAttribute("pendinginfo", pendinginfofile);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Data retrieved from Pending info file:\n        Original MIC: " + msg.getCalculatedMIC() + "\n        Retry Count: " + retries + "\n        Original file name : " + msg.getAttribute("filename") + "\n        Pending message file : " + msg.getAttribute("pendingfilename") + "\n        Error directory: " + msg.getAttribute("errordir") + "\n        Sent directory: " + msg.getAttribute("sentdir") + msg.getLogMsgID()));
            }
        }
        catch (IOException e) {
            throw new OpenAS2Exception("Failed to retrieve the pending MDN information from file: " + org.openas2.logging.Log.getExceptionMsg(e), e);
        }
        catch (ClassNotFoundException e) {
            throw new OpenAS2Exception("Failed to rebuild an object from the pending MDN information from file: " + org.openas2.logging.Log.getExceptionMsg(e), e);
        }
        finally {
            if (pifois != null) {
                try {
                    pifois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void cleanupFiles(Message msg, boolean isError) {
        Log logger = LogFactory.getLog((String)AS2Util.class.getSimpleName());
        String pendingInfoFileName = msg.getAttribute("pendinginfo");
        File fPendingInfoFile = new File(pendingInfoFileName);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Deleting pendinginfo file : " + fPendingInfoFile.getAbsolutePath() + msg.getLogMsgID()));
        }
        try {
            IOUtilOld.deleteFile(fPendingInfoFile);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("deleted " + pendingInfoFileName + msg.getLogMsgID()));
            }
        }
        catch (Exception e) {
            msg.setLogMsg("File was successfully sent but info file not deleted: " + pendingInfoFileName);
            logger.warn((Object)msg, (Throwable)e);
        }
        String pendingFileName = msg.getAttribute("pendingfilename");
        File fPendingFile = new File(pendingFileName);
        try {
            IOUtilOld.deleteFile(new File(pendingFileName + ".object"));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("deleted " + pendingFileName + ".object" + msg.getLogMsgID()));
            }
        }
        catch (Exception e) {
            msg.setLogMsg("File was successfully sent but message object file not deleted: " + org.openas2.logging.Log.getExceptionMsg(e));
            logger.warn((Object)msg, (Throwable)e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Cleaning up pending file : " + fPendingFile.getName() + " from pending folder : " + fPendingFile.getParent() + msg.getLogMsgID()));
        }
        try {
            boolean isMoved = false;
            String tgtDir = null;
            tgtDir = isError ? msg.getAttribute("errordir") : msg.getAttribute("sentdir");
            if (tgtDir != null && tgtDir.length() > 0) {
                File tgtFile = null;
                try {
                    tgtFile = new File(tgtDir + "/" + fPendingFile.getName());
                    tgtFile = IOUtilOld.moveFile(fPendingFile, tgtFile, false, true);
                    isMoved = true;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("moved " + fPendingFile.getAbsolutePath() + " to " + tgtFile.getAbsolutePath() + msg.getLogMsgID()));
                    }
                }
                catch (IOException iose) {
                    logger.error((Object)("Error moving file to sent folder: " + iose.getMessage() + msg.getLogMsgID()), (Throwable)iose);
                }
            }
            if (!isMoved) {
                IOUtilOld.deleteFile(fPendingFile);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("deleted " + fPendingFile.getAbsolutePath() + msg.getLogMsgID()));
                }
            }
        }
        catch (Exception e) {
            msg.setLogMsg("File was successfully sent but not deleted: " + fPendingFile.getAbsolutePath());
            logger.error((Object)msg, (Throwable)e);
        }
    }

    public static String printHeaders(Enumeration<Header> hdrs) {
        return AS2Util.printHeaders(hdrs, " == ", "\n\t\t");
    }

    public static String printHeaders(Enumeration<Header> hdrs, String nameValueSeparator, String valuePairSeparator) {
        String headers = "";
        while (hdrs.hasMoreElements()) {
            Header h = hdrs.nextElement();
            headers = headers + valuePairSeparator + h.getName() + nameValueSeparator + h.getValue();
        }
        return headers;
    }
}

