/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.openas2.util.FileMonitorListener;

public class FileMonitor {
    public List<FileMonitorListener> listeners;
    private Date lastModified;
    private File file;
    private Timer timer;
    private boolean busy;
    private int interval;

    public FileMonitor(File file, int interval) {
        this.file = file;
        this.interval = interval;
        this.start();
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        if (this.getFile() != null) {
            return this.getFile().getAbsolutePath();
        }
        return null;
    }

    public void setInterval(int interval) {
        this.interval = interval;
        this.restart();
    }

    public int getInterval() {
        return this.interval;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setListeners(List<FileMonitorListener> listeners) {
        this.listeners = listeners;
    }

    public List<FileMonitorListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<FileMonitorListener>();
        }
        return this.listeners;
    }

    public void addListener(FileMonitorListener listener) {
        this.getListeners().add(listener);
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void start() {
        this.timer = this.getTimer();
        this.timer.scheduleAtFixedRate((TimerTask)new TimerTick(), 0L, (long)(this.getInterval() * 1000));
    }

    public void stop() {
        if (this.getTimer() != null) {
            this.getTimer().cancel();
        }
    }

    protected boolean isModified() {
        Date lastModified = this.getLastModified();
        if (lastModified != null) {
            Date currentModified = new Date(this.getFile().lastModified());
            return !currentModified.equals(this.getLastModified());
        }
        this.updateModified();
        return false;
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(true);
        }
        return this.timer;
    }

    protected void updateListeners() {
        if (this.isModified()) {
            this.updateModified();
            this.updateListeners(1);
        }
    }

    protected void updateListeners(int eventID) {
        Iterator<FileMonitorListener> iterator;
        List<FileMonitorListener> listeners = this.getListeners();
        Iterator<FileMonitorListener> it = iterator = listeners.iterator();
        while (it.hasNext()) {
            it.next().handle(this, this.getFile(), eventID);
        }
    }

    protected void updateModified() {
        this.setLastModified(new Date(this.getFile().lastModified()));
    }

    private class TimerTick
    extends TimerTask {
        private TimerTick() {
        }

        @Override
        public void run() {
            if (!FileMonitor.this.isBusy()) {
                FileMonitor.this.setBusy(true);
                FileMonitor.this.updateListeners();
                FileMonitor.this.setBusy(false);
            } else {
                FileMonitor.this.updateListeners(-1);
            }
        }
    }
}

