/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;
import org.openas2.OpenAS2Exception;
import org.openas2.message.InvalidMessageException;
import org.openas2.util.ProfilerStub;

public class IOUtilOld {
    public static final String VALID_FILENAME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.@-";

    public static File getDirectoryFile(String directory) throws IOException {
        File directoryFile = new File(directory);
        if (!directoryFile.exists() && !directoryFile.mkdirs()) {
            throw new IOException("Could not create directory: " + directory);
        }
        if (!directoryFile.isDirectory()) {
            throw new IOException("Invalid directory: " + directory);
        }
        return directoryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileBytes(File file) throws IOException {
        FileInputStream fis = null;
        try {
            int byteCount;
            fis = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((byteCount = fis.read(buf)) >= 0) {
                baos.write(buf, 0, byteCount);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static String getTransferRate(int bytes, ProfilerStub stub) {
        StringBuffer buf = new StringBuffer();
        buf.append(bytes).append(" bytes in ");
        buf.append(stub.getCombined()).append(" at ");
        long time = stub.getDifference();
        if (time != 0L) {
            double stime = (double)time / 1000.0;
            long rate = Math.round((double)bytes / stime);
            buf.append(IOUtilOld.getTransferRate(rate));
        } else {
            buf.append(IOUtilOld.getTransferRate(bytes));
        }
        return buf.toString();
    }

    public static String getTransferRate(long bytesPerSecond) {
        StringBuffer buf = new StringBuffer();
        long kbytesPerSecond = bytesPerSecond / 1024L;
        if (bytesPerSecond < 1024L) {
            buf.append(bytesPerSecond).append(" Bps");
        } else if (kbytesPerSecond < 1024L) {
            buf.append(kbytesPerSecond).append(".").append(bytesPerSecond % 1024L).append(" KBps");
        } else {
            buf.append(kbytesPerSecond / 1024L).append(".").append(kbytesPerSecond % 1024L).append(" MBps");
        }
        return buf.toString();
    }

    public static File getUnique(File dir, String filename) {
        filename = IOUtilOld.cleanFilename(filename);
        return new File(dir, filename + "." + UUID.randomUUID());
    }

    public static String cleanFilename(String filename) {
        byte[] fnBytes = filename.getBytes();
        for (int i = 0; i < fnBytes.length; ++i) {
            byte c = fnBytes[i];
            if (VALID_FILENAME_CHARS.indexOf(c) != -1) continue;
            fnBytes[i] = 95;
        }
        return new String(fnBytes);
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int totalCount = 0;
        byte[] buf = new byte[4096];
        int count = 0;
        while (count >= 0) {
            count = in.read(buf);
            totalCount += count;
            if (count <= 0) continue;
            out.write(buf, 0, count);
        }
        return totalCount;
    }

    public static int copy(InputStream in, OutputStream out, int contentSize) throws IOException {
        int totalCount;
        byte[] buf = new byte[4096];
        int bytesIn = 0;
        for (totalCount = 0; bytesIn >= 0 && totalCount < contentSize; totalCount += bytesIn) {
            bytesIn = in.read(buf);
            if (bytesIn <= 0) continue;
            out.write(buf, 0, bytesIn);
        }
        return totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream fIn = null;
        FileOutputStream fOut = null;
        try {
            fIn = new FileInputStream(src);
            fOut = new FileOutputStream(dest);
            IOUtilOld.copy(fIn, fOut);
        }
        finally {
            if (fIn != null) {
                fIn.close();
            }
            if (fOut != null) {
                fOut.close();
            }
        }
    }

    public static void handleError(File file, String errorDirectory) throws OpenAS2Exception {
        File destFile = null;
        try {
            File errorDir = IOUtilOld.getDirectoryFile(errorDirectory);
            destFile = new File(errorDir, file.getName());
            destFile = IOUtilOld.moveFile(file, destFile, false, true);
        }
        catch (IOException ioe) {
            InvalidMessageException im = new InvalidMessageException("Failed to move " + file.getAbsolutePath() + " to error directory " + destFile.getAbsolutePath());
            im.initCause(ioe);
            throw im;
        }
        InvalidMessageException imMoved = new InvalidMessageException("Moved " + file.getAbsolutePath() + " to " + destFile.getAbsolutePath());
        imMoved.terminate();
    }

    public static void moveFile(File src, File dest) throws IOException {
        IOUtilOld.copyFile(src, dest);
        if (!src.delete()) {
            dest.delete();
            throw new IOException("Move failed, unable to delete " + src);
        }
    }

    public static File moveFile(File src, File dest, boolean overwrite, boolean rename) throws IOException {
        if (!overwrite && dest.exists()) {
            if (rename) {
                dest = IOUtilOld.getUnique(dest.getAbsoluteFile().getParentFile(), dest.getName());
            } else {
                throw new IOException("File already exists: " + dest);
            }
        }
        IOUtilOld.copyFile(src, dest);
        if (!src.delete()) {
            dest.delete();
            throw new IOException("Move failed, unable to delete " + src);
        }
        return dest;
    }

    public static void deleteFile(File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        boolean canUseNio = true;
        try {
            Class.forName("java.nio.file.Path");
        }
        catch (ClassNotFoundException e) {
            canUseNio = false;
        }
        if (canUseNio) {
            Path fp = f.toPath();
            Files.delete(fp);
        } else if (!f.delete()) {
            throw new IOException("Failed to delete file: " + f.getName());
        }
    }

    public static byte[] toArray(InputStream in) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int count = in.read(buf);
        while (count >= 0) {
            bOut.write(buf, 0, count);
            count = in.read(buf);
        }
        return bOut.toByteArray();
    }

    public static File[] getFiles(File dir, final String extensionFilter) {
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith("." + extensionFilter);
            }
        });
    }
}

