/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import org.openas2.lib.OpenAS2Exception;

public class URLParser {
    String url = "";
    String host = "?";
    int port = 80;
    String resourcename = "?";

    public URLParser(String url) throws OpenAS2Exception {
        if (!url.toUpperCase().startsWith("HTTP://")) {
            throw new OpenAS2Exception("bad url for URLParser,  see " + url);
        }
        url = url.substring(7);
        int pos1 = url.indexOf(":");
        int pos2 = url.indexOf("/");
        if (pos1 < 0) {
            this.port = 80;
            this.host = url.substring(0, pos2);
        } else {
            this.port = Integer.parseInt(url.substring(pos1 + 1, pos2));
            this.host = url.substring(0, pos1);
        }
        this.resourcename = url.substring(pos2);
    }

    public String getHOST() {
        return this.host;
    }

    public int getPORT() {
        return this.port;
    }

    public String getRESOURCE() {
        return this.resourcename;
    }

    public static void main(String[] args) throws OpenAS2Exception {
        URLParser UP = new URLParser("http://www.google.com/search?ie=UTF-8&oe=UTF-8&sourceid=navclient&gfns=1&q=urlparser+java");
        System.out.println("host : " + UP.getHOST());
        System.out.println("port : " + UP.getPORT());
        System.out.println("resource : " + UP.getRESOURCE());
    }
}

