/*
 * Decompiled with CFR 0.152.
 */
package org.openas2;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openas2.BaseSession;
import org.openas2.OpenAS2Exception;
import org.openas2.cert.CertificateFactory;
import org.openas2.cmd.CommandManager;
import org.openas2.cmd.CommandRegistry;
import org.openas2.cmd.CommandRegistryFactory;
import org.openas2.cmd.processor.BaseCommandProcessor;
import org.openas2.logging.LogManager;
import org.openas2.logging.Logger;
import org.openas2.partner.PartnershipFactory;
import org.openas2.processor.Processor;
import org.openas2.processor.ProcessorModule;
import org.openas2.util.Properties;
import org.openas2.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSession
extends BaseSession
implements CommandRegistryFactory {
    public static final String EL_PROPERTIES = "properties";
    public static final String EL_CERTIFICATES = "certificates";
    public static final String EL_CMDPROCESSOR = "commandProcessors";
    public static final String EL_PROCESSOR = "processor";
    public static final String EL_PARTNERSHIPS = "partnerships";
    public static final String EL_COMMANDS = "commands";
    public static final String EL_LOGGERS = "loggers";
    public static final String PARAM_BASE_DIRECTORY = "basedir";
    private CommandRegistry commandRegistry;
    private CommandManager cmdManager;
    private String VERSION;
    private String TITLE;

    public XMLSession(InputStream in) throws OpenAS2Exception, ParserConfigurationException, SAXException, IOException {
        this.load(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLSession(String filename) throws OpenAS2Exception, ParserConfigurationException, SAXException, IOException {
        File file = new File(filename).getAbsoluteFile();
        this.setBaseDirectory(file.getParent());
        FileInputStream fin = new FileInputStream(file);
        try {
            this.load(fin);
        }
        finally {
            fin.close();
        }
    }

    public void setCommandRegistry(CommandRegistry registry) {
        this.commandRegistry = registry;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    protected void load(InputStream in) throws ParserConfigurationException, SAXException, IOException, OpenAS2Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(in);
        Element root = document.getDocumentElement();
        NodeList rootNodes = root.getChildNodes();
        for (int i = 0; i < rootNodes.getLength(); ++i) {
            Node rootNode = rootNodes.item(i);
            String nodeName = rootNode.getNodeName();
            if (nodeName.equals(EL_PROPERTIES)) {
                this.loadProperties(rootNode);
                continue;
            }
            if (nodeName.equals(EL_CERTIFICATES)) {
                this.loadCertificates(rootNode);
                continue;
            }
            if (nodeName.equals(EL_PROCESSOR)) {
                this.loadProcessor(rootNode);
                continue;
            }
            if (nodeName.equals(EL_CMDPROCESSOR)) {
                this.loadCommandProcessors(rootNode);
                continue;
            }
            if (nodeName.equals(EL_PARTNERSHIPS)) {
                this.loadPartnerships(rootNode);
                continue;
            }
            if (nodeName.equals(EL_COMMANDS)) {
                this.loadCommands(rootNode);
                continue;
            }
            if (nodeName.equals(EL_LOGGERS)) {
                this.loadLoggers(rootNode);
                continue;
            }
            if (nodeName.equals("#text") || nodeName.equals("#comment")) continue;
            throw new OpenAS2Exception("Undefined tag: " + nodeName);
        }
    }

    protected void loadProperties(Node propNode) {
        Map<String, String> properties = XMLUtil.mapAttributes(propNode);
        Properties.setProperties(properties);
    }

    protected void loadCertificates(Node rootNode) throws OpenAS2Exception {
        CertificateFactory certFx = (CertificateFactory)XMLUtil.getComponent(rootNode, this);
        this.setComponent("certificatefactory", certFx);
    }

    protected void loadCommands(Node rootNode) throws OpenAS2Exception {
        CommandRegistry cmdReg = (CommandRegistry)XMLUtil.getComponent(rootNode, this);
        this.setCommandRegistry(cmdReg);
    }

    protected void loadLoggers(Node rootNode) throws OpenAS2Exception {
        LogManager manager = LogManager.getLogManager();
        if (!LogManager.isRegisteredWithApache()) {
            throw new OpenAS2Exception("the OpenAS2 loggers' log manager must registered with the jvm argument -Dorg.apache.commons.logging.Log=org.openas2.logging.Log");
        }
        NodeList loggers = rootNode.getChildNodes();
        for (int i = 0; i < loggers.getLength(); ++i) {
            Node logger = loggers.item(i);
            if (!logger.getNodeName().equals("logger")) continue;
            this.loadLogger(manager, logger);
        }
    }

    protected void loadLogger(LogManager manager, Node loggerNode) throws OpenAS2Exception {
        Logger logger = (Logger)XMLUtil.getComponent(loggerNode, this);
        manager.addLogger(logger);
    }

    protected void loadCommandProcessors(Node rootNode) throws OpenAS2Exception {
        this.cmdManager = CommandManager.getCmdManager();
        NodeList cmdProcessor = rootNode.getChildNodes();
        for (int i = 0; i < cmdProcessor.getLength(); ++i) {
            Node processor = cmdProcessor.item(i);
            if (!processor.getNodeName().equals("commandProcessor")) continue;
            this.loadCommandProcessor(this.cmdManager, processor);
        }
    }

    public CommandManager getCommandManager() {
        return this.cmdManager;
    }

    protected void loadCommandProcessor(CommandManager manager, Node cmdPrcessorNode) throws OpenAS2Exception {
        BaseCommandProcessor cmdProcesor = (BaseCommandProcessor)XMLUtil.getComponent(cmdPrcessorNode, this);
        manager.addProcessor(cmdProcesor);
    }

    protected void loadPartnerships(Node rootNode) throws OpenAS2Exception {
        PartnershipFactory partnerFx = (PartnershipFactory)XMLUtil.getComponent(rootNode, this);
        this.setComponent("partnershipfactory", partnerFx);
    }

    protected void loadProcessor(Node rootNode) throws OpenAS2Exception {
        Processor proc = (Processor)XMLUtil.getComponent(rootNode, this);
        this.setComponent(EL_PROCESSOR, proc);
        NodeList modules = rootNode.getChildNodes();
        for (int i = 0; i < modules.getLength(); ++i) {
            Node module = modules.item(i);
            if (!module.getNodeName().equals("module")) continue;
            this.loadProcessorModule(proc, module);
        }
    }

    protected void loadProcessorModule(Processor proc, Node moduleNode) throws OpenAS2Exception {
        ProcessorModule procmod = (ProcessorModule)XMLUtil.getComponent(moduleNode, this);
        proc.getModules().add(procmod);
    }

    private String getManifestAttribValue(String attrib) {
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                try {
                    Manifest manifest;
                    Attributes mainAttribs;
                    String value;
                    InputStream is;
                    URL url = resEnum.nextElement();
                    if (!url.getPath().contains("openas2") || (is = url.openStream()) == null || (value = (mainAttribs = (manifest = new Manifest(is)).getMainAttributes()).getValue(attrib)) == null) continue;
                    return value;
                }
                catch (Exception e) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getAppVersion() {
        if (this.VERSION == null) {
            this.VERSION = this.getManifestAttribValue("Implementation-Version");
        }
        return this.VERSION;
    }

    @Override
    public String getAppTitle() {
        if (this.TITLE == null) {
            this.TITLE = this.getManifestAttribValue("Implementation-Title") + " v" + this.getAppVersion();
        }
        return this.TITLE;
    }
}

