/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.app;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.XMLSession;
import org.openas2.cmd.CommandManager;
import org.openas2.cmd.CommandRegistry;
import org.openas2.cmd.processor.BaseCommandProcessor;

public class OpenAS2Server {
    protected BufferedWriter sysOut;
    BaseCommandProcessor cmd = null;
    XMLSession session = null;

    public static void main(String[] args) {
        OpenAS2Server server = new OpenAS2Server();
        server.start(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String[] args) {
        int exitStatus = 0;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                OpenAS2Server.this.shutdown();
                System.out.println("Shutdown due to process interruption!");
            }
        });
        try {
            int i;
            File cfg;
            String configFile;
            Log logger = LogFactory.getLog((String)OpenAS2Server.class.getSimpleName());
            this.write("Retrieving config file..." + System.getProperty("line.separator"));
            String string = configFile = args.length > 0 ? args[0] : System.getProperty("openas2.config.file");
            if (configFile == null || configFile.length() < 1) {
                configFile = System.getProperty("user.dir") + "/../config/config.xml";
            }
            if (!(cfg = new File(configFile)).exists()) {
                this.write("No config file found: " + configFile + System.getProperty("line.separator"));
                this.write("Pass as the first paramter on the command line or set the system property \"openas2.config.file\" to identify the configuration file to start OpenAS2" + System.getProperty("line.separator"));
                throw new Exception("Missing configuration file");
            }
            this.session = new XMLSession(configFile);
            this.write("Starting Server..." + System.getProperty("line.separator"));
            this.write("Loading configuration..." + System.getProperty("line.separator"));
            this.write(this.session.getAppTitle() + ": Session instantiated." + System.getProperty("line.separator"));
            this.write("Registering Session to Command Processor..." + System.getProperty("line.separator"));
            CommandRegistry reg = this.session.getCommandRegistry();
            this.write("Starting Active Modules..." + System.getProperty("line.separator"));
            this.session.getProcessor().startActiveModules();
            this.write(this.session.getAppTitle() + " Started" + System.getProperty("line.separator"));
            logger.info((Object)("- OpenAS2 Started - V" + this.session.getAppVersion()));
            CommandManager cmdMgr = this.session.getCommandManager();
            List<BaseCommandProcessor> processors = cmdMgr.getProcessors();
            for (i = 0; i < processors.size(); ++i) {
                this.write("Loading Command Processor..." + processors.toString() + System.getProperty("line.separator"));
                this.cmd = processors.get(i);
                this.cmd.init();
                this.cmd.addCommands(reg);
                this.cmd.start();
            }
            block8: while (true) {
                i = 0;
                while (true) {
                    if (i >= processors.size()) continue block8;
                    this.cmd = processors.get(i);
                    if (this.cmd.isTerminated()) break block8;
                    Thread.sleep(100L);
                    ++i;
                }
                break;
            }
            logger.info((Object)"- OpenAS2 Stopped -");
        }
        catch (Exception e) {
            exitStatus = -1;
            e.printStackTrace();
        }
        catch (Error err) {
            exitStatus = -1;
            err.printStackTrace();
        }
        finally {
            this.shutdown();
            System.exit(exitStatus);
        }
    }

    public void shutdown() {
        if (this.session != null) {
            try {
                this.session.getProcessor().stopActiveModules();
            }
            catch (OpenAS2Exception same) {
                same.terminate();
            }
        }
        if (this.cmd != null) {
            try {
                this.cmd.deInit();
            }
            catch (OpenAS2Exception cdie) {
                cdie.terminate();
            }
        }
        this.write("OpenAS2 has shut down\r\n");
    }

    public void write(String msg) {
        if (this.sysOut == null) {
            this.sysOut = new BufferedWriter(new OutputStreamWriter(System.out));
        }
        try {
            this.sysOut.write(msg);
            this.sysOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

