/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openas2.Component;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.cmd.Command;
import org.openas2.cmd.CommandRegistry;
import org.openas2.cmd.processor.CommandProcessor;

public abstract class BaseCommandProcessor
extends Thread
implements CommandProcessor,
Component {
    private List<Command> commands;
    private boolean terminated = false;

    @Override
    public Map<String, String> getParameters() {
        return null;
    }

    @Override
    public Session getSession() {
        return null;
    }

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
    }

    public void setCommands(List<Command> list) {
        this.commands = list;
    }

    @Override
    public List<Command> getCommands() {
        if (this.commands == null) {
            this.commands = new ArrayList<Command>();
        }
        return this.commands;
    }

    public Command getCommand(String name) {
        for (Command currentCmd : this.getCommands()) {
            if (!currentCmd.getName().equals(name)) continue;
            return currentCmd;
        }
        return null;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public void processCommand() throws OpenAS2Exception {
        throw new OpenAS2Exception("super class method call, not initialized correctly");
    }

    @Override
    public void addCommands(CommandRegistry reg) {
        List<Command> regCmds = reg.getCommands();
        if (regCmds.size() > 0) {
            this.getCommands().addAll(regCmds);
        }
    }

    @Override
    public void terminate() {
        this.terminated = true;
    }
}

