/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.message;

import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.openas2.lib.message.EDIINTMessage;

public class AS2Message
extends EDIINTMessage {
    public AS2Message() {
    }

    public AS2Message(MimeBodyPart data, String contentType) throws MessagingException {
        super(data, contentType);
    }

    public AS2Message(InputStream in) throws IOException, MessagingException {
        super(in);
    }

    @Override
    public String getSenderIDHeader() {
        return "AS2-From";
    }

    @Override
    public String getReceiverIDHeader() {
        return "AS2-To";
    }

    public void setAS2From(String from) {
        this.setHeader("AS2-From", from);
    }

    public String getAS2From() {
        return this.getHeader("AS2-From");
    }

    public void setAS2To(String to) {
        this.setHeader("AS2-To", to);
    }

    public String getAS2To() {
        return this.getHeader("AS2-To");
    }

    public void setAS2Version(String version) {
        this.setHeader("AS2-Version", version);
    }

    public String getAS2Version() {
        return this.getHeader("AS2-Version");
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        this.setAS2Version("1.1");
        this.setUserAgent("OpenAS2");
        this.setServer("OpenAS2 v1.0");
    }

    public void setDispositionNotificationOptions(String options) {
        this.setHeader("Disposition-Notification-Options", options);
    }

    public String getDispositionNotificationOptions() {
        return this.getHeader("Disposition-Notification-Options");
    }

    public void setDispositionNotificationTo(String to) {
        this.setHeader("Disposition-Notification-To", to);
    }

    public String getDispositionNotificationTo() {
        return this.getHeader("Disposition-Notification-To");
    }

    public void setReceiptDeliveryOption(String option) {
        this.setHeader("Receipt-Delivery-Option", option);
    }

    public String getReceiptDeliveryOption() {
        return this.getHeader("Receipt-Delivery-Option");
    }

    public void setRecipientAddress(String address) {
        this.setHeader("Recipient-Address", address);
    }

    public String getRecipientAddress() {
        return this.getHeader("Recipient-Address");
    }

    public void setServer(String server) {
        this.setHeader("Server", server);
    }

    public String getServer() {
        return this.getHeader("Server");
    }

    public void setUserAgent(String agent) {
        this.setHeader("User-Agent", agent);
    }

    public String getUserAgent() {
        return this.getHeader("User-Agent");
    }
}

